/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.hibernate4.management;

import org.hibernate.stat.CollectionStatistics;
import org.jboss.as.controller.AbstractRuntimeOnlyHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.jpa.hibernate4.management.ManagementLookup;
import org.jboss.as.jpa.spi.PersistenceUnitServiceRegistry;
import org.jboss.dmr.ModelNode;

public abstract class CollectionMetricsHandler
extends AbstractRuntimeOnlyHandler {
    private final PersistenceUnitServiceRegistry persistenceUnitRegistry;

    private CollectionMetricsHandler(PersistenceUnitServiceRegistry persistenceUnitRegistry) {
        this.persistenceUnitRegistry = persistenceUnitRegistry;
    }

    protected void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
        CollectionStatistics statistics = this.collectionStatistics(operation);
        if (statistics != null) {
            this.handle(statistics, context, operation.require("name").asString());
        }
        context.stepCompleted();
    }

    protected abstract void handle(CollectionStatistics var1, OperationContext var2, String var3);

    private CollectionStatistics collectionStatistics(ModelNode operation) {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
        String puResourceName = address.getElement(address.size() - 2).getValue();
        String roleName = address.getLastElement().getValue();
        ManagementLookup stats = ManagementLookup.create(this.persistenceUnitRegistry, puResourceName);
        return stats == null ? null : stats.getStatistics().getCollectionStatistics(roleName);
    }

    static final CollectionMetricsHandler getLoadCount(PersistenceUnitServiceRegistry persistenceUnitRegistry) {
        return new CollectionMetricsHandler(persistenceUnitRegistry){

            @Override
            protected void handle(CollectionStatistics statistics, OperationContext context, String attributeName) {
                long count = statistics.getLoadCount();
                context.getResult().set(count);
            }
        };
    }

    static final CollectionMetricsHandler getFetchCount(PersistenceUnitServiceRegistry persistenceUnitRegistry) {
        return new CollectionMetricsHandler(persistenceUnitRegistry){

            @Override
            protected void handle(CollectionStatistics statistics, OperationContext context, String attributeName) {
                long count = statistics.getFetchCount();
                context.getResult().set(count);
            }
        };
    }

    static final CollectionMetricsHandler getRecreateCount(PersistenceUnitServiceRegistry persistenceUnitRegistry) {
        return new CollectionMetricsHandler(persistenceUnitRegistry){

            @Override
            protected void handle(CollectionStatistics statistics, OperationContext context, String attributeName) {
                long count = statistics.getRecreateCount();
                context.getResult().set(count);
            }
        };
    }

    static final CollectionMetricsHandler getRemoveCount(PersistenceUnitServiceRegistry persistenceUnitRegistry) {
        return new CollectionMetricsHandler(persistenceUnitRegistry){

            @Override
            protected void handle(CollectionStatistics statistics, OperationContext context, String attributeName) {
                long count = statistics.getRemoveCount();
                context.getResult().set(count);
            }
        };
    }

    static final CollectionMetricsHandler getUpdateCount(PersistenceUnitServiceRegistry persistenceUnitRegistry) {
        return new CollectionMetricsHandler(persistenceUnitRegistry){

            @Override
            protected void handle(CollectionStatistics statistics, OperationContext context, String attributeName) {
                long count = statistics.getUpdateCount();
                context.getResult().set(count);
            }
        };
    }
}

