/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.jms.client;

import java.io.Serializable;
import java.util.UUID;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import org.hornetq.api.core.Pair;
import org.hornetq.api.core.SimpleString;
import org.hornetq.jms.client.HornetQQueue;
import org.hornetq.jms.client.HornetQSession;
import org.hornetq.jms.client.HornetQTemporaryQueue;
import org.hornetq.jms.client.HornetQTemporaryTopic;
import org.hornetq.jms.client.HornetQTopic;
import org.hornetq.jms.referenceable.DestinationObjectFactory;
import org.hornetq.jms.referenceable.SerializableObjectRefAddr;

public class HornetQDestination
implements Destination,
Serializable,
Referenceable {
    private static final long serialVersionUID = 5027962425462382883L;
    public static final String JMS_QUEUE_ADDRESS_PREFIX = "jms.queue.";
    public static final String JMS_TEMP_QUEUE_ADDRESS_PREFIX = "jms.tempqueue.";
    public static final String JMS_TOPIC_ADDRESS_PREFIX = "jms.topic.";
    public static final String JMS_TEMP_TOPIC_ADDRESS_PREFIX = "jms.temptopic.";
    private static final char SEPARATOR = '.';
    protected final String name;
    private final String address;
    private final SimpleString simpleAddress;
    private final boolean temporary;
    private final boolean queue;
    private final transient HornetQSession session;

    protected static String escape(String input) {
        if (input == null) {
            return "";
        }
        return input.replace("\\", "\\\\").replace(".", "\\.");
    }

    public static Destination fromAddress(String address) {
        if (address.startsWith(JMS_QUEUE_ADDRESS_PREFIX)) {
            String name = address.substring(JMS_QUEUE_ADDRESS_PREFIX.length());
            return HornetQDestination.createQueue(name);
        }
        if (address.startsWith(JMS_TOPIC_ADDRESS_PREFIX)) {
            String name = address.substring(JMS_TOPIC_ADDRESS_PREFIX.length());
            return HornetQDestination.createTopic(name);
        }
        if (address.startsWith(JMS_TEMP_QUEUE_ADDRESS_PREFIX)) {
            String name = address.substring(JMS_TEMP_QUEUE_ADDRESS_PREFIX.length());
            return new HornetQTemporaryQueue(address, name, null);
        }
        if (address.startsWith(JMS_TEMP_TOPIC_ADDRESS_PREFIX)) {
            String name = address.substring(JMS_TEMP_TOPIC_ADDRESS_PREFIX.length());
            return new HornetQTemporaryTopic(address, name, null);
        }
        throw new IllegalArgumentException("Invalid address " + address);
    }

    public static String createQueueNameForDurableSubscription(String clientID, String subscriptionName) {
        return HornetQDestination.escape(clientID) + '.' + HornetQDestination.escape(subscriptionName);
    }

    public static Pair<String, String> decomposeQueueNameForDurableSubscription(String queueName) {
        StringBuffer[] parts = new StringBuffer[2];
        int currentPart = 0;
        parts[0] = new StringBuffer();
        parts[1] = new StringBuffer();
        int pos = 0;
        while (pos < queueName.length()) {
            char ch = queueName.charAt(pos);
            ++pos;
            if (ch == '.') {
                if (++currentPart < parts.length) continue;
                throw new IllegalArgumentException("Invalid message queue name: " + queueName);
            }
            if (ch == '\\') {
                if (pos >= queueName.length()) {
                    throw new IllegalArgumentException("Invalid message queue name: " + queueName);
                }
                ch = queueName.charAt(pos);
                ++pos;
            }
            parts[currentPart].append(ch);
        }
        if (currentPart != 1) {
            throw new IllegalArgumentException("Invalid message queue name: " + queueName);
        }
        Pair<String, String> pair = new Pair<String, String>(parts[0].toString(), parts[1].toString());
        return pair;
    }

    public static SimpleString createQueueAddressFromName(String name) {
        return new SimpleString(JMS_QUEUE_ADDRESS_PREFIX + name);
    }

    public static SimpleString createTopicAddressFromName(String name) {
        return new SimpleString(JMS_TOPIC_ADDRESS_PREFIX + name);
    }

    public static HornetQQueue createQueue(String name) {
        return new HornetQQueue(name);
    }

    public static HornetQTopic createTopic(String name) {
        return new HornetQTopic(name);
    }

    public static HornetQTemporaryQueue createTemporaryQueue(String name, HornetQSession session) {
        return new HornetQTemporaryQueue(JMS_TEMP_QUEUE_ADDRESS_PREFIX.concat(name), name, session);
    }

    public static HornetQTemporaryQueue createTemporaryQueue(String name) {
        return HornetQDestination.createTemporaryQueue(name, null);
    }

    public static HornetQTemporaryQueue createTemporaryQueue(HornetQSession session) {
        String name = UUID.randomUUID().toString();
        return HornetQDestination.createTemporaryQueue(name, session);
    }

    public static HornetQTemporaryTopic createTemporaryTopic(HornetQSession session) {
        String name = UUID.randomUUID().toString();
        return HornetQDestination.createTemporaryTopic(name, session);
    }

    public static HornetQTemporaryTopic createTemporaryTopic(String name, HornetQSession session) {
        return new HornetQTemporaryTopic(JMS_TEMP_TOPIC_ADDRESS_PREFIX.concat(name), name, session);
    }

    public static HornetQTemporaryTopic createTemporaryTopic(String name) {
        return HornetQDestination.createTemporaryTopic(name, null);
    }

    protected HornetQDestination(String address, String name, boolean temporary, boolean queue, HornetQSession session) {
        this.address = address;
        this.name = name;
        this.simpleAddress = new SimpleString(address);
        this.temporary = temporary;
        this.queue = queue;
        this.session = session;
    }

    @Override
    public Reference getReference() throws NamingException {
        return new Reference(this.getClass().getCanonicalName(), new SerializableObjectRefAddr("HornetQ-DEST", this), DestinationObjectFactory.class.getCanonicalName(), null);
    }

    public void delete() throws JMSException {
        if (this.session != null) {
            if (this.queue) {
                this.session.deleteTemporaryQueue(this);
            } else {
                this.session.deleteTemporaryTopic(this);
            }
        }
    }

    public boolean isQueue() {
        return this.queue;
    }

    public String getAddress() {
        return this.address;
    }

    public SimpleString getSimpleAddress() {
        return this.simpleAddress;
    }

    public String getName() {
        return this.name;
    }

    public boolean isTemporary() {
        return this.temporary;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HornetQDestination)) {
            return false;
        }
        HornetQDestination that = (HornetQDestination)o;
        return this.address.equals(that.address);
    }

    public int hashCode() {
        return this.address.hashCode();
    }
}

