/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.asyncio.impl;

import java.nio.ByteBuffer;
import java.nio.channels.FileLock;
import java.util.PriorityQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.HornetQExceptionType;
import org.hornetq.core.asyncio.AIOCallback;
import org.hornetq.core.asyncio.AsynchronousFile;
import org.hornetq.core.asyncio.BufferCallback;
import org.hornetq.core.asyncio.IOExceptionListener;
import org.hornetq.core.asyncio.impl.HornetQFileLock;
import org.hornetq.journal.HornetQJournalLogger;
import org.hornetq.utils.ReusableLatch;

public class AsynchronousFileImpl
implements AsynchronousFile {
    private static final AtomicInteger totalMaxIO;
    private static boolean loaded;
    private static final int EXPECTED_NATIVE_VERSION = 51;
    private final AtomicLong nextWritingSequence = new AtomicLong(0L);
    private long nextReadSequence = 0L;
    private final PriorityQueue<CallbackHolder> pendingCallbacks = new PriorityQueue();
    private boolean opened = false;
    private String fileName;
    private final Lock callbackLock = new ReentrantLock();
    private final ReusableLatch pollerLatch = new ReusableLatch();
    private volatile Runnable poller;
    private int maxIO;
    private final Lock writeLock = new ReentrantReadWriteLock().writeLock();
    private final ReusableLatch pendingWrites = new ReusableLatch();
    private Semaphore maxIOSemaphore;
    private BufferCallback bufferCallback;
    private final IOExceptionListener ioExceptionListener;
    private ByteBuffer handler;
    private final Executor writeExecutor;
    private final Executor pollerExecutor;

    public static void addMax(int io) {
        totalMaxIO.addAndGet(io);
    }

    public static int getTotalMaxIO() {
        return totalMaxIO.get();
    }

    public static void resetMaxAIO() {
        totalMaxIO.set(0);
    }

    private static boolean loadLibrary(String name) {
        try {
            HornetQJournalLogger.LOGGER.trace(name + " being loaded");
            System.loadLibrary(name);
            if (AsynchronousFileImpl.getNativeVersion() != 51) {
                HornetQJournalLogger.LOGGER.incompatibleNativeLibrary();
                return false;
            }
            AsynchronousFileImpl.setNanoSleepInterval(1);
            return true;
        }
        catch (Throwable e) {
            HornetQJournalLogger.LOGGER.debug(name + " -> error loading the native library", e);
            return false;
        }
    }

    public static boolean isLoaded() {
        return loaded;
    }

    public AsynchronousFileImpl(Executor writeExecutor, Executor pollerExecutor, IOExceptionListener ioExceptionListener) {
        this.writeExecutor = writeExecutor;
        this.pollerExecutor = pollerExecutor;
        this.ioExceptionListener = ioExceptionListener;
    }

    public AsynchronousFileImpl(Executor writeExecutor, Executor pollerExecutor) {
        this(writeExecutor, pollerExecutor, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open(String fileName, int maxIO) throws HornetQException {
        this.writeLock.lock();
        try {
            if (this.opened) {
                throw new IllegalStateException("AsynchronousFile is already opened");
            }
            this.maxIO = maxIO;
            this.maxIOSemaphore = new Semaphore(this.maxIO);
            this.fileName = fileName;
            try {
                this.handler = AsynchronousFileImpl.init(fileName, this.maxIO, HornetQJournalLogger.LOGGER);
            }
            catch (HornetQException e) {
                HornetQException ex = null;
                ex = e.getType() == HornetQExceptionType.NATIVE_ERROR_CANT_INITIALIZE_AIO ? new HornetQException(e.getType(), "Can't initialize AIO. Currently AIO in use = " + totalMaxIO.get() + ", trying to allocate more " + maxIO, e) : e;
                throw ex;
            }
            this.opened = true;
            AsynchronousFileImpl.addMax(this.maxIO);
            this.nextWritingSequence.set(0L);
            this.nextReadSequence = 0L;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws Exception {
        this.checkOpened();
        this.writeLock.lock();
        try {
            while (!this.pendingWrites.await(60000L)) {
                HornetQJournalLogger.LOGGER.couldNotGetLock(this.fileName);
            }
            while (!this.maxIOSemaphore.tryAcquire(this.maxIO, 60L, TimeUnit.SECONDS)) {
                HornetQJournalLogger.LOGGER.couldNotGetLock(this.fileName);
            }
            this.maxIOSemaphore = null;
            if (this.poller != null) {
                this.stopPoller();
            }
            if (this.handler != null) {
                AsynchronousFileImpl.closeInternal(this.handler);
                AsynchronousFileImpl.addMax(-this.maxIO);
            }
            this.opened = false;
            this.handler = null;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void writeInternal(long positionToWrite, long size, ByteBuffer bytes) throws HornetQException {
        try {
            this.writeInternal(this.handler, positionToWrite, size, bytes);
        }
        catch (HornetQException e) {
            this.fireExceptionListener(e.getType().getCode(), e.getMessage());
            throw e;
        }
        if (this.bufferCallback != null) {
            this.bufferCallback.bufferDone(bytes);
        }
    }

    @Override
    public void write(final long position, final long size, final ByteBuffer directByteBuffer, final AIOCallback aioCallback) {
        if (aioCallback == null) {
            throw new NullPointerException("Null Callback");
        }
        this.checkOpened();
        if (this.poller == null) {
            this.startPoller();
        }
        this.pendingWrites.countUp();
        if (this.writeExecutor != null) {
            this.maxIOSemaphore.acquireUninterruptibly();
            this.writeExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    long sequence = AsynchronousFileImpl.this.nextWritingSequence.getAndIncrement();
                    try {
                        AsynchronousFileImpl.this.write(AsynchronousFileImpl.this.handler, sequence, position, size, directByteBuffer, aioCallback);
                    }
                    catch (HornetQException e) {
                        AsynchronousFileImpl.this.callbackError(aioCallback, sequence, directByteBuffer, e.getType().getCode(), e.getMessage());
                    }
                    catch (RuntimeException e) {
                        AsynchronousFileImpl.this.callbackError(aioCallback, sequence, directByteBuffer, HornetQExceptionType.INTERNAL_ERROR.getCode(), e.getMessage());
                    }
                }
            });
        } else {
            this.maxIOSemaphore.acquireUninterruptibly();
            long sequence = this.nextWritingSequence.getAndIncrement();
            try {
                this.write(this.handler, sequence, position, size, directByteBuffer, aioCallback);
            }
            catch (HornetQException e) {
                this.callbackError(aioCallback, sequence, directByteBuffer, e.getType().getCode(), e.getMessage());
            }
            catch (RuntimeException e) {
                this.callbackError(aioCallback, sequence, directByteBuffer, HornetQExceptionType.INTERNAL_ERROR.getCode(), e.getMessage());
            }
        }
    }

    @Override
    public void read(long position, long size, ByteBuffer directByteBuffer, AIOCallback aioPackage) throws HornetQException {
        this.checkOpened();
        if (this.poller == null) {
            this.startPoller();
        }
        this.pendingWrites.countUp();
        this.maxIOSemaphore.acquireUninterruptibly();
        try {
            this.read(this.handler, position, size, directByteBuffer, aioPackage);
        }
        catch (HornetQException e) {
            this.maxIOSemaphore.release();
            this.pendingWrites.countDown();
            throw e;
        }
        catch (RuntimeException e) {
            this.maxIOSemaphore.release();
            this.pendingWrites.countDown();
            throw e;
        }
    }

    @Override
    public long size() throws HornetQException {
        this.checkOpened();
        return this.size0(this.handler);
    }

    @Override
    public void fill(long position, int blocks, long size, byte fillChar) throws HornetQException {
        this.checkOpened();
        AsynchronousFileImpl.fill(this.handler, position, blocks, size, fillChar);
    }

    @Override
    public int getBlockSize() {
        return 512;
    }

    public static synchronized ByteBuffer newBuffer(int size) {
        if (size % 512 != 0) {
            throw new RuntimeException("Buffer size needs to be aligned to 512");
        }
        return AsynchronousFileImpl.newNativeBuffer(size);
    }

    @Override
    public void setBufferCallback(BufferCallback callback) {
        this.bufferCallback = callback;
    }

    public ByteBuffer getHandler() {
        return this.handler;
    }

    public static void clearBuffer(ByteBuffer buffer) {
        AsynchronousFileImpl.resetBuffer(buffer, buffer.limit());
        buffer.position(0);
    }

    protected void finalize() {
        if (this.opened) {
            HornetQJournalLogger.LOGGER.fileFinalizedWhileOpen(this.fileName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void callbackDone(AIOCallback callback, long sequence, ByteBuffer buffer) {
        this.maxIOSemaphore.release();
        this.pendingWrites.countDown();
        this.callbackLock.lock();
        try {
            if (sequence == -1L) {
                callback.done();
            } else if (sequence == this.nextReadSequence) {
                ++this.nextReadSequence;
                callback.done();
                this.flushCallbacks();
            } else {
                this.pendingCallbacks.add(new CallbackHolder(sequence, callback));
            }
            if (this.bufferCallback != null && buffer != null) {
                this.bufferCallback.bufferDone(buffer);
            }
        }
        finally {
            this.callbackLock.unlock();
        }
    }

    private void flushCallbacks() {
        while (!this.pendingCallbacks.isEmpty() && this.pendingCallbacks.peek().sequence == this.nextReadSequence) {
            CallbackHolder holder = this.pendingCallbacks.poll();
            if (holder.isError()) {
                ErrorCallback error = (ErrorCallback)holder;
                holder.callback.onError(error.errorCode, error.message);
            } else {
                holder.callback.done();
            }
            ++this.nextReadSequence;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void callbackError(AIOCallback callback, long sequence, ByteBuffer buffer, int errorCode, String errorMessage) {
        HornetQJournalLogger.LOGGER.callbackError(errorMessage);
        this.fireExceptionListener(errorCode, errorMessage);
        this.maxIOSemaphore.release();
        this.pendingWrites.countDown();
        this.callbackLock.lock();
        try {
            if (sequence == -1L) {
                callback.onError(errorCode, errorMessage);
            } else if (sequence == this.nextReadSequence) {
                ++this.nextReadSequence;
                callback.onError(errorCode, errorMessage);
                this.flushCallbacks();
            } else {
                this.pendingCallbacks.add(new ErrorCallback(sequence, callback, errorCode, errorMessage));
            }
        }
        finally {
            this.callbackLock.unlock();
        }
        if (this.bufferCallback != null && buffer != null) {
            this.bufferCallback.bufferDone(buffer);
        }
    }

    private void fireExceptionListener(int errorCode, String errorMessage) {
        HornetQJournalLogger.LOGGER.ioError(errorCode, errorMessage);
        if (this.ioExceptionListener != null) {
            this.ioExceptionListener.onIOException(HornetQExceptionType.getType(errorCode).createException(errorMessage), errorMessage);
        }
    }

    private void pollEvents() {
        if (!this.opened) {
            return;
        }
        AsynchronousFileImpl.internalPollEvents(this.handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startPoller() {
        this.writeLock.lock();
        try {
            if (this.poller == null) {
                this.pollerLatch.countUp();
                this.poller = new PollerRunnable();
                try {
                    this.pollerExecutor.execute(this.poller);
                }
                catch (Exception ex) {
                    HornetQJournalLogger.LOGGER.errorStartingPoller(ex);
                }
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void checkOpened() {
        if (!this.opened) {
            throw new RuntimeException("File is not opened");
        }
    }

    private void stopPoller() throws HornetQException, InterruptedException {
        AsynchronousFileImpl.stopPoller(this.handler);
        this.pollerLatch.await();
    }

    public static FileLock lock(int handle) {
        if (AsynchronousFileImpl.flock(handle)) {
            return new HornetQFileLock(handle);
        }
        return null;
    }

    public static native int openFile(String var0);

    public static native void closeFile(int var0);

    private static native boolean flock(int var0);

    private static native void resetBuffer(ByteBuffer var0, int var1);

    public static native void destroyBuffer(ByteBuffer var0);

    public static native void setNanoSleepInterval(int var0);

    public static native void nanoSleep();

    private static native ByteBuffer newNativeBuffer(long var0);

    private static native ByteBuffer init(String var0, int var1, HornetQJournalLogger var2) throws HornetQException;

    private native long size0(ByteBuffer var1) throws HornetQException;

    private native void write(ByteBuffer var1, long var2, long var4, long var6, ByteBuffer var8, AIOCallback var9) throws HornetQException;

    private native void writeInternal(ByteBuffer var1, long var2, long var4, ByteBuffer var6) throws HornetQException;

    private native void read(ByteBuffer var1, long var2, long var4, ByteBuffer var6, AIOCallback var7) throws HornetQException;

    private static native void fill(ByteBuffer var0, long var1, int var3, long var4, byte var6) throws HornetQException;

    private static native void closeInternal(ByteBuffer var0) throws HornetQException;

    private static native void stopPoller(ByteBuffer var0) throws HornetQException;

    private static native int getNativeVersion();

    private static native void internalPollEvents(ByteBuffer var0);

    static {
        String[] libraries;
        totalMaxIO = new AtomicInteger(0);
        loaded = false;
        for (String library : libraries = new String[]{"HornetQAIO", "HornetQAIO64", "HornetQAIO32", "HornetQAIO_ia64"}) {
            if (AsynchronousFileImpl.loadLibrary(library)) {
                loaded = true;
                break;
            }
            HornetQJournalLogger.LOGGER.debug("Library " + library + " not found!");
        }
        if (!loaded) {
            HornetQJournalLogger.LOGGER.debug("Couldn't locate LibAIO Wrapper");
        }
    }

    private class PollerRunnable
    implements Runnable {
        PollerRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                AsynchronousFileImpl.this.pollEvents();
            }
            finally {
                AsynchronousFileImpl.this.poller = null;
                AsynchronousFileImpl.this.pollerLatch.countDown();
            }
        }
    }

    private static final class ErrorCallback
    extends CallbackHolder {
        final int errorCode;
        final String message;

        @Override
        public boolean isError() {
            return true;
        }

        public ErrorCallback(long sequence, AIOCallback callback, int errorCode, String message) {
            super(sequence, callback);
            this.errorCode = errorCode;
            this.message = message;
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            return super.equals(obj);
        }
    }

    private static class CallbackHolder
    implements Comparable<CallbackHolder> {
        final long sequence;
        final AIOCallback callback;

        public boolean isError() {
            return false;
        }

        public CallbackHolder(long sequence, AIOCallback callback) {
            this.sequence = sequence;
            this.callback = callback;
        }

        @Override
        public int compareTo(CallbackHolder o) {
            if (this == o) {
                return 0;
            }
            if (this.sequence <= o.sequence) {
                return -1;
            }
            return 1;
        }

        public int hashCode() {
            return super.hashCode();
        }

        public boolean equals(Object obj) {
            return super.equals(obj);
        }
    }
}

