/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.plugins.alertCli;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.rhq.core.domain.alert.AlertDefinition;
import org.rhq.core.domain.alert.notification.AlertNotification;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyList;
import org.rhq.core.domain.configuration.PropertyMap;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.content.PackageType;
import org.rhq.core.domain.criteria.AlertDefinitionCriteria;
import org.rhq.core.domain.criteria.Criteria;
import org.rhq.core.domain.criteria.PackageVersionCriteria;
import org.rhq.core.domain.resource.composite.DisambiguationReport;
import org.rhq.core.domain.util.DisambiguationReportRenderer;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.core.util.IntExtractor;
import org.rhq.enterprise.server.alert.AlertDefinitionManagerLocal;
import org.rhq.enterprise.server.alert.AlertNotificationManagerLocal;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.content.ContentManagerLocal;
import org.rhq.enterprise.server.plugin.pc.ControlFacet;
import org.rhq.enterprise.server.plugin.pc.ControlResults;
import org.rhq.enterprise.server.plugin.pc.ServerPluginComponent;
import org.rhq.enterprise.server.plugin.pc.ServerPluginContext;
import org.rhq.enterprise.server.resource.ResourceManagerLocal;
import org.rhq.enterprise.server.resource.disambiguation.DefaultDisambiguationUpdateStrategies;
import org.rhq.enterprise.server.resource.disambiguation.DisambiguationUpdateStrategy;
import org.rhq.enterprise.server.util.LookupUtil;
import org.rhq.enterprise.server.xmlschema.generated.serverplugin.alert.AlertPluginDescriptorType;

public class CliComponent
implements ServerPluginComponent,
ControlFacet {
    public static final String PACKAGE_TYPE_NAME = "org.rhq.enterprise.server.plugins.packagetypeCli.SERVER_SIDE_CLI_SCRIPT";
    private static final String CONTROL_CHECK_ALERTS_VALIDITY = "checkAlertsValidity";
    private static final String CONTROL_REASSIGN_ALERTS = "reassignAlerts";
    private static final String PROP_ALERT_DEFINITION_NAME = "alertDefinitionName";
    private static final String PROP_RESOURCE_PATH = "resourcePath";
    private static final String PROP_RESOURCE_ID = "resourceId";
    private static final String PROP_MISSING_USERS = "missingUsers";
    private static final String PROP_MISSING_SCRIPTS = "missingScripts";
    private static final String PROP_ALERT_DEFINITION = "alertDefinition";
    private static final String PROP_ALERT_DEFINITION_ID = "alertDefinitionId";
    private static final String PROP_USER_NAME = "userName";
    private static final String PROP_ALERT_DEF_IDS = "alertDefIds";
    private static final String PROP_SCRIPT_TIMEOUT = "scriptTimeout";
    private String pluginName;
    private PackageType packageType;
    private int scriptTimeout;

    public void initialize(ServerPluginContext context) throws Exception {
        this.pluginName = ((AlertPluginDescriptorType)context.getPluginEnvironment().getPluginDescriptor()).getShortName();
        String timeoutValue = context.getPluginConfiguration() == null ? "60" : context.getPluginConfiguration().getSimpleValue(PROP_SCRIPT_TIMEOUT, "60");
        this.scriptTimeout = Integer.parseInt(timeoutValue);
    }

    public PackageType getScriptPackageType() {
        if (this.packageType == null) {
            SubjectManagerLocal subjectManager = LookupUtil.getSubjectManager();
            ContentManagerLocal cm = LookupUtil.getContentManager();
            this.packageType = cm.findPackageType(subjectManager.getOverlord(), null, PACKAGE_TYPE_NAME);
        }
        return this.packageType;
    }

    public int getScriptTimeout() {
        return this.scriptTimeout;
    }

    public void start() {
    }

    public void stop() {
    }

    public void shutdown() {
    }

    public ControlResults invoke(String name, Configuration parameters) {
        ControlResults results = new ControlResults();
        try {
            if (CONTROL_CHECK_ALERTS_VALIDITY.equals(name)) {
                this.checkAlertsValidity(results, parameters);
            } else if (CONTROL_REASSIGN_ALERTS.equals(name)) {
                this.reassignAlerts(results, parameters);
            }
        }
        catch (Exception e) {
            results.setError((Throwable)e);
        }
        return results;
    }

    private void checkAlertsValidity(ControlResults results, Configuration parameters) {
        List<AlertNotification> allCliNotifications = this.getAllCliNotifications(null);
        Configuration resConfig = results.getComplexResults();
        PropertyList missingUsersList = new PropertyList(PROP_MISSING_USERS);
        resConfig.put((Property)missingUsersList);
        List<AlertNotification> invalidNotifs = this.getCliNotificationsWithInvalidUser(allCliNotifications);
        this.convertNotificationsToInvalidAlertDefResults(missingUsersList, invalidNotifs);
        PropertyList missingScriptsList = new PropertyList(PROP_MISSING_SCRIPTS);
        resConfig.put((Property)missingScriptsList);
        invalidNotifs = this.getCliNotificationsWithInvalidPackage(allCliNotifications);
        this.convertNotificationsToInvalidAlertDefResults(missingScriptsList, invalidNotifs);
        ArrayList allMissing = new ArrayList();
        allMissing.addAll(missingUsersList.getList());
        allMissing.addAll(missingScriptsList.getList());
        if (allMissing.size() > 0) {
            ResourceManagerLocal resourceManager = LookupUtil.getResourceManager();
            List disambiguated = resourceManager.disambiguate(allMissing, (IntExtractor)new IntExtractor<Property>(){

                public int extract(Property object) {
                    PropertyMap map = (PropertyMap)object;
                    return map.getSimple(CliComponent.PROP_RESOURCE_ID).getIntegerValue();
                }
            }, (DisambiguationUpdateStrategy)DefaultDisambiguationUpdateStrategies.KEEP_ALL_PARENTS);
            DisambiguationReportRenderer renderer = new DisambiguationReportRenderer();
            for (DisambiguationReport r : disambiguated) {
                PropertyMap map = (PropertyMap)r.getOriginal();
                String resourcePath = renderer.render(r);
                map.put((Property)new PropertySimple(PROP_RESOURCE_PATH, (Object)resourcePath));
            }
        }
    }

    private void reassignAlerts(ControlResults results, Configuration parameters) {
        PropertySimple userNameProp = parameters.getSimple(PROP_USER_NAME);
        PropertySimple alertDefIdsProp = parameters.getSimple(PROP_ALERT_DEF_IDS);
        if (userNameProp == null || userNameProp.getStringValue() == null || userNameProp.getStringValue().trim().length() == 0) {
            throw new IllegalArgumentException("User name not specified.");
        }
        String userName = userNameProp.getStringValue();
        SubjectManagerLocal subjectManager = LookupUtil.getSubjectManager();
        Subject subject = subjectManager.getSubjectByName(userName);
        if (subject == null) {
            throw new IllegalArgumentException("User '" + userName + "' doesn't exist.");
        }
        List<AlertNotification> notifsToReAssign = null;
        if (alertDefIdsProp == null || alertDefIdsProp.getStringValue() == null || alertDefIdsProp.getStringValue().trim().length() == 0) {
            notifsToReAssign = this.getCliNotificationsWithInvalidUser(this.getAllCliNotifications(null));
        } else {
            List<Integer> alertDefIds = this.asIdList(alertDefIdsProp.getStringValue().split("\\s*,\\s*"));
            List<AlertDefinition> defs = this.getAlertDefinitionsWithCliNotifications(alertDefIds);
            notifsToReAssign = new ArrayList<AlertNotification>();
            for (AlertDefinition def : defs) {
                for (AlertNotification cliNotif : this.getCliNotifications(def.getAlertNotifications())) {
                    notifsToReAssign.add(cliNotif);
                }
            }
        }
        AlertNotificationManagerLocal notificationManager = LookupUtil.getAlertNotificationManager();
        List<Integer> notifIds = this.asIdList(notifsToReAssign);
        Map<String, String> updates = Collections.singletonMap("userId", Integer.toString(subject.getId()));
        notificationManager.massReconfigure(notifIds, updates);
    }

    private List<AlertNotification> getCliNotifications(List<AlertNotification> notifications) {
        ArrayList<AlertNotification> ret = new ArrayList<AlertNotification>();
        for (AlertNotification n : notifications) {
            if (!this.pluginName.equals(n.getSenderName())) continue;
            ret.add(n);
        }
        return ret;
    }

    private List<AlertDefinition> getAlertDefinitionsWithCliNotifications(Collection<Integer> alertDefIds) {
        SubjectManagerLocal subjectManager = LookupUtil.getSubjectManager();
        AlertDefinitionManagerLocal manager = LookupUtil.getAlertDefinitionManager();
        Subject overlord = subjectManager.getOverlord();
        AlertDefinitionCriteria criteria = new AlertDefinitionCriteria();
        criteria.addFilterNotificationNames(new String[]{this.pluginName});
        criteria.setPageControl(PageControl.getUnlimitedInstance());
        criteria.fetchAlertNotifications(true);
        if (alertDefIds != null) {
            criteria.addFilterIds(alertDefIds.toArray(new Integer[alertDefIds.size()]));
        }
        return manager.findAlertDefinitionsByCriteria(overlord, criteria);
    }

    private List<AlertNotification> getAllCliNotifications(Collection<Integer> alertDefIds) {
        ArrayList<AlertNotification> ret = new ArrayList<AlertNotification>();
        List<AlertDefinition> defs = this.getAlertDefinitionsWithCliNotifications(alertDefIds);
        for (AlertDefinition def : defs) {
            List notifications = def.getAlertNotifications();
            ret.addAll(this.getCliNotifications(notifications));
        }
        return ret;
    }

    private List<AlertNotification> getCliNotificationsWithInvalidUser(List<AlertNotification> allNotifications) {
        ArrayList<AlertNotification> ret = new ArrayList<AlertNotification>();
        SubjectManagerLocal subjectManager = LookupUtil.getSubjectManager();
        for (AlertNotification cliNotification : allNotifications) {
            Subject checkSubject = null;
            PropertySimple subjectIdProperty = cliNotification.getConfiguration().getSimple("userId");
            if (subjectIdProperty != null) {
                int subjectId = subjectIdProperty.getIntegerValue();
                checkSubject = subjectManager.getSubjectById(subjectId);
            }
            if (checkSubject != null) continue;
            ret.add(cliNotification);
        }
        return ret;
    }

    private List<AlertNotification> getCliNotificationsWithInvalidPackage(List<AlertNotification> allNotifications) {
        ArrayList<AlertNotification> ret = new ArrayList<AlertNotification>();
        ContentManagerLocal contentManager = LookupUtil.getContentManager();
        SubjectManagerLocal subjectManager = LookupUtil.getSubjectManager();
        Subject overlord = subjectManager.getOverlord();
        PackageVersionCriteria crit = new PackageVersionCriteria();
        crit.setRestriction(Criteria.Restriction.COUNT_ONLY);
        for (AlertNotification cliNotification : allNotifications) {
            int count = 0;
            String packageId = cliNotification.getConfiguration().getSimpleValue("packageId", null);
            if (packageId != null) {
                crit.addFilterPackageId(Integer.valueOf(packageId));
                PageList res = contentManager.findPackageVersionsByCriteria(overlord, crit);
                count = res.getTotalSize();
            }
            if (count != 0) continue;
            ret.add(cliNotification);
        }
        return ret;
    }

    private void convertNotificationsToInvalidAlertDefResults(PropertyList results, List<AlertNotification> invalidNotifications) {
        HashSet<AlertDefinition> processedDefs = new HashSet<AlertDefinition>();
        for (AlertNotification cliNotification : invalidNotifications) {
            AlertDefinition def = cliNotification.getAlertDefinition();
            if (!processedDefs.add(def)) continue;
            PropertyMap alertDefinitionMap = new PropertyMap(PROP_ALERT_DEFINITION);
            alertDefinitionMap.put((Property)new PropertySimple(PROP_ALERT_DEFINITION_ID, (Object)def.getId()));
            alertDefinitionMap.put((Property)new PropertySimple(PROP_ALERT_DEFINITION_NAME, (Object)def.getName()));
            alertDefinitionMap.put((Property)new PropertySimple(PROP_RESOURCE_ID, (Object)def.getResource().getId()));
            results.add((Property)alertDefinitionMap);
        }
    }

    private List<Integer> asIdList(String ... ids) {
        ArrayList<Integer> ret = new ArrayList<Integer>();
        for (String id : ids) {
            ret.add(Integer.parseInt(id));
        }
        return ret;
    }

    private List<Integer> asIdList(Collection<AlertNotification> notifs) {
        ArrayList<Integer> ret = new ArrayList<Integer>();
        for (AlertNotification n : notifs) {
            ret.add(n.getId());
        }
        return ret;
    }
}

