/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jmx.util;

public class JvmResourceKey {
    private String mainClassName;
    private String explicitValue;
    private Integer jmxRemotingPort;
    private String connectorAddress;
    private transient Type type;

    public static JvmResourceKey fromExplicitValue(String mainClassName, String explicitValue) {
        JvmResourceKey instance = new JvmResourceKey(mainClassName);
        instance.explicitValue = explicitValue;
        instance.type = Type.Explicit;
        return instance;
    }

    public static JvmResourceKey fromJmxRemotingPort(String mainClassName, int jmxRemotingPort) {
        JvmResourceKey instance = new JvmResourceKey(mainClassName);
        instance.jmxRemotingPort = jmxRemotingPort;
        instance.type = mainClassName != null ? Type.JmxRemotingPort : Type.Legacy;
        return instance;
    }

    public static JvmResourceKey fromConnectorAddress(String connectorAddress) {
        JvmResourceKey instance = new JvmResourceKey(null);
        instance.connectorAddress = connectorAddress;
        instance.type = Type.ConnectorAddress;
        return instance;
    }

    public static JvmResourceKey valueOf(String string) {
        JvmResourceKey instance;
        if (string.contains("{") && string.endsWith("}")) {
            String mainClassName = string.substring(0, string.indexOf(123));
            String explicitValue = string.substring(string.indexOf(123) + 1, string.length() - 1);
            instance = JvmResourceKey.fromExplicitValue(mainClassName, explicitValue);
        } else if (string.contains("(") && string.endsWith(")")) {
            String mainClassName = string.substring(0, string.indexOf(40));
            String value = string.substring(string.indexOf(40) + 1, string.length() - 1);
            int jmxRemotingPort = Integer.parseInt(value);
            instance = JvmResourceKey.fromJmxRemotingPort(mainClassName, jmxRemotingPort);
        } else {
            try {
                int jmxRemotingPort = Integer.parseInt(string);
                instance = JvmResourceKey.fromJmxRemotingPort(null, jmxRemotingPort);
            }
            catch (NumberFormatException e) {
                instance = JvmResourceKey.fromConnectorAddress(string);
            }
        }
        return instance;
    }

    public String getMainClassName() {
        return this.mainClassName;
    }

    public String getExplicitValue() {
        return this.explicitValue;
    }

    public Integer getJmxRemotingPort() {
        return this.jmxRemotingPort;
    }

    public String getConnectorAddress() {
        return this.connectorAddress;
    }

    public Type getType() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JvmResourceKey that = (JvmResourceKey)o;
        if (this.connectorAddress != null ? !this.connectorAddress.equals(that.connectorAddress) : that.connectorAddress != null) {
            return false;
        }
        if (this.explicitValue != null ? !this.explicitValue.equals(that.explicitValue) : that.explicitValue != null) {
            return false;
        }
        if (this.jmxRemotingPort != null ? !this.jmxRemotingPort.equals(that.jmxRemotingPort) : that.jmxRemotingPort != null) {
            return false;
        }
        return !(this.mainClassName != null ? !this.mainClassName.equals(that.mainClassName) : that.mainClassName != null);
    }

    public int hashCode() {
        int result = this.mainClassName != null ? this.mainClassName.hashCode() : 0;
        result = 31 * result + (this.explicitValue != null ? this.explicitValue.hashCode() : 0);
        result = 31 * result + (this.jmxRemotingPort != null ? this.jmxRemotingPort.hashCode() : 0);
        result = 31 * result + (this.connectorAddress != null ? this.connectorAddress.hashCode() : 0);
        return result;
    }

    public String toString() {
        String string;
        switch (this.type) {
            case Legacy: {
                string = this.jmxRemotingPort.toString();
                break;
            }
            case ConnectorAddress: {
                string = this.connectorAddress;
                break;
            }
            case JmxRemotingPort: {
                string = this.mainClassName + "(" + this.jmxRemotingPort + ")";
                break;
            }
            case Explicit: {
                string = this.mainClassName + "{" + this.explicitValue + "}";
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported key type: " + (Object)((Object)this.type));
            }
        }
        return string;
    }

    private JvmResourceKey(String mainClassName) {
        this.mainClassName = mainClassName;
    }

    public static enum Type {
        Legacy,
        ConnectorAddress,
        JmxRemotingPort,
        Explicit;

    }
}

