/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.beanvalidation;

import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import org.jboss.as.ee.beanvalidation.SecurityActions;
import org.jboss.as.naming.ContextListAndJndiViewManagedReferenceFactory;
import org.jboss.as.naming.ContextListManagedReferenceFactory;
import org.jboss.as.naming.ManagedReference;
import org.jboss.as.naming.ValueManagedReference;
import org.jboss.msc.value.ImmediateValue;
import org.jboss.msc.value.Value;

final class ValidatorJndiInjectable
implements ContextListAndJndiViewManagedReferenceFactory {
    private final ValidatorFactory factory;

    public ValidatorJndiInjectable(ValidatorFactory factory) {
        this.factory = factory;
    }

    public ManagedReference getReference() {
        return new ValueManagedReference((Value)new ImmediateValue((Object)this.factory.getValidator()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getInstanceSafely() {
        ClassLoader cl = SecurityActions.getContextClassLoader();
        try {
            SecurityActions.setContextClassLoader(this.factory.getClass().getClassLoader());
            Validator validator = this.factory.getValidator();
            return validator;
        }
        finally {
            SecurityActions.setContextClassLoader(cl);
        }
    }

    public String getInstanceClassName() {
        Object instance = this.getInstanceSafely();
        if (instance == null) {
            return ContextListManagedReferenceFactory.DEFAULT_INSTANCE_CLASS_NAME;
        }
        return instance.getClass().getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getJndiViewInstanceValue() {
        Object instance = this.getInstanceSafely();
        if (instance == null) {
            return "null";
        }
        ClassLoader cl = SecurityActions.getContextClassLoader();
        try {
            SecurityActions.setContextClassLoader(instance.getClass().getClassLoader());
            String string = instance.toString();
            return string;
        }
        finally {
            SecurityActions.setContextClassLoader(cl);
        }
    }
}

