/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.storage.installer;

import java.io.File;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.rhq.core.util.PropertiesFileUpdate;

public enum StorageProperty {
    HOSTNAME("rhq.storage.hostname"),
    SEEDS("rhq.storage.seeds"),
    CQL_PORT("rhq.storage.cql-port"),
    JMX_PORT("rhq.storage.jmx-port"),
    GOSSIP_PORT("rhq.storage.gossip-port"),
    COMMITLOG("rhq.storage.commitlog"),
    DATA("rhq.storage.data"),
    SAVED_CACHES("rhq.storage.saved-caches"),
    HEAP_SIZE("rhq.storage.heap-size"),
    HEAP_NEW_SIZE("rhq.storage.heap-new-size"),
    STACK_SIZE("rhq.storage.stack-size"),
    VERIFY_DATA_DIRS_EMPTY("rhq.storage.verify-data-dirs-empty");

    private static final HashSet<StorageProperty> STRINGS;
    private static final HashSet<StorageProperty> INTEGERS;
    private static final HashSet<StorageProperty> BOOLEANS;
    private static final HashSet<StorageProperty> OPTIONAL;
    private String property;

    private StorageProperty(String property) {
        this.property = property;
    }

    public String property() {
        return this.property;
    }

    public String toString() {
        return this.property;
    }

    public static void validate(File storagePropertiesFile) throws Exception {
        StorageProperty.validate(storagePropertiesFile, null);
    }

    public static void validate(File storagePropertiesFile, Set<StorageProperty> additionalProperties) throws Exception {
        if (!storagePropertiesFile.isFile()) {
            throw new Exception("Properties file not found: [" + storagePropertiesFile.getAbsolutePath() + "]");
        }
        PropertiesFileUpdate pfu = new PropertiesFileUpdate(storagePropertiesFile.getAbsolutePath());
        Properties props = pfu.loadExistingProperties();
        HashMap<String, String> map = new HashMap<String, String>(props.size());
        for (Object property : props.keySet()) {
            map.put(property.toString(), props.getProperty(property.toString()));
        }
        StorageProperty.validate(map, additionalProperties);
    }

    public static void validate(Map<String, String> storageProperties) throws Exception {
        StorageProperty.validate(storageProperties, null);
    }

    public static void validate(Map<String, String> storageProperties, Set<StorageProperty> additionalProperties) throws Exception {
        String val;
        StringBuilder dataErrors = new StringBuilder();
        for (StorageProperty storageProperty : BOOLEANS) {
            val = storageProperties.get(storageProperty.property());
            if (StorageProperty.isEmpty(val) && OPTIONAL.contains((Object)storageProperty) || "true".equals(val) || "false".equals(val)) continue;
            dataErrors.append("[" + (Object)((Object)storageProperty) + "] must exist and be set 'true' or 'false' : [" + val + "]\n");
        }
        for (StorageProperty storageProperty : INTEGERS) {
            val = storageProperties.get(storageProperty.property);
            if (StorageProperty.isEmpty(val) && OPTIONAL.contains((Object)storageProperty)) continue;
            try {
                Integer.parseInt(val);
            }
            catch (NumberFormatException e) {
                dataErrors.append("[" + (Object)((Object)storageProperty) + "] must exist and be set to a number : [" + val + "]\n");
            }
        }
        HashSet<StorageProperty> requiredStringProperties = new HashSet<StorageProperty>();
        requiredStringProperties.addAll(STRINGS);
        if (null != additionalProperties) {
            requiredStringProperties.addAll(additionalProperties);
        }
        for (StorageProperty storageProperty : requiredStringProperties) {
            String val2 = storageProperties.get(storageProperty.property);
            if (!StorageProperty.isEmpty(val2)) continue;
            dataErrors.append("[" + (Object)((Object)storageProperty) + "] must exist and be set to a valid string value\n");
        }
        for (String property : storageProperties.keySet()) {
            boolean unknown = true;
            for (StorageProperty storageProperty : EnumSet.allOf(StorageProperty.class)) {
                if (!storageProperty.property.equals(property)) continue;
                unknown = false;
                break;
            }
            if (!unknown) continue;
            dataErrors.append("[" + property + "] property found in file but not recognized. Please fix or remove.\n");
        }
        if (dataErrors.length() > 0) {
            throw new Exception("Validation errors:\n" + dataErrors.toString());
        }
    }

    private static boolean isEmpty(String s) {
        return s == null || s.trim().length() == 0;
    }

    static {
        STRINGS = new HashSet();
        INTEGERS = new HashSet();
        INTEGERS.add(CQL_PORT);
        INTEGERS.add(JMX_PORT);
        INTEGERS.add(GOSSIP_PORT);
        BOOLEANS = new HashSet();
        BOOLEANS.add(VERIFY_DATA_DIRS_EMPTY);
        OPTIONAL = new HashSet();
        OPTIONAL.add(CQL_PORT);
        OPTIONAL.add(JMX_PORT);
        OPTIONAL.add(GOSSIP_PORT);
        OPTIONAL.add(VERIFY_DATA_DIRS_EMPTY);
    }
}

