/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.db.upgrade;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import mazz.i18n.Logger;
import org.rhq.core.db.DatabaseType;
import org.rhq.core.db.DbUtilsI18NFactory;
import org.rhq.core.db.upgrade.DatabaseUpgradeTask;

public class StorageNodeAddressUpgradeTask
implements DatabaseUpgradeTask {
    private final Logger log = DbUtilsI18NFactory.getLogger(StorageNodeAddressUpgradeTask.class);

    @Override
    public void execute(DatabaseType databaseType, Connection connection) throws SQLException {
        String sql = "SELECT id, address FROM rhq_storage_node";
        this.log.debug("DatabaseType.executing-sql", new Object[]{sql});
        List<Object[]> results = databaseType.executeSelectSql(connection, sql);
        Integer id = null;
        String storageNodeAddress = null;
        try {
            for (Object[] row : results) {
                id = databaseType.getInteger(row[0]);
                storageNodeAddress = (String)row[1];
                InetAddress address = InetAddress.getByName(storageNodeAddress);
                if (storageNodeAddress.equals(address.getHostAddress())) continue;
                this.log.debug("DatabaseType.generic-message", new Object[]{"Updating address for  StorageNode[id= " + id + ", ]" + "address= " + storageNodeAddress + "]"});
                String update = "UPDATE rhq_storage_node SET address = '" + address.getHostAddress() + "' " + "WHERE id = " + id;
                this.log.debug("DatabaseType.executing-sql", new Object[]{update});
                databaseType.executeSql(connection, update);
            }
        }
        catch (UnknownHostException e) {
            throw new RuntimeException("Failed to look up IP address for StorageNode[id =" + id + ", address=" + storageNodeAddress + "]", e);
        }
    }
}

