/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.web.session;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Pipeline;
import org.apache.catalina.Session;
import org.apache.catalina.Valve;
import org.jboss.as.clustering.web.BatchingManager;
import org.jboss.as.clustering.web.ClusteringNotSupportedException;
import org.jboss.as.clustering.web.DistributableSessionMetadata;
import org.jboss.as.clustering.web.DistributedCacheManager;
import org.jboss.as.clustering.web.DistributedCacheManagerFactory;
import org.jboss.as.clustering.web.IncomingDistributableSessionData;
import org.jboss.as.clustering.web.LocalDistributableSessionManager;
import org.jboss.as.clustering.web.OutgoingDistributableSessionData;
import org.jboss.as.web.WebLogger;
import org.jboss.as.web.WebMessages;
import org.jboss.as.web.session.AbstractSessionManager;
import org.jboss.as.web.session.AskSessionOutdatedSessionChecker;
import org.jboss.as.web.session.AttributeBasedClusteredSession;
import org.jboss.as.web.session.ClusteredSession;
import org.jboss.as.web.session.ClusteredSessionManager;
import org.jboss.as.web.session.ClusteredSessionValve;
import org.jboss.as.web.session.DistributableSessionManagerMBean;
import org.jboss.as.web.session.InstantSnapshotManager;
import org.jboss.as.web.session.IntervalSnapshotManager;
import org.jboss.as.web.session.JvmRouteValve;
import org.jboss.as.web.session.LockingValve;
import org.jboss.as.web.session.OutdatedSessionChecker;
import org.jboss.as.web.session.OwnedSessionUpdate;
import org.jboss.as.web.session.ReplicationStatistics;
import org.jboss.as.web.session.SessionBasedClusteredSession;
import org.jboss.as.web.session.SessionInvalidationTracker;
import org.jboss.as.web.session.SessionReplicationContext;
import org.jboss.as.web.session.SnapshotManager;
import org.jboss.as.web.session.notification.ClusteredSessionNotificationCapability;
import org.jboss.as.web.session.notification.ClusteredSessionNotificationCause;
import org.jboss.as.web.session.notification.ClusteredSessionNotificationPolicy;
import org.jboss.as.web.session.notification.IgnoreUndeployLegacyClusteredSessionNotificationPolicy;
import org.jboss.logging.Logger;
import org.jboss.marshalling.ClassResolver;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.metadata.web.jboss.PassivationConfig;
import org.jboss.metadata.web.jboss.ReplicationConfig;
import org.jboss.metadata.web.jboss.ReplicationGranularity;
import org.jboss.metadata.web.jboss.ReplicationTrigger;
import org.jboss.metadata.web.jboss.SnapshotMode;

public class DistributableSessionManager<O extends OutgoingDistributableSessionData>
extends AbstractSessionManager
implements LocalDistributableSessionManager,
ClusteredSessionManager<O>,
DistributableSessionManagerMBean,
LifecycleListener {
    private static final String info = "DistributableSessionManager/1.0";
    private static final int TOTAL_PERMITS = Integer.MAX_VALUE;
    private Logger log;
    private final DistributedCacheManager<O> distributedCacheManager;
    private SnapshotManager snapshotManager;
    private final ReplicationConfig replicationConfig;
    private final ClassResolver resolver;
    private ClusteredSessionNotificationPolicy notificationPolicy;
    private final OutdatedSessionChecker outdatedSessionChecker = new AskSessionOutdatedSessionChecker();
    private final Semaphore semaphore = new Semaphore(Integer.MAX_VALUE, true);
    private final Lock valveLock = new SemaphoreLock(this.semaphore);
    private final AtomicInteger passivatedCount = new AtomicInteger();
    private final AtomicInteger maxPassivatedCount = new AtomicInteger();
    private final boolean passivate;
    private final long passivationMinIdleTime;
    private final long passivationMaxIdleTime;
    private final boolean persistence;
    private volatile int maxUnreplicatedInterval;
    private final Map<String, OwnedSessionUpdate> unloadedSessions = new ConcurrentHashMap<String, OwnedSessionUpdate>();
    private final ConcurrentMap<String, ClusteredSession<O>> embryonicSessions = new ConcurrentHashMap<String, ClusteredSession<O>>();

    public DistributableSessionManager(DistributedCacheManagerFactory factory, JBossWebMetaData metaData, ClassResolver resolver) throws ClusteringNotSupportedException {
        super(metaData);
        Integer interval;
        PassivationConfig passivationConfig = metaData.getPassivationConfig();
        Boolean useSessionPassivation = passivationConfig != null ? passivationConfig.getUseSessionPassivation() : null;
        this.passivate = useSessionPassivation != null ? useSessionPassivation : false;
        Integer minIdleTime = passivationConfig != null ? passivationConfig.getPassivationMinIdleTime() : null;
        this.passivationMinIdleTime = minIdleTime != null && this.passivate ? (long)minIdleTime.intValue() : -1L;
        Integer maxIdleTime = passivationConfig != null ? passivationConfig.getPassivationMaxIdleTime() : null;
        this.passivationMaxIdleTime = maxIdleTime != null && this.passivate ? (long)maxIdleTime.intValue() : -1L;
        ReplicationConfig config = metaData.getReplicationConfig();
        ReplicationConfig replicationConfig = this.replicationConfig = config != null ? config : new ReplicationConfig();
        if (this.replicationConfig.getReplicationGranularity() == ReplicationGranularity.FIELD) {
            this.replicationConfig.setReplicationGranularity(ReplicationGranularity.SESSION);
        }
        this.maxUnreplicatedInterval = (interval = this.replicationConfig.getMaxUnreplicatedInterval()) != null ? interval : -1;
        this.notificationPolicy = this.createClusteredSessionNotificationPolicy();
        this.resolver = resolver;
        this.distributedCacheManager = factory.getDistributedCacheManager((LocalDistributableSessionManager)this);
        this.persistence = this.distributedCacheManager.isPersistenceEnabled();
    }

    @Override
    public synchronized void start() throws LifecycleException {
        if (this.started) {
            return;
        }
        this.log = Logger.getLogger((String)(this.getClass().getName() + "." + this.getContainer().getName().replaceAll("/", "")));
        super.start();
        this.notificationPolicy = this.createClusteredSessionNotificationPolicy();
        try {
            this.distributedCacheManager.start();
            this.initializeUnloadedSessions();
            this.snapshotManager = this.createSnapshotManager();
            this.snapshotManager.start();
            this.installValves();
            this.log.debug((Object)"start(): DistributedCacheManager started");
        }
        catch (Exception e) {
            throw new LifecycleException(WebMessages.MESSAGES.failToStartManager(), (Throwable)e);
        }
        Container container = this.getContainer();
        if (container instanceof Lifecycle) {
            LifecycleListener[] listeners;
            Lifecycle lifecycle = (Lifecycle)container;
            for (LifecycleListener listener : listeners = lifecycle.findLifecycleListeners()) {
                lifecycle.removeLifecycleListener(listener);
            }
            lifecycle.addLifecycleListener((LifecycleListener)this);
            for (LifecycleListener listener : listeners) {
                lifecycle.addLifecycleListener(listener);
            }
        }
        if (!this.semaphore.tryAcquire()) {
            this.log.debug((Object)"Opening up LockingValve");
            this.semaphore.release(Integer.MAX_VALUE);
        } else {
            this.semaphore.release();
        }
    }

    protected void installValves() {
        this.log.debug((Object)"Adding LockingValve");
        this.installContextValve((Valve)new LockingValve(this.valveLock));
        if (this.getUseJK()) {
            this.log.debug((Object)"We are using JK for load-balancing. Adding JvmRouteValve.");
            this.installContextValve((Valve)new JvmRouteValve(this));
        }
        ClusteredSessionValve valve = new ClusteredSessionValve(this, null);
        this.log.debug((Object)"Adding ClusteredSessionValve");
        this.installContextValve((Valve)valve);
    }

    private void installContextValve(Valve valve) {
        if (this.container instanceof Pipeline) {
            ((Pipeline)this.container).addValve(valve);
        } else {
            this.container.getPipeline().addValve(valve);
        }
    }

    protected SnapshotManager createSnapshotManager() {
        String ctxPath = ((Context)this.container).getPath();
        switch (this.getSnapshotMode()) {
            case INTERVAL: {
                int interval = this.getSnapshotInterval();
                if (interval > 0) {
                    return new IntervalSnapshotManager(this, ctxPath, interval);
                }
                WebLogger.WEB_SESSION_LOGGER.invalidSnapshotInterval();
            }
            case INSTANT: {
                return new InstantSnapshotManager(this, ctxPath);
            }
        }
        throw WebMessages.MESSAGES.invalidSnapshotMode();
    }

    protected void initializeUnloadedSessions() {
        Map sessions = this.distributedCacheManager.getSessionIds();
        if (sessions != null) {
            String realId;
            boolean passivate = this.isPassivationEnabled();
            long passivationMax = this.passivationMaxIdleTime * 1000L;
            long passivationMin = this.passivationMinIdleTime * 1000L;
            for (Map.Entry entry : sessions.entrySet()) {
                realId = (String)entry.getKey();
                String owner = (String)entry.getValue();
                long ts = -1L;
                DistributableSessionMetadata md = null;
                try {
                    IncomingDistributableSessionData sessionData = this.distributedCacheManager.getSessionData(realId, owner, false);
                    if (sessionData == null) {
                        this.log.debugf("Metadata unavailable for unloaded session %s", (Object)realId);
                        continue;
                    }
                    ts = sessionData.getTimestamp();
                    md = sessionData.getMetadata();
                }
                catch (Exception e) {
                    this.log.debug((Object)("Problem reading metadata for session " + realId + " -- " + e.toString()), (Throwable)e);
                }
                long lastMod = ts == -1L ? System.currentTimeMillis() : ts;
                int maxLife = md == null ? this.getMaxInactiveInterval() : md.getMaxInactiveInterval();
                OwnedSessionUpdate osu = new OwnedSessionUpdate(owner, lastMod, maxLife, false);
                this.unloadedSessions.put(realId, osu);
            }
            if (passivate) {
                for (Map.Entry<Object, Object> entry : this.unloadedSessions.entrySet()) {
                    realId = (String)entry.getKey();
                    OwnedSessionUpdate osu = (OwnedSessionUpdate)entry.getValue();
                    try {
                        long elapsed = System.currentTimeMillis() - osu.getUpdateTime();
                        if (passivationMax >= 0L && elapsed > passivationMax) {
                            this.log.tracef("Elapsed time of %d for session %s exceeds max of %d; passivating", (Object)elapsed, (Object)realId, (Object)passivationMax);
                            this.processUnloadedSessionPassivation(realId, osu);
                            continue;
                        }
                        if (this.maxActiveAllowed <= 0 || passivationMin < 0L || this.calcActiveSessions() <= this.maxActiveAllowed || elapsed < passivationMin) continue;
                        this.log.tracef("Elapsed time of %d for session %s exceeds min of %d; passivating", (Object)elapsed, (Object)realId, (Object)passivationMin);
                        this.processUnloadedSessionPassivation(realId, osu);
                    }
                    catch (Exception e) {
                        this.log.debugf("Problem passivating session %s -- %s", (Object)realId, (Object)e);
                    }
                }
            }
        }
    }

    private void processUnloadedSessionPassivation(String realId, OwnedSessionUpdate osu) {
        this.log.tracef("Passivating session with id: %s", (Object)realId);
        this.distributedCacheManager.evictSession(realId, osu.getOwner());
        osu.setPassivated(true);
        this.sessionPassivated();
    }

    private void sessionPassivated() {
        int pc = this.passivatedCount.incrementAndGet();
        int max = this.maxPassivatedCount.get();
        while (pc > max) {
            if (this.maxPassivatedCount.compareAndSet(max, pc)) continue;
            max = this.maxPassivatedCount.get();
        }
    }

    protected ClusteredSessionNotificationPolicy createClusteredSessionNotificationPolicy() {
        String policyClass = this.replicationConfig.getSessionNotificationPolicy();
        if (policyClass == null || policyClass.isEmpty()) {
            policyClass = AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return System.getProperty("jboss.web.clustered.session.notification.policy", IgnoreUndeployLegacyClusteredSessionNotificationPolicy.class.getName());
                }
            });
        }
        try {
            ClusteredSessionNotificationPolicy policy = DistributableSessionManager.loadClass(policyClass, ClusteredSessionNotificationPolicy.class).newInstance();
            policy.setClusteredSessionNotificationCapability(new ClusteredSessionNotificationCapability());
            return policy;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw WebMessages.MESSAGES.failToCreateSessionNotificationPolicy(ClusteredSessionNotificationPolicy.class.getName(), policyClass, e);
        }
    }

    private static <T> Class<? extends T> loadClass(String className, Class<T> targetClass) throws Exception {
        Exception lastException = new IllegalStateException();
        for (ClassLoader loader : Arrays.asList(Thread.currentThread().getContextClassLoader(), DistributableSessionManager.class.getClassLoader())) {
            if (loader == null) continue;
            try {
                return loader.loadClass(className).asSubclass(targetClass);
            }
            catch (ClassNotFoundException e) {
                lastException = e;
            }
        }
        throw lastException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() throws LifecycleException {
        this.log.debug((Object)"Stopping");
        if (!this.started) {
            return;
        }
        this.started = false;
        DistributableSessionManager distributableSessionManager = this;
        synchronized (distributableSessionManager) {
            this.log.trace((Object)"Waiting until backgroundProcess() short-circuits.");
        }
        Container container = this.getContainer();
        if (container instanceof Lifecycle) {
            ((Lifecycle)container).removeLifecycleListener((LifecycleListener)this);
        }
        if (this.semaphore.tryAcquire()) {
            try {
                this.log.debug((Object)"Closing off LockingValve");
                this.semaphore.acquire(0x7FFFFFFE);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                this.semaphore.release();
                throw new LifecycleException((Throwable)e);
            }
        }
        this.resetStats();
        this.lifecycle.fireLifecycleEvent("before_stop", (Object)this);
        this.clearSessions();
        this.distributedCacheManager.stop();
        this.snapshotManager.stop();
        this.snapshotManager = null;
        this.sessions.clear();
        this.unloadedSessions.clear();
        this.passivatedCount.set(0);
        this.lifecycle.fireLifecycleEvent("stop", (Object)this);
        this.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearSessions() {
        boolean passivation = this.isPassivationEnabled();
        boolean persistence = this.isPersistenceEnabled();
        for (Session session : this.sessions.values()) {
            ClusteredSession<O> ses = this.cast(session);
            this.log.tracef("clearSessions(): clear session by expiring or passivating: %s", ses);
            try {
                if (passivation && ses.isValid()) {
                    this.processSessionPassivation(ses.getRealId());
                    continue;
                }
                if (persistence) continue;
                boolean notify = true;
                boolean localCall = true;
                boolean localOnly = true;
                ses.expire(notify, localCall, localOnly, ClusteredSessionNotificationCause.UNDEPLOY);
            }
            catch (Throwable t) {
                this.log.warn((Object)WebMessages.MESSAGES.errorPassivatingSession(ses.getIdInternal()), t);
            }
            finally {
                ses.recycle();
            }
        }
        Set<Map.Entry<String, OwnedSessionUpdate>> unloaded = this.unloadedSessions.entrySet();
        Iterator<Map.Entry<String, OwnedSessionUpdate>> it = unloaded.iterator();
        while (it.hasNext()) {
            Map.Entry<String, OwnedSessionUpdate> entry = it.next();
            String realId = entry.getKey();
            try {
                if (passivation) {
                    OwnedSessionUpdate osu = entry.getValue();
                    if (!osu.isPassivated()) {
                        this.distributedCacheManager.evictSession(realId, osu.getOwner());
                    }
                } else {
                    this.distributedCacheManager.removeSessionLocal(realId);
                }
            }
            catch (Exception e) {
                this.log.debugf("Problem %s session %s -- %s", (Object)(passivation ? "evicting" : "removing"), (Object)realId, (Object)e);
            }
            it.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processSessionPassivation(String realId) {
        ClusteredSession<O> session = this.cast((Session)this.sessions.get(realId));
        if (session != null) {
            ClusteredSession<O> clusteredSession = session;
            synchronized (clusteredSession) {
                this.log.tracef("Passivating session with id: %s", (Object)realId);
                session.notifyWillPassivate(ClusteredSessionNotificationCause.PASSIVATION);
                this.distributedCacheManager.evictSession(realId);
                this.sessionPassivated();
                OwnedSessionUpdate obj = this.unloadedSessions.put(realId, new OwnedSessionUpdate(null, session.getLastAccessedTimeInternal(), session.getMaxInactiveInterval(), true));
                if (obj == null) {
                    this.log.tracef("New session %s added to unloaded session map", (Object)realId);
                } else {
                    this.log.tracef("Updated timestamp for unloaded session %s", (Object)realId);
                }
                this.sessions.remove(realId);
            }
        } else {
            this.log.tracef("processSessionPassivation():  could not find session %s", (Object)realId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session createSession(String sessionId, Random random) {
        ClusteredSession<O> session;
        block7: {
            session = null;
            try {
                boolean inLockingValve = SessionReplicationContext.isLocallyActive();
                if (inLockingValve || this.valveLock.tryLock(0L, TimeUnit.SECONDS)) {
                    try {
                        session = this.createSessionInternal(sessionId, random);
                        break block7;
                    }
                    finally {
                        if (!inLockingValve) {
                            this.valveLock.unlock();
                        }
                    }
                }
                this.log.trace((Object)"createEmptySession(): Manager is not handling requests; returning null");
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        return session;
    }

    private ClusteredSession<O> createSessionInternal(String sessionId, Random random) {
        ClusteredSession<O> session;
        if (this.maxActiveAllowed != -1 && this.calcActiveSessions() >= this.maxActiveAllowed) {
            this.log.tracef("createSession(): active sessions = %d and max allowed sessions = %d", (Object)this.calcActiveSessions(), (Object)this.maxActiveAllowed);
            this.processExpires();
            if (this.calcActiveSessions() >= this.maxActiveAllowed) {
                this.rejectedCounter.incrementAndGet();
                String msgEnd = sessionId == null ? "" : " id " + sessionId;
                throw WebMessages.MESSAGES.tooManyActiveSessions(this.maxActiveAllowed, msgEnd);
            }
        }
        if ((session = this.createEmptyClusteredSession()) != null) {
            session.setNew(true);
            session.setCreationTime(System.currentTimeMillis());
            session.setMaxInactiveInterval(this.maxInactiveInterval);
            session.setValid(true);
            String clearInvalidated = null;
            if (sessionId == null) {
                sessionId = this.generateSessionId(random);
            } else {
                clearInvalidated = sessionId;
            }
            session.setId(sessionId);
            this.getDistributedCacheManager().sessionCreated(session.getRealId());
            session.tellNew(ClusteredSessionNotificationCause.CREATE);
            this.log.tracef("Created a ClusteredSession with id: %s", (Object)sessionId);
            this.createdCounter.incrementAndGet();
            SessionReplicationContext.bindSession(session, this.snapshotManager);
            if (clearInvalidated != null) {
                SessionInvalidationTracker.clearInvalidatedSession(clearInvalidated, this);
            }
        }
        return session;
    }

    protected String generateSessionId(Random random) {
        return this.createSessionId(this.distributedCacheManager.createSessionId(), this.getJvmRoute());
    }

    protected boolean appendJVMRoute() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ClusteredSession<O> createEmptySession() {
        try {
            boolean inLockingValve = SessionReplicationContext.isLocallyActive();
            if (!inLockingValve && !this.valveLock.tryLock(0L, TimeUnit.SECONDS)) {
                this.log.trace((Object)"createEmptySession(): Manager is not handling requests; returning null");
                return null;
            }
            try {
                this.log.trace((Object)"Creating an empty ClusteredSession");
                ClusteredSession<O> clusteredSession = this.createEmptyClusteredSession();
                return clusteredSession;
            }
            finally {
                if (!inLockingValve) {
                    this.valveLock.unlock();
                }
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return null;
    }

    public ClusteredSession<O> findSession(String id) {
        String realId = this.parse(id).getKey();
        ClusteredSession<O> session = this.cast((Session)this.sessions.get(realId));
        if (session == null && !SessionInvalidationTracker.isSessionInvalidated(realId, this)) {
            this.log.tracef("Checking for session %s in the distributed cache", (Object)realId);
            session = this.loadSession(realId);
        } else if (session != null && this.outdatedSessionChecker.isSessionOutdated(session)) {
            this.log.tracef("Updating session %s from the distributed cache", (Object)realId);
            session = this.loadSession(realId);
            if (session == null) {
                this.sessions.remove(realId);
            }
        }
        if (session != null) {
            SessionReplicationContext.bindSession(session, this.snapshotManager);
            if (session.getNeedsPostReplicateActivation()) {
                session.notifyDidActivate(ClusteredSessionNotificationCause.REPLICATION);
            }
        }
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session[] findSessions() {
        block9: {
            boolean inLockingValve = SessionReplicationContext.isLocallyActive();
            if (!inLockingValve && !this.valveLock.tryLock(0L, TimeUnit.SECONDS)) break block9;
            try {
                if (this.unloadedSessions.size() > 0) {
                    HashSet<String> ids = new HashSet<String>(this.unloadedSessions.keySet());
                    this.log.tracef("findSessions: loading sessions from distributed cache: %s", ids);
                    for (String id : ids) {
                        this.loadSession(id);
                    }
                }
                Session[] sessionArray = this.sessions.values().toArray(new Session[0]);
                if (!inLockingValve) {
                    this.valveLock.unlock();
                }
                return sessionArray;
            }
            catch (Throwable throwable) {
                try {
                    if (!inLockingValve) {
                        this.valveLock.unlock();
                    }
                    throw throwable;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Session s) {
        ClusteredSession<O> session;
        ClusteredSession<O> clusteredSession = session = this.cast(s);
        synchronized (clusteredSession) {
            String realId = session.getRealId();
            if (realId == null) {
                return;
            }
            this.log.tracef("Removing session from store with id: %s", (Object)realId);
            try {
                session.removeMyself();
            }
            finally {
                SessionReplicationContext.sessionExpired(session, realId, this.snapshotManager);
                SessionInvalidationTracker.sessionInvalidated(realId, this);
                this.sessions.remove(realId);
                this.getReplicationStatistics().removeStats(realId);
                int timeAlive = (int)((System.currentTimeMillis() - session.getCreationTimeInternal()) / 1000L);
                this.sessionExpired(timeAlive);
            }
        }
    }

    public void lifecycleEvent(LifecycleEvent event) {
        this.handleForceSynchronousNotification(event.getType(), "before_stop", "after_stop");
    }

    private void handleForceSynchronousNotification(String type, String enableType, String disableType) {
        boolean enabled = type.equals(enableType);
        if ((enabled || type.equals(disableType)) && this.distributedCacheManager != null) {
            this.distributedCacheManager.setForceSynchronous(enabled);
        }
    }

    @Override
    public String locate(String sessionId) {
        return this.distributedCacheManager.locate(sessionId);
    }

    public String createSessionId() {
        return super.generateSessionId((Random)this.getEngine().getService().getRandom());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeLocal(Session s) {
        ClusteredSession<O> session;
        ClusteredSession<O> clusteredSession = session = this.cast(s);
        synchronized (clusteredSession) {
            String realId = session.getRealId();
            if (realId == null) {
                return;
            }
            this.log.tracef("Removing session from local store with id: %s", (Object)realId);
            try {
                session.removeMyselfLocal();
            }
            finally {
                SessionReplicationContext.sessionExpired(session, realId, this.snapshotManager);
                SessionInvalidationTracker.sessionInvalidated(realId, this);
                this.sessions.remove(realId);
                this.getReplicationStatistics().removeStats(realId);
                int timeAlive = (int)((System.currentTimeMillis() - session.getCreationTimeInternal()) / 1000L);
                this.sessionExpired(timeAlive);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean storeSession(Session s) {
        boolean stored = false;
        if (s != null) {
            ClusteredSession<O> session;
            ClusteredSession<O> clusteredSession = session = this.cast(s);
            synchronized (clusteredSession) {
                this.log.tracef("check to see if needs to store and replicate session with id %s ", (Object)session.getIdInternal());
                if (session.isValid() && (session.isSessionDirty() || session.getMustReplicateTimestamp())) {
                    String realId = session.getRealId();
                    long begin = System.currentTimeMillis();
                    session.notifyWillPassivate(ClusteredSessionNotificationCause.REPLICATION);
                    long elapsed = System.currentTimeMillis() - begin;
                    ReplicationStatistics stats = this.getReplicationStatistics();
                    stats.updatePassivationStats(realId, elapsed);
                    begin = System.currentTimeMillis();
                    this.processSessionRepl(session);
                    elapsed = System.currentTimeMillis() - begin;
                    stored = true;
                    stats.updateReplicationStats(realId, elapsed);
                } else {
                    this.log.tracef("Session %s did not require replication.", (Object)session.getIdInternal());
                }
            }
        }
        return stored;
    }

    public String getInfo() {
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Session session) {
        block8: {
            if (session == null) {
                return;
            }
            try {
                boolean inLockingValve = SessionReplicationContext.isLocallyActive();
                if (inLockingValve || this.valveLock.tryLock(0L, TimeUnit.SECONDS)) {
                    try {
                        this.add(this.cast(session), false);
                        break block8;
                    }
                    finally {
                        if (!inLockingValve) {
                            this.valveLock.unlock();
                        }
                    }
                }
                this.log.trace((Object)"add(): ignoring add -- Manager is not actively handling requests");
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private void add(ClusteredSession<O> session, boolean replicate) {
        if (!session.isValid()) {
            this.log.debugf("Cannot add session with id=%s because it is invalid", (Object)session.getIdInternal());
            return;
        }
        String realId = session.getRealId();
        ClusteredSession<O> existing = this.sessions.put(realId, session);
        this.unloadedSessions.remove(realId);
        if (!session.equals(existing)) {
            if (replicate) {
                this.storeSession(session);
            }
            this.calcActiveSessions();
            this.log.tracef("Session with id=%s added. Current active sessions %d", (Object)session.getIdInternal(), (Object)this.localActiveCounter.get());
        }
    }

    @Override
    public String getCacheConfigName() {
        return this.replicationConfig.getCacheName();
    }

    @Override
    public ReplicationGranularity getReplicationGranularity() {
        ReplicationGranularity granularity = this.replicationConfig.getReplicationGranularity();
        return granularity != null ? granularity : ReplicationGranularity.SESSION;
    }

    @Override
    public SnapshotMode getSnapshotMode() {
        SnapshotMode mode = this.replicationConfig.getSnapshotMode();
        return mode != null ? mode : SnapshotMode.INSTANT;
    }

    @Override
    public int getSnapshotInterval() {
        Integer interval = this.replicationConfig.getSnapshotInterval();
        return interval != null ? interval : -1;
    }

    @Override
    public void setMaxUnreplicatedInterval(int maxUnreplicatedInterval) {
        this.maxUnreplicatedInterval = maxUnreplicatedInterval;
    }

    @Override
    public String listLocalSessionIds() {
        ArrayList<String> ids = new ArrayList<String>(this.sessions.size());
        this.addLocal(ids, this.sessions.keySet());
        return this.reportSessionIds(ids);
    }

    private void addLocal(Collection<String> localIds, Collection<String> ids) {
        for (String id : ids) {
            if (!this.distributedCacheManager.isLocal(id)) continue;
            localIds.add(id);
        }
    }

    private String reportSessionIds(Collection<String> sessions) {
        StringBuilder builder = new StringBuilder();
        Iterator<String> ids = sessions.iterator();
        while (ids.hasNext()) {
            builder.append(ids.next());
            if (!ids.hasNext()) continue;
            builder.append(',');
        }
        return builder.toString();
    }

    @Override
    public long getPassivatedSessionCount() {
        return this.passivatedCount.get();
    }

    @Override
    public long getMaxPassivatedSessionCount() {
        return this.maxPassivatedCount.get();
    }

    @Override
    public long getPassivationMaxIdleTime() {
        return this.passivationMaxIdleTime;
    }

    @Override
    public long getPassivationMinIdleTime() {
        return this.passivationMinIdleTime;
    }

    @Override
    public int getMaxUnreplicatedInterval() {
        return this.maxUnreplicatedInterval;
    }

    @Override
    public ClusteredSessionNotificationPolicy getNotificationPolicy() {
        return this.notificationPolicy;
    }

    @Override
    public ReplicationTrigger getReplicationTrigger() {
        ReplicationTrigger trigger = this.replicationConfig.getReplicationTrigger();
        return trigger != null ? trigger : ReplicationTrigger.SET_AND_NON_PRIMITIVE_GET;
    }

    @Override
    public boolean getUseJK() {
        Boolean useJK = this.replicationConfig.getUseJK();
        return useJK != null ? useJK : true;
    }

    @Override
    public DistributedCacheManager<O> getDistributedCacheManager() {
        return this.distributedCacheManager;
    }

    @Override
    public boolean isPassivationEnabled() {
        return this.passivate;
    }

    public boolean isPersistenceEnabled() {
        return this.persistence;
    }

    public ClassResolver getApplicationClassResolver() {
        return this.resolver;
    }

    public ReplicationConfig getReplicationConfig() {
        return this.replicationConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyRemoteInvalidation(String realId) {
        ClusteredSession<O> session = this.cast((Session)this.sessions.remove(realId));
        if (session == null) {
            if (this.unloadedSessions.remove(realId) != null) {
                this.log.tracef("Removed entry for session %s from unloaded session map", (Object)realId);
            }
            this.getReplicationStatistics().removeStats(realId);
        } else {
            boolean notify = false;
            boolean localCall = false;
            boolean localOnly = true;
            try {
                SessionInvalidationTracker.suspend();
                session.expire(notify, localCall, localOnly, ClusteredSessionNotificationCause.INVALIDATE);
            }
            finally {
                SessionInvalidationTracker.resume();
                this.getReplicationStatistics().removeStats(realId);
            }
        }
    }

    public void notifyLocalAttributeModification(String realId) {
        ClusteredSession<O> session = this.cast((Session)this.sessions.get(realId));
        if (session != null) {
            session.sessionAttributesDirty();
        } else {
            this.log.warn((Object)WebMessages.MESSAGES.notificationForInactiveSession(realId));
        }
    }

    public void sessionActivated() {
        int pc = this.passivatedCount.decrementAndGet();
        if (pc < 0) {
            this.passivatedCount.incrementAndGet();
        }
    }

    public boolean sessionChangedInDistributedCache(String realId, String dataOwner, int distributedVersion, long timestamp, DistributableSessionMetadata metadata) {
        boolean updated = true;
        ClusteredSession<O> session = this.cast((Session)this.sessions.get(realId));
        if (session != null) {
            updated = session.setVersionFromDistributedCache(distributedVersion);
            if (updated) {
                this.log.tracef("session in-memory data is invalidated for id: %s new version: %d", (Object)realId, (Object)distributedVersion);
            }
        } else {
            int maxLife = metadata == null ? this.getMaxInactiveInterval() : metadata.getMaxInactiveInterval();
            OwnedSessionUpdate existing = this.unloadedSessions.put(realId, new OwnedSessionUpdate(dataOwner, timestamp, maxLife, false));
            if (existing == null) {
                this.calcActiveSessions();
                this.log.tracef("New session %s added to unloaded session map", (Object)realId);
            } else {
                this.log.tracef("Updated timestamp for unloaded session %s", (Object)realId);
            }
        }
        return updated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processExpirationPassivation() {
        boolean passivate;
        block30: {
            boolean expire = this.maxInactiveInterval >= 0;
            passivate = this.isPassivationEnabled();
            long passivationMax = this.passivationMaxIdleTime * 1000L;
            long passivationMin = this.passivationMinIdleTime * 1000L;
            this.log.trace((Object)"processExpirationPassivation(): Looking for sessions that have expired ...");
            this.log.tracef("processExpirationPassivation(): active sessions = %d", (Object)this.calcActiveSessions());
            this.log.tracef("processExpirationPassivation(): expired sessions = %d", (Object)this.expiredCounter.get());
            if (passivate) {
                this.log.tracef("processExpirationPassivation(): passivated count = %d", (Object)this.getPassivatedSessionCount());
            }
            TreeSet<PassivationCheck> passivationChecks = new TreeSet<PassivationCheck>();
            try {
                SessionInvalidationTracker.suspend();
                for (Session s : this.sessions.values()) {
                    if (!this.started) {
                        return;
                    }
                    boolean likelyExpired = false;
                    String realId = null;
                    try {
                        ClusteredSession<O> session = this.cast(s);
                        realId = session.getRealId();
                        likelyExpired = expire;
                        if (expire) {
                            boolean bl = likelyExpired = !session.isValid(false);
                            if (likelyExpired && this.outdatedSessionChecker.isSessionOutdated(session)) {
                                this.loadSession(session.getRealId());
                            }
                            if (!session.isValid()) continue;
                            likelyExpired = false;
                        }
                        if (!passivate) continue;
                        passivationChecks.add(new PassivationCheck(session));
                    }
                    catch (Exception e) {
                        if (likelyExpired) {
                            this.bruteForceCleanup(realId, e);
                            continue;
                        }
                        this.log.error((Object)WebMessages.MESSAGES.failToPassivateLoad(realId), (Throwable)e);
                    }
                }
                long maxUnrep = this.maxUnreplicatedInterval < 0 ? 60L : (long)this.maxUnreplicatedInterval;
                for (Map.Entry<String, OwnedSessionUpdate> entry : this.unloadedSessions.entrySet()) {
                    if (!this.started) {
                        return;
                    }
                    String realId = entry.getKey();
                    OwnedSessionUpdate osu = entry.getValue();
                    boolean likelyExpired = false;
                    long now = System.currentTimeMillis();
                    long elapsed = now - osu.getUpdateTime();
                    try {
                        boolean bl = likelyExpired = expire && osu.getMaxInactive() >= 1 && elapsed >= ((long)osu.getMaxInactive() + maxUnrep) * 1000L;
                        if (likelyExpired) {
                            Session session;
                            if (osu.isPassivated() && (session = this.findSession(realId)) != null) {
                                session.isValid();
                                continue;
                            }
                            this.distributedCacheManager.removeSessionLocal(realId, osu.getOwner());
                            this.unloadedSessions.remove(realId);
                            this.getReplicationStatistics().removeStats(realId);
                            continue;
                        }
                        if (!passivate || osu.isPassivated()) continue;
                        passivationChecks.add(new PassivationCheck(realId, osu));
                    }
                    catch (Exception e) {
                        if (likelyExpired) {
                            this.bruteForceCleanup(realId, e);
                            continue;
                        }
                        this.log.error((Object)WebMessages.MESSAGES.failToPassivateUnloaded(realId), (Throwable)e);
                    }
                }
                if (!this.started) {
                    return;
                }
                if (!passivate) break block30;
                for (PassivationCheck passivationCheck : passivationChecks) {
                    try {
                        long timeNow = System.currentTimeMillis();
                        long timeIdle = timeNow - passivationCheck.getLastUpdate();
                        if (passivationMax >= 0L && timeIdle > passivationMax) {
                            passivationCheck.passivate();
                            continue;
                        }
                        if (this.maxActiveAllowed > 0 && passivationMin > 0L && this.calcActiveSessions() >= this.maxActiveAllowed && timeIdle > passivationMin) {
                            passivationCheck.passivate();
                        }
                        break;
                    }
                    catch (Exception e) {
                        this.log.error((Object)WebMessages.MESSAGES.failToPassivate(passivationCheck.isUnloaded() ? "unloaded " : "", passivationCheck.getRealId()), (Throwable)e);
                    }
                }
            }
            catch (Exception ex) {
                this.log.error((Object)WebMessages.MESSAGES.processExpirationPassivationException(ex.getLocalizedMessage()), (Throwable)ex);
            }
            finally {
                SessionInvalidationTracker.resume();
            }
        }
        this.log.trace((Object)"processExpirationPassivation(): Completed ...");
        this.log.tracef("processExpirationPassivation(): active sessions = %d", (Object)this.calcActiveSessions());
        this.log.tracef("processExpirationPassivation(): expired sessions = %d", (Object)this.expiredCounter.get());
        if (passivate) {
            this.log.tracef("processExpirationPassivation(): passivated count = %d", (Object)this.getPassivatedSessionCount());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ClusteredSession<O> loadSession(String realId) {
        if (realId == null) {
            return null;
        }
        try {
            boolean inLockingValve = SessionReplicationContext.isLocallyActive();
            if (!inLockingValve) {
                if (!this.valveLock.tryLock(0L, TimeUnit.SECONDS)) return null;
            }
            try {
                Object osu;
                long begin = System.currentTimeMillis();
                boolean mustAdd = false;
                boolean passivated = false;
                ClusteredSession<O> session = this.cast((Session)this.sessions.get(realId));
                boolean initialLoad = false;
                if (session == null) {
                    initialLoad = true;
                    mustAdd = true;
                    session = this.createEmptyClusteredSession();
                    ClusteredSession<O> embryo = this.embryonicSessions.putIfAbsent(realId, session);
                    if (embryo != null) {
                        session = embryo;
                    }
                    passivated = (osu = this.unloadedSessions.get(realId)) != null && ((OwnedSessionUpdate)osu).isPassivated();
                }
                ClusteredSession<O> clusteredSession = session;
                synchronized (clusteredSession) {
                    if (initialLoad && !session.isOutdated()) {
                        osu = session;
                        return osu;
                    }
                    IncomingDistributableSessionData data = this.distributedCacheManager.getSessionData(realId, initialLoad);
                    if (data != null) {
                        session.update(data);
                    } else {
                        session = null;
                    }
                    if (session != null) {
                        ClusteredSessionNotificationCause cause = passivated ? ClusteredSessionNotificationCause.ACTIVATION : ClusteredSessionNotificationCause.FAILOVER;
                        session.notifyDidActivate(cause);
                    }
                    if (session != null) {
                        if (mustAdd) {
                            this.add(session, false);
                            if (!passivated) {
                                session.tellNew(ClusteredSessionNotificationCause.FAILOVER);
                            }
                        }
                        long elapsed = System.currentTimeMillis() - begin;
                        this.getReplicationStatistics().updateLoadStats(realId, elapsed);
                        this.log.tracef("loadSession(): id=%s, session=%s", (Object)realId, session);
                    } else {
                        this.log.tracef("loadSession(): session %s not found in distributed cache", (Object)realId);
                    }
                    if (initialLoad) {
                        this.embryonicSessions.remove(realId);
                    }
                }
                clusteredSession = session;
                return clusteredSession;
            }
            finally {
                if (!inLockingValve) {
                    this.valveLock.unlock();
                }
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ClusteredSession<O> createEmptyClusteredSession() {
        try {
            boolean inLockingValve = SessionReplicationContext.isLocallyActive();
            if (!inLockingValve) {
                if (!this.valveLock.tryLock(0L, TimeUnit.SECONDS)) return null;
            }
            try {
                switch (this.getReplicationGranularity()) {
                    case ATTRIBUTE: {
                        AttributeBasedClusteredSession attributeBasedClusteredSession = new AttributeBasedClusteredSession(this);
                        return attributeBasedClusteredSession;
                    }
                }
                SessionBasedClusteredSession sessionBasedClusteredSession = new SessionBasedClusteredSession(this);
                return sessionBasedClusteredSession;
            }
            finally {
                if (!inLockingValve) {
                    this.valveLock.unlock();
                }
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bruteForceCleanup(String realId, Exception ex) {
        this.log.warn((Object)WebMessages.MESSAGES.bruteForceCleanup(realId, ex.getLocalizedMessage()));
        try {
            this.distributedCacheManager.removeSessionLocal(realId, null);
        }
        catch (Exception e) {
            this.log.error((Object)WebMessages.MESSAGES.failToBruteForceCleanup(realId), (Throwable)e);
        }
        finally {
            this.unloadedSessions.remove(realId);
            this.getReplicationStatistics().removeStats(realId);
        }
    }

    @Override
    public Map.Entry<String, String> parse(String sessionId) {
        return this.getUseJK() ? super.parse(sessionId) : new AbstractMap.SimpleImmutableEntry<String, Object>(sessionId, null);
    }

    @Override
    public String createSessionId(String realId, String jvmRoute) {
        return this.getUseJK() ? super.createSessionId(realId, jvmRoute) : realId;
    }

    @Override
    protected int getTotalActiveSessions() {
        return this.localActiveCounter.get() + this.unloadedSessions.size() - this.passivatedCount.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processSessionRepl(ClusteredSession<O> session) {
        boolean endBatch = false;
        BatchingManager batchingManager = this.distributedCacheManager.getBatchingManager();
        try {
            if (!batchingManager.isBatchInProgress()) {
                batchingManager.startBatch();
                endBatch = true;
            }
            session.processSessionReplication();
        }
        catch (Exception ex) {
            this.log.debug((Object)"processSessionRepl(): failed with exception", (Throwable)ex);
            RuntimeException exception = null;
            try {
                batchingManager.setBatchRollbackOnly();
            }
            catch (RuntimeException e) {
                exception = e;
            }
            catch (Exception e) {
                exception = WebMessages.MESSAGES.failedSessionReplication(e);
            }
            if (exception != null) {
                this.log.error((Object)WebMessages.MESSAGES.exceptionRollingBackTransaction(), (Throwable)exception);
                throw exception;
            }
        }
        finally {
            if (endBatch) {
                batchingManager.endBatch();
            }
        }
    }

    private ClusteredSession<O> cast(Session session) {
        if (session == null) {
            return null;
        }
        if (!(session instanceof ClusteredSession)) {
            throw WebMessages.MESSAGES.invalidSession(this.getClass().getName());
        }
        return (ClusteredSession)session;
    }

    private static class SemaphoreLock
    implements Lock {
        private final Semaphore semaphore;

        SemaphoreLock(Semaphore semaphore) {
            this.semaphore = semaphore;
        }

        @Override
        public void lock() {
            this.semaphore.acquireUninterruptibly();
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
            this.semaphore.acquire();
        }

        @Override
        public Condition newCondition() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean tryLock() {
            return this.semaphore.tryAcquire();
        }

        @Override
        public boolean tryLock(long timeout, TimeUnit unit) throws InterruptedException {
            return this.semaphore.tryAcquire(timeout, unit);
        }

        @Override
        public void unlock() {
            this.semaphore.release();
        }
    }

    private class PassivationCheck
    implements Comparable<PassivationCheck> {
        private final String realId;
        private final OwnedSessionUpdate osu;
        private final ClusteredSession<O> session;

        private PassivationCheck(String realId, OwnedSessionUpdate osu) {
            assert (osu != null) : WebMessages.MESSAGES.nullOsu();
            assert (realId != null) : WebMessages.MESSAGES.nullSessionId();
            this.realId = realId;
            this.osu = osu;
            this.session = null;
        }

        private PassivationCheck(ClusteredSession<O> session) {
            assert (session != null) : WebMessages.MESSAGES.nullSession();
            this.realId = session.getRealId();
            this.session = session;
            this.osu = null;
        }

        private long getLastUpdate() {
            return this.osu == null ? this.session.getLastAccessedTimeInternal() : this.osu.getUpdateTime();
        }

        private void passivate() {
            if (this.osu == null) {
                DistributableSessionManager.this.processSessionPassivation(this.realId);
            } else {
                DistributableSessionManager.this.processUnloadedSessionPassivation(this.realId, this.osu);
            }
        }

        private String getRealId() {
            return this.realId;
        }

        private boolean isUnloaded() {
            return this.osu != null;
        }

        @Override
        public int compareTo(PassivationCheck o) {
            long anotherVal;
            long thisVal = this.getLastUpdate();
            return thisVal < (anotherVal = o.getLastUpdate()) ? -1 : (thisVal == anotherVal ? 0 : 1);
        }
    }
}

