/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.web.security.jaspi.modules;

import java.security.Principal;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.message.AuthException;
import javax.security.auth.message.AuthStatus;
import javax.security.auth.message.MessageInfo;
import javax.security.auth.message.MessagePolicy;
import javax.security.auth.message.callback.CallerPrincipalCallback;
import javax.security.auth.message.callback.PasswordValidationCallback;
import javax.security.auth.message.module.ServerAuthModule;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.jboss.as.web.security.jaspi.WebJASPICallbackHandler;

public abstract class WebServerAuthModule
implements ServerAuthModule {
    protected CallbackHandler callbackHandler;
    protected Map options;

    public Class[] getSupportedMessageTypes() {
        return new Class[]{Request.class, Response.class, HttpServletRequest.class, HttpServletResponse.class};
    }

    public void initialize(MessagePolicy requestPolicy, MessagePolicy responsePolicy, CallbackHandler handler, Map options) throws AuthException {
        this.callbackHandler = handler;
        this.options = options;
    }

    public void cleanSubject(MessageInfo messageInfo, Subject subject) throws AuthException {
        Request request = (Request)messageInfo.getRequestMessage();
        Principal principal = request.getUserPrincipal();
        if (subject != null) {
            subject.getPrincipals().remove(principal);
        }
    }

    public abstract AuthStatus secureResponse(MessageInfo var1, Subject var2) throws AuthException;

    public abstract AuthStatus validateRequest(MessageInfo var1, Subject var2, Subject var3) throws AuthException;

    protected void registerWithCallbackHandler(Principal userPrincipal, String username, String password) {
        if (this.callbackHandler instanceof WebJASPICallbackHandler) {
            WebJASPICallbackHandler cbh = (WebJASPICallbackHandler)this.callbackHandler;
            PasswordValidationCallback passwordValidationCallback = new PasswordValidationCallback(null, username, password.toCharArray());
            CallerPrincipalCallback callerCallback = new CallerPrincipalCallback(null, userPrincipal);
            try {
                cbh.handle(new Callback[]{passwordValidationCallback, callerCallback});
            }
            catch (Exception e) {
                throw new RuntimeException("Error handling callbacks: " + e.getLocalizedMessage(), e);
            }
        } else {
            throw new RuntimeException(" Unsupported Callback handler " + this.callbackHandler.getClass().getCanonicalName());
        }
    }
}

