/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.web;

import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.web.WebMessages;
import org.jboss.dmr.ModelNode;

public class WebValveParamRemove
extends AbstractRemoveStepHandler {
    static final WebValveParamRemove INSTANCE = new WebValveParamRemove();

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        ModelNode mimetypes = context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS).getModel().get("param");
        if (!operation.hasDefined("param-name")) {
            throw new OperationFailedException(new ModelNode().set(WebMessages.MESSAGES.paramNameRequiredForRemoveParam()));
        }
        mimetypes.remove(operation.get("param-name").asString());
        if (!context.isBooting() && context.isNormalServer()) {
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    context.reloadRequired();
                    context.completeStep(new OperationContext.RollbackHandler(){

                        public void handleRollback(OperationContext context, ModelNode operation) {
                            context.revertReloadRequired();
                        }
                    });
                }
            }, OperationContext.Stage.RUNTIME);
        }
        context.stepCompleted();
    }
}

