/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.adapters.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Calendar;
import org.jboss.jca.adapters.jdbc.CachedPreparedStatement;
import org.jboss.jca.adapters.jdbc.WrappedConnection;
import org.jboss.jca.adapters.jdbc.WrappedStatement;

public abstract class WrappedPreparedStatement
extends WrappedStatement
implements PreparedStatement {
    private final PreparedStatement ps;

    public WrappedPreparedStatement(WrappedConnection lc, PreparedStatement ps, boolean spy, String jndiName) {
        super(lc, ps, spy, jndiName);
        this.ps = ps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PreparedStatement getUnderlyingStatement() throws SQLException {
        this.lock();
        try {
            this.checkState();
            if (this.ps instanceof CachedPreparedStatement) {
                PreparedStatement preparedStatement = ((CachedPreparedStatement)this.ps).getUnderlyingPreparedStatement();
                return preparedStatement;
            }
            PreparedStatement preparedStatement = this.ps;
            return preparedStatement;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBoolean(int parameterIndex, boolean value) throws SQLException {
        this.lock();
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] setBoolean(%s, %s)", new Object[]{this.jndiName, "PreparedStatement", parameterIndex, value});
                }
                this.ps.setBoolean(parameterIndex, value);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setByte(int parameterIndex, byte value) throws SQLException {
        this.lock();
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] setByte(%s, %s)", new Object[]{this.jndiName, "PreparedStatement", parameterIndex, value});
                }
                this.ps.setByte(parameterIndex, value);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setShort(int parameterIndex, short value) throws SQLException {
        this.lock();
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] setShort(%s, %s)", new Object[]{this.jndiName, "PreparedStatement", parameterIndex, value});
                }
                this.ps.setShort(parameterIndex, value);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setInt(int parameterIndex, int value) throws SQLException {
        this.lock();
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] setInt(%s, %s)", new Object[]{this.jndiName, "PreparedStatement", parameterIndex, value});
                }
                this.ps.setInt(parameterIndex, value);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLong(int parameterIndex, long value) throws SQLException {
        this.lock();
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] setLong(%s, %s)", new Object[]{this.jndiName, "PreparedStatement", parameterIndex, value});
                }
                this.ps.setLong(parameterIndex, value);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFloat(int parameterIndex, float value) throws SQLException {
        this.lock();
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] setFloat(%s, %s)", new Object[]{this.jndiName, "PreparedStatement", parameterIndex, Float.valueOf(value)});
                }
                this.ps.setFloat(parameterIndex, value);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDouble(int parameterIndex, double value) throws SQLException {
        this.lock();
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] setDouble(%s, %s)", new Object[]{this.jndiName, "PreparedStatement", parameterIndex, value});
                }
                this.ps.setDouble(parameterIndex, value);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setURL(int parameterIndex, URL value) throws SQLException {
        this.lock();
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] setURL(%s, %s)", new Object[]{this.jndiName, "PreparedStatement", parameterIndex, value});
                }
                this.ps.setURL(parameterIndex, value);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTime(int parameterIndex, Time value) throws SQLException {
        this.lock();
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] setTime(%s, %s)", new Object[]{this.jndiName, "PreparedStatement", parameterIndex, value});
                }
                this.ps.setTime(parameterIndex, value);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTime(int parameterIndex, Time value, Calendar calendar) throws SQLException {
        this.lock();
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] setTime(%s, %s, %s)", new Object[]{this.jndiName, "PreparedStatement", parameterIndex, value, calendar});
                }
                this.ps.setTime(parameterIndex, value, calendar);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public boolean execute() throws SQLException {
        this.lock();
        try {
            this.checkTransaction();
            try {
                this.checkConfiguredQueryTimeout();
                if (this.spy) {
                    spyLogger.debugf("%s [%s] execute()", (Object)this.jndiName, (Object)"PreparedStatement");
                }
                boolean bl = this.ps.execute();
                return bl;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.lock();
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getMetaData()", (Object)this.jndiName, (Object)"PreparedStatement");
                }
                ResultSetMetaData resultSetMetaData = this.ps.getMetaData();
                return resultSetMetaData;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        this.lock();
        try {
            this.checkTransaction();
            try {
                this.checkConfiguredQueryTimeout();
                if (this.spy) {
                    spyLogger.debugf("%s [%s] executeQuery()", (Object)this.jndiName, (Object)"PreparedStatement");
                }
                ResultSet resultSet = this.ps.executeQuery();
                ResultSet resultSet2 = this.registerResultSet(resultSet);
                return resultSet2;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public int executeUpdate() throws SQLException {
        this.lock();
        try {
            this.checkTransaction();
            try {
                this.checkConfiguredQueryTimeout();
                if (this.spy) {
                    spyLogger.debugf("%s [%s] executeUpdate()", (Object)this.jndiName, (Object)"PreparedStatement");
                }
                int n = this.ps.executeUpdate();
                return n;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addBatch() throws SQLException {
        this.lock();
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] addBatch()", (Object)this.jndiName, (Object)"PreparedStatement");
                }
                this.ps.addBatch();
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.lock();
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] setNull(%s, %s)", new Object[]{this.jndiName, "PreparedStatement", parameterIndex, sqlType});
                }
                this.ps.setNull(parameterIndex, sqlType);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.lock();
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] setNull(%s, %s, %s)", new Object[]{this.jndiName, "PreparedStatement", parameterIndex, sqlType, typeName});
                }
                this.ps.setNull(parameterIndex, sqlType, typeName);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal value) throws SQLException {
        this.lock();
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] setBigDecimal(%s, %s)", new Object[]{this.jndiName, "PreparedStatement", parameterIndex, value});
                }
                this.ps.setBigDecimal(parameterIndex, value);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setString(int parameterIndex, String value) throws SQLException {
        this.lock();
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] setString(%s, %s)", new Object[]{this.jndiName, "PreparedStatement", parameterIndex, value});
                }
                this.ps.setString(parameterIndex, value);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBytes(int parameterIndex, byte[] value) throws SQLException {
        this.lock();
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] setBytes(%s, %s)", new Object[]{this.jndiName, "PreparedStatement", parameterIndex, Arrays.toString(value)});
                }
                this.ps.setBytes(parameterIndex, value);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDate(int parameterIndex, Date value) throws SQLException {
        this.lock();
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] setDate(%s, %s)", new Object[]{this.jndiName, "PreparedStatement", parameterIndex, value});
                }
                this.ps.setDate(parameterIndex, value);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDate(int parameterIndex, Date value, Calendar calendar) throws SQLException {
        this.lock();
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] setDate(%s, %s, %s)", new Object[]{this.jndiName, "PreparedStatement", parameterIndex, value, calendar});
                }
                this.ps.setDate(parameterIndex, value, calendar);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTimestamp(int parameterIndex, Timestamp value) throws SQLException {
        this.lock();
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] setTimestamp(%s, %s)", new Object[]{this.jndiName, "PreparedStatement", parameterIndex, value});
                }
                this.ps.setTimestamp(parameterIndex, value);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTimestamp(int parameterIndex, Timestamp value, Calendar calendar) throws SQLException {
        this.lock();
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] setTimestamp(%s, %s, %s)", new Object[]{this.jndiName, "PreparedStatement", parameterIndex, value, calendar});
                }
                this.ps.setTimestamp(parameterIndex, value, calendar);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void setAsciiStream(int parameterIndex, InputStream stream, int length) throws SQLException {
        this.lock();
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] setAsciiStream(%s, %s, %s)", new Object[]{this.jndiName, "PreparedStatement", parameterIndex, stream, length});
                }
                this.ps.setAsciiStream(parameterIndex, stream, length);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void setUnicodeStream(int parameterIndex, InputStream stream, int length) throws SQLException {
        this.lock();
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] setUnicodeStream(%s, %s, %s)", new Object[]{this.jndiName, "PreparedStatement", parameterIndex, stream, length});
                }
                this.ps.setUnicodeStream(parameterIndex, stream, length);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBinaryStream(int parameterIndex, InputStream stream, int length) throws SQLException {
        this.lock();
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] setBinaryStream(%s, %s, %s)", new Object[]{this.jndiName, "PreparedStatement", parameterIndex, stream, length});
                }
                this.ps.setBinaryStream(parameterIndex, stream, length);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearParameters() throws SQLException {
        this.lock();
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] clearParameters()", (Object)this.jndiName, (Object)"PreparedStatement");
                }
                this.ps.clearParameters();
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setObject(int parameterIndex, Object value, int sqlType, int scale) throws SQLException {
        this.lock();
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] setObject(%s, %s, %s, %s)", new Object[]{this.jndiName, "PreparedStatement", parameterIndex, value, sqlType, scale});
                }
                this.ps.setObject(parameterIndex, value, sqlType, scale);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setObject(int parameterIndex, Object value, int sqlType) throws SQLException {
        this.lock();
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] setObject(%s, %s, %s)", new Object[]{this.jndiName, "PreparedStatement", parameterIndex, value, sqlType});
                }
                this.ps.setObject(parameterIndex, value, sqlType);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setObject(int parameterIndex, Object value) throws SQLException {
        this.lock();
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] setObject(%s, %s)", new Object[]{this.jndiName, "PreparedStatement", parameterIndex, value});
                }
                this.ps.setObject(parameterIndex, value);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        this.lock();
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] setCharacterStream(%s, %s, %s)", new Object[]{this.jndiName, "PreparedStatement", parameterIndex, reader, length});
                }
                this.ps.setCharacterStream(parameterIndex, reader, length);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRef(int parameterIndex, Ref value) throws SQLException {
        this.lock();
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] setRef(%s, %s)", new Object[]{this.jndiName, "PreparedStatement", parameterIndex, value});
                }
                this.ps.setRef(parameterIndex, value);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBlob(int parameterIndex, Blob value) throws SQLException {
        this.lock();
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] setBlob(%s, %s)", new Object[]{this.jndiName, "PreparedStatement", parameterIndex, value});
                }
                this.ps.setBlob(parameterIndex, value);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setClob(int parameterIndex, Clob value) throws SQLException {
        this.lock();
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] setClob(%s, %s)", new Object[]{this.jndiName, "PreparedStatement", parameterIndex, value});
                }
                this.ps.setClob(parameterIndex, value);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setArray(int parameterIndex, Array value) throws SQLException {
        this.lock();
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] setArray(%s, %s)", new Object[]{this.jndiName, "PreparedStatement", parameterIndex, value});
                }
                this.ps.setArray(parameterIndex, value);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        this.lock();
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getParameterMetaData()", (Object)this.jndiName, (Object)"PreparedStatement");
                }
                ParameterMetaData parameterMetaData = this.ps.getParameterMetaData();
                return parameterMetaData;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        this.lock();
        try {
            PreparedStatement wrapped;
            if (this.spy) {
                spyLogger.debugf("%s [%s] isClosed()", (Object)this.jndiName, (Object)"PreparedStatement");
            }
            if ((wrapped = this.getWrappedObject()) == null) {
                boolean bl = true;
                return bl;
            }
            boolean bl = wrapped.isClosed();
            return bl;
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public boolean isPoolable() throws SQLException {
        this.lock();
        try {
            PreparedStatement statement = this.getUnderlyingStatement();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] isPoolable()", (Object)this.jndiName, (Object)"PreparedStatement");
                }
                boolean bl = statement.isPoolable();
                return bl;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        this.lock();
        try {
            PreparedStatement statement = this.getUnderlyingStatement();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] setPoolable(%s)", (Object)this.jndiName, (Object)"PreparedStatement", (Object)poolable);
                }
                statement.setPoolable(poolable);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this.lock();
        try {
            PreparedStatement statement = this.getUnderlyingStatement();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] setAsciiStream(%s, %s, %s)", new Object[]{this.jndiName, "PreparedStatement", parameterIndex, x, length});
                }
                statement.setAsciiStream(parameterIndex, x, length);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        this.lock();
        try {
            PreparedStatement statement = this.getUnderlyingStatement();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] setAsciiStream(%s, %s)", new Object[]{this.jndiName, "PreparedStatement", parameterIndex, x});
                }
                statement.setAsciiStream(parameterIndex, x);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this.lock();
        try {
            PreparedStatement statement = this.getUnderlyingStatement();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] setBinaryStream(%s, %s, %s)", new Object[]{this.jndiName, "PreparedStatement", parameterIndex, x, length});
                }
                statement.setBinaryStream(parameterIndex, x, length);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        this.lock();
        try {
            PreparedStatement statement = this.getUnderlyingStatement();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] setBinaryStream(%s, %s)", new Object[]{this.jndiName, "PreparedStatement", parameterIndex, x});
                }
                statement.setBinaryStream(parameterIndex, x);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        this.lock();
        try {
            PreparedStatement statement = this.getUnderlyingStatement();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] setBlob(%s, %s, %s)", new Object[]{this.jndiName, "PreparedStatement", parameterIndex, inputStream, length});
                }
                statement.setBlob(parameterIndex, inputStream, length);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        this.lock();
        try {
            PreparedStatement statement = this.getUnderlyingStatement();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] setBlob(%s, %s)", new Object[]{this.jndiName, "PreparedStatement", parameterIndex, inputStream});
                }
                statement.setBlob(parameterIndex, inputStream);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        this.lock();
        try {
            PreparedStatement statement = this.getUnderlyingStatement();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] setCharacterStream(%s, %s, %s)", new Object[]{this.jndiName, "PreparedStatement", parameterIndex, reader, length});
                }
                statement.setCharacterStream(parameterIndex, reader, length);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        this.lock();
        try {
            PreparedStatement statement = this.getUnderlyingStatement();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] setCharacterStream(%s, %s)", new Object[]{this.jndiName, "PreparedStatement", parameterIndex, reader});
                }
                statement.setCharacterStream(parameterIndex, reader);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.lock();
        try {
            PreparedStatement statement = this.getUnderlyingStatement();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] setClob(%s, %s, %s)", new Object[]{this.jndiName, "PreparedStatement", parameterIndex, reader, length});
                }
                statement.setClob(parameterIndex, reader, length);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        this.lock();
        try {
            PreparedStatement statement = this.getUnderlyingStatement();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] setClob(%s, %s)", new Object[]{this.jndiName, "PreparedStatement", parameterIndex, reader});
                }
                statement.setClob(parameterIndex, reader);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        this.lock();
        try {
            PreparedStatement statement = this.getUnderlyingStatement();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] setNCharacterStream(%s, %s, %s)", new Object[]{this.jndiName, "PreparedStatement", parameterIndex, value, length});
                }
                statement.setNCharacterStream(parameterIndex, value, length);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        this.lock();
        try {
            PreparedStatement statement = this.getUnderlyingStatement();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] setNCharacterStream(%s, %s)", new Object[]{this.jndiName, "PreparedStatement", parameterIndex, value});
                }
                statement.setNCharacterStream(parameterIndex, value);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        this.lock();
        try {
            PreparedStatement statement = this.getUnderlyingStatement();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] setNClob(%s, %s)", new Object[]{this.jndiName, "PreparedStatement", parameterIndex, value});
                }
                statement.setNClob(parameterIndex, value);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.lock();
        try {
            PreparedStatement statement = this.getUnderlyingStatement();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] setNClob(%s, %s, %s)", new Object[]{this.jndiName, "PreparedStatement", parameterIndex, reader, length});
                }
                statement.setNClob(parameterIndex, reader, length);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        this.lock();
        try {
            PreparedStatement statement = this.getUnderlyingStatement();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] setNClob(%s, %s)", new Object[]{this.jndiName, "PreparedStatement", parameterIndex, reader});
                }
                statement.setNClob(parameterIndex, reader);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        this.lock();
        try {
            PreparedStatement statement = this.getUnderlyingStatement();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] setNString(%s, %s)", new Object[]{this.jndiName, "PreparedStatement", parameterIndex, value});
                }
                statement.setNString(parameterIndex, value);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        this.lock();
        try {
            PreparedStatement statement = this.getUnderlyingStatement();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] setRowId(%s, %s)", new Object[]{this.jndiName, "PreparedStatement", parameterIndex, x});
                }
                statement.setRowId(parameterIndex, x);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        this.lock();
        try {
            PreparedStatement statement = this.getUnderlyingStatement();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] setSQLXML(%s, %s)", new Object[]{this.jndiName, "PreparedStatement", parameterIndex, xmlObject});
                }
                statement.setSQLXML(parameterIndex, xmlObject);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    @Override
    protected PreparedStatement getWrappedObject() throws SQLException {
        return (PreparedStatement)super.getWrappedObject();
    }
}

