/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.deployment;

import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.osgi.OSGiConstants;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.osgi.metadata.OSGiMetaData;
import org.osgi.framework.BundleActivator;

public class OSGiComponentParseProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit depUnit = phaseContext.getDeploymentUnit();
        OSGiMetaData metadata = (OSGiMetaData)depUnit.getAttachment(OSGiConstants.OSGI_METADATA_KEY);
        if (metadata == null || metadata.getBundleActivator() == null) {
            return;
        }
        String componentClass = metadata.getBundleActivator();
        String componentName = BundleActivator.class.getSimpleName();
        EEModuleDescription moduleDescription = (EEModuleDescription)depUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
        if (moduleDescription != null) {
            ComponentDescription componentDescription = new ComponentDescription(componentName, componentClass, moduleDescription, depUnit.getServiceName());
            moduleDescription.addComponent(componentDescription);
        }
    }

    public void undeploy(DeploymentUnit context) {
    }
}

