/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.iis.util;

import java.util.HashMap;
import java.util.Map;
import org.hyperic.sigar.win32.MetaBase;
import org.hyperic.sigar.win32.Win32Exception;

public class IISMetaBase {
    private static final String IIS_MKEY = "/LM/W3SVC";
    private static final int MD_SSL_ACCESS_PERM = 6030;
    private static final int MD_ACCESS_SSL = 8;
    String id;
    String ip;
    String hostname;
    String port;
    String path;
    boolean requireSSL = false;

    public String getId() {
        return this.id;
    }

    public String getIp() {
        return this.ip;
    }

    public String getHostname() {
        return this.hostname;
    }

    public String getPort() {
        return this.port;
    }

    public String getPath() {
        return this.path;
    }

    public boolean isRequireSSL() {
        return this.requireSSL;
    }

    public String toString() {
        String s = "id: " + this.id + " " + this.ip + ":" + this.port;
        if (this.hostname != null) {
            s = s + ", Host: " + this.hostname;
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, IISMetaBase> getWebSites() throws Win32Exception {
        String[] keys;
        HashMap<String, IISMetaBase> websites = new HashMap<String, IISMetaBase>();
        MetaBase mb = new MetaBase();
        try {
            mb.OpenSubKey(IIS_MKEY);
            keys = mb.getSubKeyNames();
        }
        finally {
            mb.close();
        }
        for (String key : keys) {
            int id;
            if (!Character.isDigit(key.charAt(0))) continue;
            try {
                id = Integer.parseInt(key);
            }
            catch (NumberFormatException e) {
                continue;
            }
            String subkey = "/LM/W3SVC/" + id;
            MetaBase srv = null;
            try {
                String docroot;
                String entry;
                int ix;
                srv = new MetaBase();
                srv.OpenSubKey(subkey);
                String[] bindings = null;
                IISMetaBase info = new IISMetaBase();
                try {
                    int flags = srv.getIntValue(6030);
                    boolean bl = info.requireSSL = (flags & 8) != 0;
                    if (info.requireSSL) {
                        bindings = srv.getMultiStringValue(MetaBase.MD_SECURE_BINDINGS);
                    }
                }
                catch (Win32Exception e) {
                    // empty catch block
                }
                if (bindings == null) {
                    bindings = srv.getMultiStringValue(MetaBase.MD_SERVER_BINDINGS);
                }
                if (bindings.length == 0 || (ix = (entry = bindings[0]).indexOf(":")) == -1) continue;
                info.id = key;
                info.ip = entry.substring(0, ix);
                entry = entry.substring(ix + 1);
                ix = entry.indexOf(":");
                info.port = entry.substring(0, ix);
                info.hostname = entry.substring(ix + 1);
                if (info.hostname != null && info.hostname.length() == 0) {
                    info.hostname = null;
                }
                if (info.ip == null || info.ip.length() == 0) {
                    info.ip = "localhost";
                }
                String name = srv.getStringValue(MetaBase.MD_SERVER_COMMENT);
                websites.put(name, info);
                srv.close();
                srv = null;
                srv = new MetaBase();
                srv.OpenSubKey(subkey + "/ROOT");
                info.path = docroot = srv.getStringValue(3001);
            }
            catch (Win32Exception e) {
            }
            finally {
                if (srv != null) {
                    srv.close();
                }
            }
        }
        return websites;
    }

    public static void main(String[] args) throws Exception {
        Map<String, IISMetaBase> websites = IISMetaBase.getWebSites();
        System.out.println(websites);
    }
}

