/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.bindings.script;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.nio.charset.Charset;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.bindings.StandardBindings;
import org.rhq.bindings.client.RhqFacade;
import org.rhq.bindings.script.BaseRhqSchemeScriptSourceProvider;
import org.rhq.core.domain.content.Repo;
import org.rhq.core.domain.content.composite.PackageAndLatestVersionComposite;
import org.rhq.core.domain.criteria.BaseCriteria;
import org.rhq.core.domain.criteria.PackageCriteria;
import org.rhq.core.domain.criteria.RepoCriteria;
import org.rhq.core.domain.util.PageList;
import org.rhq.enterprise.server.content.ContentManagerRemote;
import org.rhq.enterprise.server.content.RepoManagerRemote;
import org.rhq.enterprise.server.util.CriteriaQuery;
import org.rhq.enterprise.server.util.CriteriaQueryExecutor;

public class RepoScriptSourceProvider
extends BaseRhqSchemeScriptSourceProvider
implements StandardBindings.RhqFacadeChangeListener {
    private static final Log LOG = LogFactory.getLog(RepoScriptSourceProvider.class);
    private static final String AUTHORITY = "repositories";
    private RhqFacade rhqFacade;

    public RepoScriptSourceProvider() {
        super(AUTHORITY);
    }

    @Override
    public void rhqFacadeChanged(StandardBindings bindings) {
        this.rhqFacade = bindings.getAssociatedRhqFacade();
    }

    @Override
    protected Reader doGetScriptSource(URI scriptUri) {
        if (this.rhqFacade == null) {
            return null;
        }
        String path = scriptUri.getPath().substring(1);
        int slashIdx = path.indexOf(47);
        if (slashIdx == -1) {
            return null;
        }
        String repoName = path.substring(0, slashIdx);
        String scriptName = path.substring(slashIdx + 1);
        try {
            final RepoManagerRemote repoManager = this.rhqFacade.getProxy(RepoManagerRemote.class);
            final RepoCriteria repoCrit = new RepoCriteria();
            repoCrit.addFilterName(repoName);
            CriteriaQueryExecutor<Repo, RepoCriteria> queryExecutor = new CriteriaQueryExecutor<Repo, RepoCriteria>(){

                public PageList<Repo> execute(RepoCriteria criteria) {
                    return repoManager.findReposByCriteria(RepoScriptSourceProvider.this.rhqFacade.getSubject(), repoCrit);
                }
            };
            CriteriaQuery repos = new CriteriaQuery((BaseCriteria)repoCrit, (CriteriaQueryExecutor)queryExecutor);
            if (!repos.iterator().hasNext()) {
                return null;
            }
            final ContentManagerRemote contentManager = this.rhqFacade.getProxy(ContentManagerRemote.class);
            for (Repo repo : repos) {
                final PackageCriteria pCrit = new PackageCriteria();
                pCrit.addFilterName(scriptName);
                pCrit.addFilterRepoId(Integer.valueOf(repo.getId()));
                CriteriaQueryExecutor<PackageAndLatestVersionComposite, PackageCriteria> pQueryExecutor = new CriteriaQueryExecutor<PackageAndLatestVersionComposite, PackageCriteria>(){

                    public PageList<PackageAndLatestVersionComposite> execute(PackageCriteria criteria) {
                        return contentManager.findPackagesWithLatestVersion(RepoScriptSourceProvider.this.rhqFacade.getSubject(), pCrit);
                    }
                };
                CriteriaQuery pvs = new CriteriaQuery((BaseCriteria)pCrit, (CriteriaQueryExecutor)pQueryExecutor);
                if (!pvs.iterator().hasNext()) continue;
                PackageAndLatestVersionComposite pv = (PackageAndLatestVersionComposite)pvs.iterator().next();
                byte[] bytes = repoManager.getPackageVersionBytes(this.rhqFacade.getSubject(), repo.getId(), pv.getLatestPackageVersion().getId());
                return new InputStreamReader((InputStream)new ByteArrayInputStream(bytes), Charset.forName("UTF-8"));
            }
        }
        catch (Exception e) {
            LOG.debug((Object)("Failed to download bytes for the script: " + scriptUri.toString()), (Throwable)e);
        }
        return null;
    }
}

