/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.bindings;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.MethodDescriptor;
import java.io.IOException;
import java.lang.reflect.Method;
import java.security.PermissionCollection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.bindings.StandardBindings;
import org.rhq.bindings.client.RhqManager;
import org.rhq.bindings.util.MultiScriptSourceProvider;
import org.rhq.bindings.util.NoTopLevelIndirection;
import org.rhq.bindings.util.PackageFinder;
import org.rhq.scripting.CodeCompletion;
import org.rhq.scripting.ScriptEngineInitializer;
import org.rhq.scripting.ScriptEngineProvider;
import org.rhq.scripting.ScriptSourceProvider;

public class ScriptEngineFactory {
    private static final Log LOG = LogFactory.getLog(ScriptEngineFactory.class);
    private static final Map<String, ScriptEngineProvider> KNOWN_PROVIDERS = new HashMap<String, ScriptEngineProvider>();

    private ScriptEngineFactory() {
    }

    public static void reloadScriptEngineProviders(ClassLoader classLoader) {
        if (classLoader == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        ServiceLoader<ScriptEngineProvider> loader = ServiceLoader.load(ScriptEngineProvider.class, classLoader);
        KNOWN_PROVIDERS.clear();
        for (ScriptEngineProvider provider : loader) {
            String lang = provider.getSupportedLanguage();
            if (KNOWN_PROVIDERS.containsKey(lang)) {
                String existing = KNOWN_PROVIDERS.get(lang).getClass().getName();
                String thisOne = provider.getClass().getName();
                throw new IllegalStateException("'" + lang + "' scripting language provided by at least 2 providers: '" + existing + "' and '" + thisOne + "'. Only 1 provider per language is allowed.");
            }
            KNOWN_PROVIDERS.put(lang, provider);
        }
    }

    public static Set<String> getSupportedLanguages() {
        return new HashSet<String>(KNOWN_PROVIDERS.keySet());
    }

    public static String getLanguageByScriptFileExtension(String fileExtension) {
        for (ScriptEngineProvider p : KNOWN_PROVIDERS.values()) {
            if (!fileExtension.equals(p.getScriptFileExtension())) continue;
            return p.getSupportedLanguage();
        }
        return null;
    }

    public static String getFileExtensionForLanguage(String language) {
        ScriptEngineProvider provider = KNOWN_PROVIDERS.get(language);
        if (provider == null) {
            return null;
        }
        return provider.getScriptFileExtension();
    }

    public static ScriptEngine getScriptEngine(String language, PackageFinder packageFinder, StandardBindings bindings) throws ScriptException, IOException {
        return ScriptEngineFactory.getSecuredScriptEngine(language, packageFinder, bindings, null);
    }

    public static ScriptEngine getSecuredScriptEngine(String language, PackageFinder packageFinder, StandardBindings bindings, PermissionCollection permissions) throws ScriptException, IOException {
        ScriptEngineInitializer initializer = ScriptEngineFactory.getInitializer(language);
        if (initializer == null) {
            return null;
        }
        ScriptEngine engine = initializer.instantiate(packageFinder.findPackages("org.rhq.core.domain"), permissions);
        if (bindings != null) {
            ScriptEngineFactory.injectStandardBindings(engine, bindings, true, new ScriptSourceProvider[0]);
        }
        return engine;
    }

    public static void injectStandardBindings(ScriptEngine engine, StandardBindings bindings, boolean deleteExistingBindings, ScriptSourceProvider ... scriptSourceProviders) {
        bindings.preInject(engine);
        Bindings engineBindings = deleteExistingBindings ? engine.createBindings() : engine.getBindings(100);
        for (Map.Entry entry : bindings.entrySet()) {
            engineBindings.put((String)entry.getKey(), entry.getValue());
        }
        if (scriptSourceProviders != null) {
            String language = (String)engine.getFactory().getParameter("javax.script.name");
            ScriptEngineProvider engineProvider = KNOWN_PROVIDERS.get(language);
            if (engineProvider == null) {
                throw new IllegalArgumentException("The supplied script engine [" + engine + "] is not supported.");
            }
            ScriptEngineInitializer initializer = engineProvider.getInitializer();
            MultiScriptSourceProvider provider = null;
            for (ScriptSourceProvider p : scriptSourceProviders) {
                if (!(p instanceof StandardBindings.RhqFacadeChangeListener)) continue;
                bindings.addRhqFacadeChangeListener((StandardBindings.RhqFacadeChangeListener)p);
            }
            provider = new MultiScriptSourceProvider(scriptSourceProviders);
            initializer.installScriptSourceProvider(engine, (ScriptSourceProvider)provider);
        }
        engine.setBindings(engineBindings, 100);
        bindings.postInject(engine);
    }

    public static void removeBindings(ScriptEngine engine, Set<RhqManager> keySet) {
        Bindings engineBindings = engine.getBindings(100);
        for (RhqManager key : keySet) {
            engineBindings.remove(key.name());
        }
        engine.setBindings(engineBindings, 100);
    }

    public static void bindIndirectionMethods(ScriptEngine scriptEngine, String bindingName) {
        Object object = scriptEngine.get(bindingName);
        if (object == null) {
            LOG.debug((Object)("The script engine doesn't contain a binding called '" + bindingName + "'. No indirection functions will be generated."));
            return;
        }
        ScriptEngineInitializer initializer = ScriptEngineFactory.getInitializer((String)scriptEngine.getFactory().getParameter("javax.script.name"));
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(object.getClass(), Object.class);
            MethodDescriptor[] methodDescriptors = beanInfo.getMethodDescriptors();
            HashMap<String, HashSet<Method>> overloadsPerMethodName = new HashMap<String, HashSet<Method>>();
            for (MethodDescriptor methodDescriptor : methodDescriptors) {
                Method method = methodDescriptor.getMethod();
                if (!ScriptEngineFactory.shouldIndirect(method)) continue;
                HashSet<Method> overloads = (HashSet<Method>)overloadsPerMethodName.get(method.getName());
                if (overloads == null) {
                    overloads = new HashSet<Method>();
                    overloadsPerMethodName.put(method.getName(), overloads);
                }
                overloads.add(method);
            }
            for (Set overloads : overloadsPerMethodName.values()) {
                Set methodDefs = initializer.generateIndirectionMethods(bindingName, overloads);
                for (String methodDef : methodDefs) {
                    try {
                        scriptEngine.eval(methodDef);
                    }
                    catch (ScriptException e) {
                        LOG.warn((Object)("Unable to define global function declared as:\n" + methodDef), (Throwable)e);
                    }
                }
            }
        }
        catch (IntrospectionException e) {
            LOG.debug((Object)("Could not inspect class " + object.getClass().getName() + ". No indirection methods for variable '" + bindingName + "' will be generated."), (Throwable)e);
        }
    }

    public static ScriptEngineInitializer getInitializer(String language) {
        ScriptEngineProvider provider = KNOWN_PROVIDERS.get(language);
        return provider == null ? null : provider.getInitializer();
    }

    public static CodeCompletion getCodeCompletion(String language) {
        ScriptEngineProvider provider = KNOWN_PROVIDERS.get(language);
        return provider == null ? null : provider.getCodeCompletion();
    }

    private static boolean shouldIndirect(Method method) {
        return method.getAnnotation(NoTopLevelIndirection.class) == null;
    }

    static {
        ScriptEngineFactory.reloadScriptEngineProviders(null);
    }
}

