/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.validator;

import java.beans.FeatureDescriptor;
import java.util.Collection;
import java.util.EmptyStackException;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Stack;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ELResolver;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.application.Application;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.ajax4jsf.el.ELContextWrapper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.richfaces.component.ClonedObjectResolver;
import org.richfaces.validator.BeanValidator;
import org.richfaces.validator.HibernateValidator;
import org.richfaces.validator.NullValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ObjectValidator {
    private static final String RESOURCE_BUNDLE_IS_NOT_REGISTERED_FOR_CURRENT_LOCALE = "Resource bundle is not registered for current locale";
    private static final String FACES_CONTEXT_IS_NULL = "Faces context is null";
    protected static final String INPUT_PARAMETERS_IS_NOT_CORRECT = "Input parameters is not correct.";
    private static final String LOCALE_IS_NOT_SET = "Locale is not set";
    private static final String VIEW_ROOT_IS_NOT_INITIALIZED = "ViewRoot is not initialized";
    public static final String VALIDATOR_PARAM = HibernateValidator.class.getName();
    private static final Object MUTEX = new Object();
    private static final Log log = LogFactory.getLog(ObjectValidator.class);
    protected final ObjectValidator parent;

    static ObjectValidator createInstance() {
        ObjectValidator validator = null;
        try {
            validator = new BeanValidator();
        }
        catch (Throwable e) {
            // empty catch block
        }
        try {
            validator = new HibernateValidator(validator);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (validator == null) {
            log.warn((Object)"Validator implementations not found at classpath, default NullValidator will be used.");
            validator = new NullValidator();
        }
        return validator;
    }

    ObjectValidator() {
        this.parent = null;
    }

    ObjectValidator(ObjectValidator parent) {
        this.parent = parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ObjectValidator getInstance(FacesContext context) {
        ObjectValidator instance;
        ExternalContext externalContext = context.getExternalContext();
        externalContext.getContext();
        Object object = MUTEX;
        synchronized (object) {
            Map applicationMap = externalContext.getApplicationMap();
            instance = (ObjectValidator)applicationMap.get(VALIDATOR_PARAM);
            if (null == instance) {
                instance = ObjectValidator.createInstance();
                applicationMap.put(VALIDATOR_PARAM, instance);
            }
        }
        return instance;
    }

    public abstract Collection<String> validateGraph(FacesContext var1, Object var2, Set<String> var3);

    public Collection<String> validate(FacesContext context, ValueExpression target, Object value, Set<String> profiles) {
        if (null == context) {
            throw new FacesException(INPUT_PARAMETERS_IS_NOT_CORRECT);
        }
        Collection<String> validationMessages = null;
        if (null != target) {
            ELContext elContext = context.getELContext();
            ValidationResolver validationResolver = this.createValidationResolver(context, elContext.getELResolver(), profiles);
            ELContextWrapper wrappedElContext = new ELContextWrapper(elContext, (ELResolver)validationResolver);
            try {
                target.setValue((ELContext)wrappedElContext, value);
            }
            catch (ELException e) {
                throw new FacesException((Throwable)e);
            }
            if (!validationResolver.isValid()) {
                validationMessages = validationResolver.getValidationMessages();
            }
            if (null != this.parent) {
                Collection<String> parentMessages = this.parent.validate(context, target, value, profiles);
                if (null != validationMessages) {
                    if (null != parentMessages) {
                        validationMessages.addAll(parentMessages);
                    }
                } else {
                    validationMessages = parentMessages;
                }
            }
        }
        return validationMessages;
    }

    protected abstract Collection<String> validate(FacesContext var1, Object var2, String var3, Object var4, Set<String> var5);

    static Locale calculateLocale(FacesContext context) {
        if (null == context.getViewRoot()) {
            throw new FacesException(VIEW_ROOT_IS_NOT_INITIALIZED);
        }
        if (null == context.getViewRoot().getLocale()) {
            throw new FacesException(LOCALE_IS_NOT_SET);
        }
        Locale locale = context.getViewRoot().getLocale();
        return locale;
    }

    static ResourceBundle getResourceBundle(FacesContext facesContext, String name) {
        ResourceBundle bundle = null;
        if (null != facesContext) {
            Application application = facesContext.getApplication();
            try {
                bundle = application.getResourceBundle(facesContext, name);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (null == bundle) {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (null == classLoader) {
                classLoader = ObjectValidator.class.getClassLoader();
            }
            try {
                bundle = ResourceBundle.getBundle(name, ObjectValidator.calculateLocale(facesContext), classLoader);
            }
            catch (MissingResourceException e) {
                // empty catch block
            }
        }
        return bundle;
    }

    protected ValidationResolver createValidationResolver(FacesContext context, ELResolver parent, Set<String> profiles) {
        return new ValidationResolver(parent, context, profiles);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class ValidationResolver
    extends ELResolver {
        private final ELResolver parent;
        private boolean valid = true;
        private Collection<String> validationMessages = null;
        private Stack<BasePropertyPair> valuesStack;
        private Set<String> profiles;
        private FacesContext facesContext;
        private boolean clonedObject = false;

        public ValidationResolver(ELResolver parent, FacesContext context, Set<String> profiles) {
            this.parent = parent;
            this.valuesStack = new Stack();
            this.profiles = profiles;
            this.facesContext = context;
        }

        public boolean isValid() {
            return this.valid;
        }

        public Class<?> getCommonPropertyType(ELContext context, Object base) {
            return this.parent.getCommonPropertyType(context, base);
        }

        public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext context, Object base) {
            return this.parent.getFeatureDescriptors(context, base);
        }

        public Class<?> getType(ELContext context, Object base, Object property) {
            return this.parent.getType(context, base, property);
        }

        public Object getValue(ELContext context, Object base, Object property) {
            Object value = ClonedObjectResolver.resolveCloned(context, base, property);
            if (null != value) {
                this.clonedObject = true;
                context.setPropertyResolved(true);
            } else {
                value = this.parent.getValue(context, base, property);
            }
            this.valuesStack.push(new BasePropertyPair(base, property));
            return value;
        }

        public boolean isReadOnly(ELContext context, Object base, Object property) {
            return this.parent.isReadOnly(context, base, property);
        }

        public void setValue(ELContext context, Object base, Object property, Object value) {
            if (null != base && null != property) {
                if (this.clonedObject) {
                    this.parent.setValue(context, base, property, value);
                }
                context.setPropertyResolved(true);
                BasePropertyPair basePropertyPair = this.lookupBeanProperty(new BasePropertyPair(base, property));
                base = basePropertyPair.getBase();
                property = basePropertyPair.getProperty();
                if (null != base && null != property) {
                    this.validationMessages = ObjectValidator.this.validate(this.facesContext, base, property.toString(), value, this.profiles);
                    this.valid = null == this.validationMessages || 0 == this.validationMessages.size();
                }
            }
        }

        private BasePropertyPair lookupBeanProperty(BasePropertyPair pair) {
            Object base = pair.getBase();
            if (null != base && (base instanceof Collection || base instanceof Map || base.getClass().isArray())) {
                try {
                    pair = this.lookupBeanProperty(this.valuesStack.pop());
                }
                catch (EmptyStackException emptyStackException) {
                    // empty catch block
                }
            }
            return pair;
        }

        public Collection<String> getValidationMessages() {
            return this.validationMessages;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class ValidatorKey {
        private final Class<? extends Object> validatableClass;
        private final Locale locale;

        public ValidatorKey(Class<? extends Object> validatableClass, Locale locale) {
            this.validatableClass = validatableClass;
            this.locale = locale;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.locale == null ? 0 : this.locale.hashCode());
            result = 31 * result + (this.validatableClass == null ? 0 : this.validatableClass.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof ValidatorKey)) {
                return false;
            }
            ValidatorKey other = (ValidatorKey)obj;
            if (this.locale == null ? other.locale != null : !this.locale.equals(other.locale)) {
                return false;
            }
            return !(this.validatableClass == null ? other.validatableClass != null : !this.validatableClass.equals(other.validatableClass));
        }
    }

    protected static class BasePropertyPair {
        private final Object base;
        private final Object property;

        public BasePropertyPair(Object base, Object property) {
            this.base = base;
            this.property = property;
        }

        public Object getBase() {
            return this.base;
        }

        public Object getProperty() {
            return this.property;
        }
    }
}

