/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.clientapi.agent.metadata;

import org.rhq.core.clientapi.descriptor.plugin.DriftDescriptor;
import org.rhq.core.clientapi.descriptor.plugin.DriftFilterDescriptor;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyList;
import org.rhq.core.domain.configuration.PropertyMap;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.drift.DriftDefinition;
import org.rhq.core.domain.drift.DriftDefinitionTemplate;

public class DriftMetadataParser {
    public DriftDefinitionTemplate parseDriftMetadata(DriftDescriptor descriptor) {
        DriftDefinitionTemplate template = new DriftDefinitionTemplate();
        template.setUserDefined(false);
        template.setTemplateDefinition(new DriftDefinition(new Configuration()));
        this.initName(descriptor, template);
        this.initDescription(descriptor, template);
        this.initEnabled(template);
        this.initBasedir(descriptor, template);
        this.initInterval(descriptor, template);
        this.initIncludes(descriptor, template);
        this.initExcludes(descriptor, template);
        return template;
    }

    private void initEnabled(DriftDefinitionTemplate template) {
        template.getConfiguration().put((Property)new PropertySimple("enabled", (Object)true));
    }

    private void initName(DriftDescriptor descriptor, DriftDefinitionTemplate template) {
        template.setName(descriptor.getName());
        template.getConfiguration().put((Property)new PropertySimple("name", (Object)descriptor.getName()));
    }

    private void initDescription(DriftDescriptor descriptor, DriftDefinitionTemplate template) {
        template.setDescription(descriptor.getDescription());
        template.getConfiguration().put((Property)new PropertySimple("description", (Object)descriptor.getDescription()));
    }

    private void initBasedir(DriftDescriptor descriptor, DriftDefinitionTemplate template) {
        DriftDescriptor.Basedir basedir = descriptor.getBasedir();
        String valueContext = basedir.getValueContext();
        String valueName = basedir.getValueName();
        PropertyMap basedirMap = new PropertyMap("basedir");
        basedirMap.put((Property)new PropertySimple("valueContext", (Object)valueContext));
        basedirMap.put((Property)new PropertySimple("valueName", (Object)valueName));
        template.getConfiguration().put((Property)basedirMap);
    }

    private void initInterval(DriftDescriptor descriptor, DriftDefinitionTemplate template) {
        Configuration config = template.getConfiguration();
        if (descriptor.getInterval() == null) {
            config.put((Property)new PropertySimple("interval", (Object)String.valueOf(1800L)));
        } else {
            config.put((Property)new PropertySimple("interval", (Object)descriptor.getInterval()));
        }
    }

    private void initIncludes(DriftDescriptor descriptor, DriftDefinitionTemplate template) {
        if (descriptor.getIncludes() != null && descriptor.getIncludes().getInclude().size() > 0) {
            Configuration config = template.getConfiguration();
            PropertyList includes = new PropertyList("includes");
            for (DriftFilterDescriptor include : descriptor.getIncludes().getInclude()) {
                PropertyMap includeMap = new PropertyMap("include");
                includeMap.put((Property)new PropertySimple("path", (Object)include.getPath()));
                includeMap.put((Property)new PropertySimple("pattern", (Object)include.getPattern()));
                includes.add((Property)includeMap);
            }
            config.put((Property)includes);
        }
    }

    private void initExcludes(DriftDescriptor descriptor, DriftDefinitionTemplate template) {
        if (descriptor.getExcludes() != null && descriptor.getExcludes().getExclude().size() > 0) {
            Configuration config = template.getConfiguration();
            PropertyList excludes = new PropertyList("excludes");
            for (DriftFilterDescriptor exclude : descriptor.getExcludes().getExclude()) {
                PropertyMap excludeMap = new PropertyMap("exclude");
                excludeMap.put((Property)new PropertySimple("path", (Object)exclude.getPath()));
                excludeMap.put((Property)new PropertySimple("pattern", (Object)exclude.getPattern()));
                excludes.add((Property)excludeMap);
            }
            config.put((Property)excludes);
        }
    }
}

