/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.resourceadapters;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.connector.subsystems.resourceadapters.AS7ResourceAdapterTags;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.AttributeMarshaller;
import org.jboss.as.controller.PrimitiveListAttributeDefinition;
import org.jboss.as.controller.PropertiesAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.client.helpers.MeasurementUnit;
import org.jboss.as.controller.operations.validation.EnumValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.jca.common.api.metadata.Defaults;
import org.jboss.jca.common.api.metadata.common.CommonSecurity;
import org.jboss.jca.common.api.metadata.common.CommonXaPool;
import org.jboss.jca.common.api.metadata.common.Credential;
import org.jboss.jca.common.api.metadata.common.Extension;
import org.jboss.jca.common.api.metadata.common.Recovery;
import org.jboss.jca.common.api.metadata.common.TransactionSupportEnum;
import org.jboss.jca.common.api.metadata.common.v10.CommonConnDef;
import org.jboss.jca.common.api.metadata.ds.TimeOut;
import org.jboss.jca.common.api.metadata.ds.v11.DataSource;
import org.jboss.jca.common.api.metadata.resourceadapter.v10.ResourceAdapter;

public class Constants {
    public static final String RESOURCEADAPTER_NAME = "resource-adapter";
    static final String RESOURCEADAPTERS_NAME = "resource-adapters";
    public static final String IRONJACAMAR_NAME = "ironjacamar";
    public static final String STATISTICS_NAME = "statistics";
    public static final String CONNECTIONDEFINITIONS_NAME = "connection-definitions";
    private static final String CLASS_NAME_NAME = "class-name";
    static final String POOL_NAME_NAME = "pool-name";
    private static final String USE_JAVA_CONTEXT_NAME = "use-java-context";
    private static final String ENABLED_NAME = "enabled";
    private static final String JNDINAME_NAME = "jndi-name";
    private static final String ALLOCATION_RETRY_NAME = "allocation-retry";
    private static final String ALLOCATION_RETRY_WAIT_MILLIS_NAME = "allocation-retry-wait-millis";
    private static final String XA_RESOURCE_TIMEOUT_NAME = "xa-resource-timeout";
    private static final String USETRYLOCK_NAME = "use-try-lock";
    private static final String SECURITY_DOMAIN_AND_APPLICATION_NAME = "security-domain-and-application";
    private static final String SECURITY_DOMAIN_NAME = "security-domain";
    private static final String APPLICATION_NAME = "security-application";
    private static final String USE_CCM_NAME = "use-ccm";
    private static final String CONFIG_PROPERTIES_NAME = "config-properties";
    private static final String CONFIG_PROPERTY_VALUE_NAME = "value";
    private static final String ARCHIVE_NAME = "archive";
    private static final String MODULE_NAME = "module";
    private static final String BOOTSTRAPCONTEXT_NAME = "bootstrap-context";
    private static final String TRANSACTIONSUPPORT_NAME = "transaction-support";
    private static final String BEANVALIDATIONGROUPS_NAME = "beanvalidationgroups";
    static final String ADMIN_OBJECTS_NAME = "admin-objects";
    private static final String INTERLEAVING_NAME = "interleaving";
    private static final String NOTXSEPARATEPOOL_NAME = "no-tx-separate-pool";
    private static final String PAD_XID_NAME = "pad-xid";
    private static final String SAME_RM_OVERRIDE_NAME = "same-rm-override";
    private static final String WRAP_XA_RESOURCE_NAME = "wrap-xa-resource";
    private static final String RECOVERY_USERNAME_NAME = "recovery-username";
    private static final String RECOVERY_PASSWORD_NAME = "recovery-password";
    private static final String RECOVERY_SECURITY_DOMAIN_NAME = "recovery-security-domain";
    private static final String RECOVERLUGIN_CLASSNAME_NAME = "recovery-plugin-class-name";
    private static final String RECOVERLUGIN_PROPERTIES_NAME = "recovery-plugin-properties";
    private static final String NO_RECOVERY_NAME = "no-recovery";
    public static final String ACTIVATE = "activate";
    public static final String FLUSH_ALL_CONNECTION_IN_POOL = "flush-all-connection-in-pool";
    public static final String FLUSH_IDLE_CONNECTION_IN_POOL = "flush-idle-connection-in-pool";
    public static final String TEST_CONNECTION_IN_POOL = "test-connection-in-pool";
    public static final String CLEAR_STATISTICS = "clear-statistics";
    static final SimpleAttributeDefinition CLASS_NAME = new SimpleAttributeDefinition("class-name", CommonConnDef.Attribute.CLASS_NAME.getLocalName(), new ModelNode(), ModelType.STRING, false, true, MeasurementUnit.NONE);
    static SimpleAttributeDefinition JNDINAME = new SimpleAttributeDefinition("jndi-name", CommonConnDef.Attribute.JNDI_NAME.getLocalName(), new ModelNode(), ModelType.STRING, true, true, MeasurementUnit.NONE);
    public static final SimpleAttributeDefinition CONFIG_PROPERTIES = new SimpleAttributeDefinition("config-properties", CommonConnDef.Tag.CONFIG_PROPERTY.getLocalName(), new ModelNode(), ModelType.STRING, true, true, MeasurementUnit.NONE);
    static final SimpleAttributeDefinition CONFIG_PROPERTY_VALUE = new SimpleAttributeDefinition("value", CommonConnDef.Tag.CONFIG_PROPERTY.getLocalName(), new ModelNode(), ModelType.STRING, true, true, MeasurementUnit.NONE);
    static final SimpleAttributeDefinition ARCHIVE = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"archive", (ModelType)ModelType.STRING).setXmlName(ResourceAdapter.Tag.ARCHIVE.getLocalName()).setAllowNull(true).setAllowExpression(false).setMeasurementUnit(MeasurementUnit.NONE).setAttributeMarshaller(new AttributeMarshaller(){

        public void marshallAsElement(AttributeDefinition attribute, ModelNode resourceModel, boolean marshallDefault, XMLStreamWriter writer) throws XMLStreamException {
            if (resourceModel.hasDefined(attribute.getName())) {
                writer.writeStartElement(attribute.getXmlName());
                String archive = resourceModel.get(attribute.getName()).asString();
                if (archive.contains("->")) {
                    writer.writeCharacters(archive.substring(0, archive.indexOf("->")));
                } else {
                    writer.writeCharacters(archive);
                }
                writer.writeEndElement();
            }
        }
    })).setAlternatives(new String[]{"module"}).build();
    static final SimpleAttributeDefinition MODULE = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"module", (ModelType)ModelType.STRING).setXmlName(AS7ResourceAdapterTags.MODULE.getLocalName()).setAllowNull(true).setAllowExpression(false).setMeasurementUnit(MeasurementUnit.NONE).setAttributeMarshaller(new AttributeMarshaller(){

        public void marshallAsElement(AttributeDefinition attribute, ModelNode resourceModel, boolean marshallDefault, XMLStreamWriter writer) throws XMLStreamException {
            if (resourceModel.hasDefined(attribute.getName())) {
                writer.writeStartElement(attribute.getXmlName());
                String module = resourceModel.get(attribute.getName()).asString();
                int separatorIndex = module.indexOf(":");
                if (separatorIndex != -1) {
                    writer.writeAttribute("slot", module.substring(separatorIndex + 1));
                    module = module.substring(0, separatorIndex);
                } else if (marshallDefault) {
                    writer.writeAttribute("slot", "main");
                }
                if (module.contains("->")) {
                    writer.writeAttribute("id", module.substring(0, module.indexOf("->")));
                } else {
                    writer.writeAttribute("id", module);
                }
                writer.writeEndElement();
            }
        }
    })).setAlternatives(new String[]{"archive"}).build();
    static final SimpleAttributeDefinition BOOTSTRAP_CONTEXT = new SimpleAttributeDefinition("bootstrap-context", ResourceAdapter.Tag.BOOTSTRAP_CONTEXT.getLocalName(), new ModelNode(), ModelType.STRING, true, true, MeasurementUnit.NONE);
    static final SimpleAttributeDefinition TRANSACTION_SUPPORT = new SimpleAttributeDefinition("transaction-support", ResourceAdapter.Tag.TRANSACTION_SUPPORT.getLocalName(), new ModelNode(), ModelType.STRING, true, true, MeasurementUnit.NONE, (ParameterValidator)new EnumValidator(TransactionSupportEnum.class, true, true));
    static final PrimitiveListAttributeDefinition BEANVALIDATION_GROUPS = ((PrimitiveListAttributeDefinition.Builder)((PrimitiveListAttributeDefinition.Builder)((PrimitiveListAttributeDefinition.Builder)((PrimitiveListAttributeDefinition.Builder)PrimitiveListAttributeDefinition.Builder.of((String)"beanvalidationgroups", (ModelType)ModelType.STRING).setXmlName(ResourceAdapter.Tag.BEAN_VALIDATION_GROUP.getLocalName())).setAllowNull(true)).setAllowExpression(true)).setValidator((ParameterValidator)new StringLengthValidator(1, false, true))).build();
    static final SimpleAttributeDefinition BEANVALIDATIONGROUP = new SimpleAttributeDefinition("beanvalidationgroups", ResourceAdapter.Tag.BEAN_VALIDATION_GROUP.getLocalName(), new ModelNode(), ModelType.STRING, true, true, MeasurementUnit.NONE);
    static SimpleAttributeDefinition USE_JAVA_CONTEXT = new SimpleAttributeDefinition("use-java-context", DataSource.Attribute.USE_JAVA_CONTEXT.getLocalName(), new ModelNode().set(Defaults.USE_JAVA_CONTEXT.booleanValue()), ModelType.BOOLEAN, true, true, MeasurementUnit.NONE);
    static SimpleAttributeDefinition ENABLED = new SimpleAttributeDefinition("enabled", DataSource.Attribute.ENABLED.getLocalName(), new ModelNode().set(Defaults.ENABLED.booleanValue()), ModelType.BOOLEAN, true, true, MeasurementUnit.NONE);
    static SimpleAttributeDefinition SECURITY_DOMAIN = new SimpleAttributeDefinitionBuilder("security-domain", ModelType.STRING).setXmlName(CommonSecurity.Tag.SECURITY_DOMAIN.getLocalName()).setAllowExpression(true).setAllowNull(true).setAlternatives(new String[]{"security-domain-and-application", "security-application"}).build();
    static final SimpleAttributeDefinition SECURITY_DOMAIN_AND_APPLICATION = new SimpleAttributeDefinitionBuilder("security-domain-and-application", ModelType.STRING).setXmlName(CommonSecurity.Tag.SECURITY_DOMAIN_AND_APPLICATION.getLocalName()).setAllowExpression(true).setAllowNull(true).setAlternatives(new String[]{"security-domain", "security-application"}).build();
    static final SimpleAttributeDefinition APPLICATION = new SimpleAttributeDefinitionBuilder("security-application", ModelType.BOOLEAN).setXmlName(CommonSecurity.Tag.APPLICATION.getLocalName()).setDefaultValue(new ModelNode(Defaults.APPLICATION_MANAGED_SECURITY.booleanValue())).setAllowExpression(true).setAllowNull(true).setMeasurementUnit(MeasurementUnit.NONE).setAlternatives(new String[]{"security-domain", "security-domain-and-application"}).build();
    static SimpleAttributeDefinition ALLOCATION_RETRY = new SimpleAttributeDefinition("allocation-retry", TimeOut.Tag.ALLOCATION_RETRY.getLocalName(), new ModelNode(), ModelType.INT, true, true, MeasurementUnit.NONE);
    static SimpleAttributeDefinition ALLOCATION_RETRY_WAIT_MILLIS = new SimpleAttributeDefinition("allocation-retry-wait-millis", TimeOut.Tag.ALLOCATION_RETRY_WAIT_MILLIS.getLocalName(), new ModelNode(), ModelType.LONG, true, true, MeasurementUnit.NONE);
    static SimpleAttributeDefinition USETRYLOCK = new SimpleAttributeDefinition("use-try-lock", TimeOut.Tag.USE_TRY_LOCK.getLocalName(), new ModelNode(), ModelType.LONG, true, true, MeasurementUnit.NONE);
    static SimpleAttributeDefinition USE_CCM = new SimpleAttributeDefinition("use-ccm", DataSource.Attribute.USE_CCM.getLocalName(), new ModelNode().set(Defaults.USE_CCM.booleanValue()), ModelType.BOOLEAN, true, true, MeasurementUnit.NONE);
    static SimpleAttributeDefinition INTERLEAVING = new SimpleAttributeDefinition("interleaving", CommonXaPool.Tag.INTERLEAVING.getLocalName(), new ModelNode().set(Defaults.INTERLEAVING.booleanValue()), ModelType.BOOLEAN, true, true, MeasurementUnit.NONE);
    static SimpleAttributeDefinition NOTXSEPARATEPOOL = new SimpleAttributeDefinition("no-tx-separate-pool", CommonXaPool.Tag.NO_TX_SEPARATE_POOLS.getLocalName(), new ModelNode().set(Defaults.NO_TX_SEPARATE_POOL.booleanValue()), ModelType.BOOLEAN, true, true, MeasurementUnit.NONE);
    static SimpleAttributeDefinition PAD_XID = new SimpleAttributeDefinition("pad-xid", CommonXaPool.Tag.PAD_XID.getLocalName(), new ModelNode().set(Defaults.PAD_XID.booleanValue()), ModelType.BOOLEAN, true, true, MeasurementUnit.NONE);
    static SimpleAttributeDefinition SAME_RM_OVERRIDE = new SimpleAttributeDefinitionBuilder("same-rm-override", ModelType.BOOLEAN).setAllowNull(true).setAllowExpression(true).setXmlName(CommonXaPool.Tag.IS_SAME_RM_OVERRIDE.getLocalName()).build();
    static SimpleAttributeDefinition WRAP_XA_RESOURCE = new SimpleAttributeDefinition("wrap-xa-resource", CommonXaPool.Tag.WRAP_XA_RESOURCE.getLocalName(), new ModelNode().set(Defaults.WRAP_XA_RESOURCE.booleanValue()), ModelType.BOOLEAN, true, true, MeasurementUnit.NONE);
    static SimpleAttributeDefinition XA_RESOURCE_TIMEOUT = new SimpleAttributeDefinition("xa-resource-timeout", TimeOut.Tag.XA_RESOURCE_TIMEOUT.getLocalName(), new ModelNode(), ModelType.INT, true, true, MeasurementUnit.NONE);
    static SimpleAttributeDefinition RECOVERY_USERNAME = new SimpleAttributeDefinition("recovery-username", Credential.Tag.USER_NAME.getLocalName(), new ModelNode(), ModelType.STRING, true, true, MeasurementUnit.NONE);
    static SimpleAttributeDefinition RECOVERY_PASSWORD = new SimpleAttributeDefinition("recovery-password", Credential.Tag.PASSWORD.getLocalName(), new ModelNode(), ModelType.STRING, true, true, MeasurementUnit.NONE);
    static SimpleAttributeDefinition RECOVERY_SECURITY_DOMAIN = new SimpleAttributeDefinition("recovery-security-domain", Credential.Tag.SECURITY_DOMAIN.getLocalName(), new ModelNode(), ModelType.STRING, true, true, MeasurementUnit.NONE);
    static SimpleAttributeDefinition NO_RECOVERY = new SimpleAttributeDefinition("no-recovery", Recovery.Attribute.NO_RECOVERY.getLocalName(), new ModelNode(false), ModelType.BOOLEAN, true, true, MeasurementUnit.NONE);
    static SimpleAttributeDefinition RECOVERLUGIN_CLASSNAME = new SimpleAttributeDefinition("recovery-plugin-class-name", Extension.Attribute.CLASS_NAME.getLocalName(), new ModelNode(), ModelType.STRING, true, true, MeasurementUnit.NONE);
    static PropertiesAttributeDefinition RECOVERLUGIN_PROPERTIES = ((PropertiesAttributeDefinition.Builder)((PropertiesAttributeDefinition.Builder)new PropertiesAttributeDefinition.Builder("recovery-plugin-properties", true).setAllowExpression(true)).setXmlName(Extension.Tag.CONFIG_PROPERTY.getLocalName())).build();
}

