/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.mail.extension;

import java.util.List;
import java.util.Map;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.mail.extension.Credentials;
import org.jboss.as.mail.extension.CustomServerConfig;
import org.jboss.as.mail.extension.MailLogger;
import org.jboss.as.mail.extension.MailServerDefinition;
import org.jboss.as.mail.extension.MailSessionConfig;
import org.jboss.as.mail.extension.MailSessionDefinition;
import org.jboss.as.mail.extension.MailSessionService;
import org.jboss.as.mail.extension.ServerConfig;
import org.jboss.as.naming.ContextListAndJndiViewManagedReferenceFactory;
import org.jboss.as.naming.ContextListManagedReferenceFactory;
import org.jboss.as.naming.ManagedReference;
import org.jboss.as.naming.ServiceBasedNamingStore;
import org.jboss.as.naming.ValueManagedReference;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.naming.service.BinderService;
import org.jboss.as.network.OutboundSocketBinding;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.msc.service.AbstractServiceListener;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.ImmediateValue;
import org.jboss.msc.value.Value;

class MailSessionAdd
extends AbstractAddStepHandler {
    static final MailSessionAdd INSTANCE = new MailSessionAdd();
    public static final ServiceName SERVICE_NAME_BASE = ServiceName.JBOSS.append(new String[]{"mail-session"});

    protected MailSessionAdd() {
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        MailSessionDefinition.JNDI_NAME.validateAndSet(operation, model);
        MailSessionDefinition.DEBUG.validateAndSet(operation, model);
        MailSessionDefinition.FROM.validateAndSet(operation, model);
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> controllers) throws OperationFailedException {
        final String jndiName = MailSessionAdd.getJndiName(operation);
        ServiceTarget serviceTarget = context.getServiceTarget();
        ModelNode fullTree = Resource.Tools.readModel((Resource)context.readResource(PathAddress.EMPTY_ADDRESS));
        MailSessionConfig config = MailSessionAdd.from(context, fullTree);
        final MailSessionService service = new MailSessionService(config);
        ServiceName serviceName = SERVICE_NAME_BASE.append(new String[]{jndiName});
        ServiceBuilder mailSessionBuilder = serviceTarget.addService(serviceName, (Service)service);
        this.addOutboundSocketDependency(service, mailSessionBuilder, config.getImapServer());
        this.addOutboundSocketDependency(service, mailSessionBuilder, config.getPop3Server());
        this.addOutboundSocketDependency(service, mailSessionBuilder, config.getSmtpServer());
        for (CustomServerConfig server : config.getCustomServers()) {
            if (server.getOutgoingSocketBinding() == null) continue;
            this.addOutboundSocketDependency(service, mailSessionBuilder, server);
        }
        ContextListAndJndiViewManagedReferenceFactory valueManagedReferenceFactory = new ContextListAndJndiViewManagedReferenceFactory(){

            public String getJndiViewInstanceValue() {
                return String.valueOf(this.getReference().getInstance());
            }

            public String getInstanceClassName() {
                Object value = this.getReference().getInstance();
                return value != null ? value.getClass().getName() : ContextListManagedReferenceFactory.DEFAULT_INSTANCE_CLASS_NAME;
            }

            public ManagedReference getReference() {
                return new ValueManagedReference((Value)new ImmediateValue((Object)service.getValue()));
            }
        };
        ContextNames.BindInfo bindInfo = ContextNames.bindInfoFor((String)jndiName);
        BinderService binderService = new BinderService(bindInfo.getBindName());
        ServiceBuilder binderBuilder = serviceTarget.addService(bindInfo.getBinderServiceName(), (Service)binderService).addInjection(binderService.getManagedObjectInjector(), (Object)valueManagedReferenceFactory).addDependency(bindInfo.getParentContextServiceName(), ServiceBasedNamingStore.class, binderService.getNamingStoreInjector()).addListener((ServiceListener)new AbstractServiceListener<Object>(){

            public void transition(ServiceController<? extends Object> controller, ServiceController.Transition transition) {
                switch (transition) {
                    case STARTING_to_UP: {
                        MailLogger.ROOT_LOGGER.boundMailSession(jndiName);
                        break;
                    }
                    case START_REQUESTED_to_DOWN: {
                        MailLogger.ROOT_LOGGER.unboundMailSession(jndiName);
                        break;
                    }
                    case REMOVING_to_REMOVED: {
                        MailLogger.ROOT_LOGGER.removedMailSession(jndiName);
                    }
                }
            }
        });
        mailSessionBuilder.setInitialMode(ServiceController.Mode.ACTIVE).addListener((ServiceListener)verificationHandler);
        binderBuilder.setInitialMode(ServiceController.Mode.ACTIVE).addListener((ServiceListener)verificationHandler);
        controllers.add(mailSessionBuilder.install());
        controllers.add(binderBuilder.install());
    }

    public static String getJndiName(ModelNode modelNode) {
        String rawJndiName = modelNode.require("jndi-name").asString();
        String jndiName = !rawJndiName.startsWith("java:") ? "java:jboss/mail/" + rawJndiName : rawJndiName;
        return jndiName;
    }

    private void addOutboundSocketDependency(MailSessionService service, ServiceBuilder<?> mailSessionBuilder, ServerConfig server) {
        if (server != null) {
            String ref = server.getOutgoingSocketBinding();
            mailSessionBuilder.addDependency(OutboundSocketBinding.OUTBOUND_SOCKET_BINDING_BASE_SERVICE_NAME.append(new String[]{ref}), OutboundSocketBinding.class, service.getSocketBindingInjector(ref));
        }
    }

    static MailSessionConfig from(OperationContext operationContext, ModelNode model) throws OperationFailedException {
        MailSessionConfig cfg = new MailSessionConfig();
        cfg.setJndiName(MailSessionDefinition.JNDI_NAME.resolveModelAttribute(operationContext, model).asString());
        cfg.setDebug(MailSessionDefinition.DEBUG.resolveModelAttribute(operationContext, model).asBoolean());
        if (MailSessionDefinition.FROM.resolveModelAttribute(operationContext, model).isDefined()) {
            cfg.setFrom(MailSessionDefinition.FROM.resolveModelAttribute(operationContext, model).asString());
        }
        if (model.hasDefined("server")) {
            ModelNode server = model.get("server");
            if (server.hasDefined("smtp")) {
                cfg.setSmtpServer(MailSessionAdd.readServerConfig(operationContext, server.get("smtp")));
            }
            if (server.hasDefined("pop3")) {
                cfg.setPop3Server(MailSessionAdd.readServerConfig(operationContext, server.get("pop3")));
            }
            if (server.hasDefined("imap")) {
                cfg.setImapServer(MailSessionAdd.readServerConfig(operationContext, server.get("imap")));
            }
        }
        if (model.hasDefined("custom")) {
            for (Property server : model.get("custom").asPropertyList()) {
                cfg.addCustomServer(MailSessionAdd.readCustomServerConfig(server.getName(), operationContext, server.getValue()));
            }
        }
        return cfg;
    }

    private static ServerConfig readServerConfig(OperationContext operationContext, ModelNode model) throws OperationFailedException {
        String socket = MailServerDefinition.OUTBOUND_SOCKET_BINDING_REF.resolveModelAttribute(operationContext, model).asString();
        Credentials credentials = MailSessionAdd.readCredentials(operationContext, model);
        boolean ssl = MailServerDefinition.SSL.resolveModelAttribute(operationContext, model).asBoolean();
        boolean tls = MailServerDefinition.TLS.resolveModelAttribute(operationContext, model).asBoolean();
        return new ServerConfig(socket, credentials, ssl, tls, null);
    }

    private static CustomServerConfig readCustomServerConfig(String protocol, OperationContext operationContext, ModelNode model) throws OperationFailedException {
        ModelNode socketModel = MailServerDefinition.OUTBOUND_SOCKET_BINDING_REF_OPTIONAL.resolveModelAttribute(operationContext, model);
        String socket = socketModel.isDefined() ? socketModel.asString() : null;
        Credentials credentials = MailSessionAdd.readCredentials(operationContext, model);
        boolean ssl = MailServerDefinition.SSL.resolveModelAttribute(operationContext, model).asBoolean();
        boolean tls = MailServerDefinition.TLS.resolveModelAttribute(operationContext, model).asBoolean();
        Map properties = MailServerDefinition.PROPERTIES.unwrap(operationContext, model);
        return new CustomServerConfig(protocol, socket, credentials, ssl, tls, properties);
    }

    private static Credentials readCredentials(OperationContext operationContext, ModelNode model) throws OperationFailedException {
        if (model.get("username").isDefined()) {
            String un = MailServerDefinition.USERNAME.resolveModelAttribute(operationContext, model).asString();
            String pw = MailServerDefinition.PASSWORD.resolveModelAttribute(operationContext, model).asString();
            return new Credentials(un, pw);
        }
        return null;
    }
}

