/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.postgres;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.plugins.database.DatabasePluginUtil;
import org.rhq.plugins.postgres.PostgresServerComponent;

public class PostgresUserDiscoveryComponent
implements ResourceDiscoveryComponent<PostgresServerComponent<?>> {
    private static final Log LOG = LogFactory.getLog(PostgresUserDiscoveryComponent.class);
    public static final String USERS_QUERY = "select * from pg_roles";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext<PostgresServerComponent<?>> context) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Discovering postgres users for " + ((PostgresServerComponent)context.getParentResourceComponent()).getJDBCUrl() + "..."));
        }
        HashSet<DiscoveredResourceDetails> discoveredUsers = new HashSet<DiscoveredResourceDetails>();
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            connection = ((PostgresServerComponent)context.getParentResourceComponent()).getPooledConnectionProvider().getPooledConnection();
            statement = connection.createStatement();
            resultSet = statement.executeQuery(USERS_QUERY);
            while (resultSet.next()) {
                String userName = resultSet.getString("rolname");
                DiscoveredResourceDetails service = new DiscoveredResourceDetails(context.getResourceType(), userName, userName, null, "A Postgres user", null, null);
                service.getPluginConfiguration().put((Property)new PropertySimple("userName", (Object)userName));
                discoveredUsers.add(service);
            }
        }
        catch (Throwable throwable) {
            DatabasePluginUtil.safeClose((Connection)connection, statement, resultSet);
            throw throwable;
        }
        DatabasePluginUtil.safeClose((Connection)connection, (Statement)statement, (ResultSet)resultSet);
        return discoveredUsers;
    }
}

