/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.postgres;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.plugins.database.DatabasePluginUtil;
import org.rhq.plugins.postgres.PostgresDatabaseComponent;

public class PostgresTableDiscoveryComponent
implements ResourceDiscoveryComponent<PostgresDatabaseComponent> {
    private static final Log LOG = LogFactory.getLog(PostgresTableDiscoveryComponent.class);
    public static final String TABLE_NAMES_QUERY = "select relname from pg_stat_user_tables";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext<PostgresDatabaseComponent> context) throws Exception {
        ResultSet resultSet;
        Statement statement;
        Connection connection;
        HashSet<DiscoveredResourceDetails> discoveredTables;
        block6: {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Discovering postgres tables for " + ((PostgresDatabaseComponent)context.getParentResourceComponent()).getDatabaseName() + "..."));
            }
            discoveredTables = new HashSet<DiscoveredResourceDetails>();
            connection = null;
            statement = null;
            resultSet = null;
            try {
                connection = ((PostgresDatabaseComponent)context.getParentResourceComponent()).getPooledConnectionProvider().getPooledConnection();
                statement = connection.createStatement();
                resultSet = statement.executeQuery(TABLE_NAMES_QUERY);
                while (resultSet.next()) {
                    String tableName = resultSet.getString(1);
                    DiscoveredResourceDetails service = new DiscoveredResourceDetails(context.getResourceType(), tableName, tableName, null, null, null, null);
                    service.getPluginConfiguration().put((Property)new PropertySimple("tableName", (Object)tableName));
                    discoveredTables.add(service);
                }
                if (!LOG.isDebugEnabled()) break block6;
                LOG.debug((Object)("Found " + discoveredTables.size() + " tables in database " + ((PostgresDatabaseComponent)context.getParentResourceComponent()).getDatabaseName()));
            }
            catch (SQLException e) {
                block7: {
                    try {
                        if (!LOG.isDebugEnabled()) break block7;
                        LOG.debug((Object)("Could not find tables in database " + ((PostgresDatabaseComponent)context.getParentResourceComponent()).getDatabaseName()), (Throwable)e);
                    }
                    catch (Throwable throwable) {
                        DatabasePluginUtil.safeClose((Connection)connection, statement, resultSet);
                        throw throwable;
                    }
                }
                DatabasePluginUtil.safeClose((Connection)connection, (Statement)statement, resultSet);
            }
        }
        DatabasePluginUtil.safeClose((Connection)connection, (Statement)statement, (ResultSet)resultSet);
        return discoveredTables;
    }
}

