/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging.jms.bridge;

import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.messaging.MessagingMessages;
import org.jboss.as.messaging.MessagingServices;
import org.jboss.as.messaging.jms.bridge.JMSBridgeService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;

public class JMSBridgeRemove
extends AbstractRemoveStepHandler {
    public static final String OPERATION_NAME = "remove";
    public static JMSBridgeRemove INSTANCE = new JMSBridgeRemove();

    private JMSBridgeRemove() {
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
        String bridgeName = address.getLastElement().getValue();
        context.removeService(MessagingServices.getJMSBridgeServiceName(bridgeName));
    }

    protected void recoverServices(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        ServiceName jmsBridgeServiceName;
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
        String bridgeName = address.getLastElement().getValue();
        ServiceRegistry registry = context.getServiceRegistry(true);
        ServiceController jmsBridgeServiceController = registry.getService(jmsBridgeServiceName = MessagingServices.getJMSBridgeServiceName(bridgeName));
        if (jmsBridgeServiceController != null && jmsBridgeServiceController.getState() == ServiceController.State.UP) {
            JMSBridgeService jmsBridgeService = (JMSBridgeService)jmsBridgeServiceController.getService();
            try {
                jmsBridgeService.startBridge();
            }
            catch (Exception e) {
                throw MessagingMessages.MESSAGES.failedToRecover(e, bridgeName);
            }
        }
    }
}

