/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3;

import java.io.IOException;
import org.jboss.remoting3.Endpoint;
import org.jboss.remoting3.EndpointImpl;
import org.jboss.remoting3.security.RemotingPermission;
import org.xnio.OptionMap;
import org.xnio.Xnio;

public final class Remoting {
    private static final RemotingPermission CREATE_ENDPOINT_PERM = new RemotingPermission("createEndpoint");

    public static Endpoint createEndpoint(String endpointName, Xnio xnio, OptionMap optionMap) throws IOException {
        if (endpointName == null) {
            throw new IllegalArgumentException("endpointName is null");
        }
        if (optionMap == null) {
            throw new IllegalArgumentException("optionMap is null");
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(CREATE_ENDPOINT_PERM);
        }
        return EndpointImpl.construct(xnio, endpointName, optionMap);
    }

    public static Endpoint createEndpoint(String endpointName, OptionMap optionMap) throws IOException {
        return Remoting.createEndpoint(endpointName, Xnio.getInstance(Remoting.class.getClassLoader()), optionMap);
    }

    public static Endpoint createEndpoint(OptionMap optionMap) throws IOException {
        return Remoting.createEndpoint(null, optionMap);
    }

    public static Endpoint createEndpoint() throws IOException {
        return Remoting.createEndpoint(null, OptionMap.EMPTY);
    }

    private Remoting() {
    }
}

