/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.oracle;

import java.sql.Driver;
import java.util.Properties;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.plugins.database.BasePooledConnectionProvider;
import org.rhq.plugins.oracle.OracleServerComponent;

public class OraclePooledConnectionProvider
extends BasePooledConnectionProvider {
    static final String DRIVER_CLASS_PROPERTY = "driverClass";
    static final String PRINCIPAL_PROPERTY = "principal";
    static final String CREDENTIALS_PROPERTY = "credentials";

    public OraclePooledConnectionProvider(Configuration pluginConfig) throws Exception {
        super(pluginConfig);
    }

    protected Class<Driver> getDriverClass() throws ClassNotFoundException {
        return Class.forName(this.pluginConfig.getSimple(DRIVER_CLASS_PROPERTY).getStringValue());
    }

    protected String getJdbcUrl() {
        return OracleServerComponent.buildUrl(this.pluginConfig);
    }

    protected String getUsername() {
        return this.pluginConfig.getSimple(PRINCIPAL_PROPERTY).getStringValue();
    }

    protected String getPassword() {
        return this.pluginConfig.getSimple(CREDENTIALS_PROPERTY).getStringValue();
    }

    protected Properties getConnectionProperties() {
        Properties connectionProperties = super.getConnectionProperties();
        if (this.getUsername().equalsIgnoreCase("SYS")) {
            connectionProperties.put("internal_logon", "sysdba");
        }
        return connectionProperties;
    }
}

