/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.communications.command.client;

import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import mazz.i18n.Logger;
import org.jboss.remoting.Client;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.ServerInvoker;
import org.rhq.core.util.exception.ThrowableUtil;
import org.rhq.enterprise.communications.command.Command;
import org.rhq.enterprise.communications.command.CommandResponse;
import org.rhq.enterprise.communications.command.client.FailureCallback;
import org.rhq.enterprise.communications.command.client.InitializeCallback;
import org.rhq.enterprise.communications.command.client.OutgoingCommandTrace;
import org.rhq.enterprise.communications.command.client.RemoteCommunicator;
import org.rhq.enterprise.communications.command.impl.generic.GenericCommandResponse;
import org.rhq.enterprise.communications.i18n.CommI18NFactory;
import org.rhq.enterprise.communications.util.NotPermittedException;

public class JBossRemotingRemoteCommunicator
implements RemoteCommunicator {
    private static final Logger LOG = CommI18NFactory.getLogger(JBossRemotingRemoteCommunicator.class);
    public static final String DEFAULT_SUBSYSTEM = "RHQ";
    private volatile InvokerLocator m_invokerLocator;
    private final String m_subsystem;
    private final Map<String, String> m_clientConfiguration;
    private volatile AtomicReference<Client> m_client = new AtomicReference();
    private volatile FailureCallback m_failureCallback;
    private volatile InitializeCallback m_initializeCallback;
    private volatile boolean m_needToCallInitializeCallback;
    private final ReentrantReadWriteLock m_needToCallInitializeCallbackLock;
    private final long m_initializeCallbackLockAcquisitionTimeoutMins;

    public JBossRemotingRemoteCommunicator(String locatorUri) throws MalformedURLException {
        this(new InvokerLocator(locatorUri), DEFAULT_SUBSYSTEM, null);
    }

    public JBossRemotingRemoteCommunicator(String locatorUri, Map<String, String> client_config) throws MalformedURLException {
        this(new InvokerLocator(locatorUri), DEFAULT_SUBSYSTEM, client_config);
    }

    public JBossRemotingRemoteCommunicator(InvokerLocator locator, String subsystem, Map<String, String> client_config) {
        long mins;
        this.m_invokerLocator = locator;
        this.m_subsystem = subsystem;
        this.m_clientConfiguration = new HashMap<String, String>();
        if (client_config != null) {
            this.m_clientConfiguration.putAll(client_config);
        }
        this.m_needToCallInitializeCallback = false;
        this.m_needToCallInitializeCallbackLock = new ReentrantReadWriteLock();
        try {
            String minsStr = System.getProperty("rhq.communications.initial-callback-lock-wait-mins", "60");
            mins = Long.parseLong(minsStr);
        }
        catch (Exception e) {
            mins = 60L;
        }
        this.m_initializeCallbackLockAcquisitionTimeoutMins = mins;
    }

    public InvokerLocator getInvokerLocator() {
        return this.m_invokerLocator;
    }

    @Override
    public void setRemoteEndpoint(String endpoint) throws Exception {
        InvokerLocator locator = new InvokerLocator(endpoint);
        LOG.info("JBossRemotingRemoteCommunicator.changing-endpoint", new Object[]{this.m_invokerLocator, locator});
        this.m_invokerLocator = locator;
        this.disconnect();
    }

    public String getSubsystem() {
        return this.m_subsystem;
    }

    @Override
    public FailureCallback getFailureCallback() {
        return this.m_failureCallback;
    }

    @Override
    public void setFailureCallback(FailureCallback callback) {
        this.m_failureCallback = callback;
    }

    @Override
    public InitializeCallback getInitializeCallback() {
        return this.m_initializeCallback;
    }

    @Override
    public void setInitializeCallback(InitializeCallback callback) {
        this.m_initializeCallback = callback;
        this.m_needToCallInitializeCallback = callback != null;
    }

    @Override
    public String getRemoteEndpoint() {
        return this.m_invokerLocator != null ? this.m_invokerLocator.getLocatorURI() : "<null>";
    }

    public Map<String, String> getClientConfiguration() {
        return new HashMap<String, String>(this.m_clientConfiguration);
    }

    @Override
    public void connect() throws Exception {
    }

    @Override
    public void disconnect() {
        this.cacheClient(null);
    }

    @Override
    public boolean isConnected() {
        Client client = this.m_client.get();
        return client != null && client.isConnected();
    }

    @Override
    public CommandResponse sendWithoutCallbacks(Command command) throws Throwable {
        boolean retry;
        CommandResponse ret_response = null;
        do {
            retry = false;
            ret_response = this.rawSend(command);
            Throwable exception = ret_response.getException();
            if (!(exception instanceof NotPermittedException)) continue;
            long pause = ((NotPermittedException)exception).getSleepBeforeRetry();
            LOG.debug("CommandService.remote-pojo-execute-not-permitted", new Object[]{command, pause});
            retry = true;
            Thread.sleep(pause);
        } while (retry);
        return ret_response;
    }

    @Override
    public CommandResponse sendWithoutInitializeCallback(Command command) throws Throwable {
        CommandResponse ret_response = null;
        boolean retry = false;
        do {
            try {
                ret_response = this.sendWithoutCallbacks(command);
                retry = this.invokeFailureCallbackIfNeeded(command, ret_response, null);
            }
            catch (Throwable t) {
                retry = this.invokeFailureCallbackIfNeeded(command, ret_response, t);
                if (retry) continue;
                throw t;
            }
        } while (retry);
        return ret_response;
    }

    @Override
    public CommandResponse send(Command command) throws Throwable {
        CommandResponse initializeErrorResponse = this.invokeInitializeCallbackIfNeeded(command);
        if (initializeErrorResponse != null) {
            return initializeErrorResponse;
        }
        return this.sendWithoutInitializeCallback(command);
    }

    private CommandResponse rawSend(Command command) throws Throwable {
        Object ret_response;
        try {
            try {
                OutgoingCommandTrace.start(command);
                ret_response = this.invoke(command);
                OutgoingCommandTrace.finish(command, ret_response);
            }
            catch (ServerInvoker.InvalidStateException serverDown) {
                ret_response = this.invoke(command);
                OutgoingCommandTrace.finish(command, ret_response);
            }
        }
        catch (Throwable t) {
            OutgoingCommandTrace.finish(command, t);
            throw t;
        }
        if (ret_response instanceof Exception) {
            throw (Exception)ret_response;
        }
        try {
            return (CommandResponse)ret_response;
        }
        catch (Exception e) {
            LOG.error("JBossRemotingRemoteCommunicator.comm-cce", new Object[]{ret_response});
            return new GenericCommandResponse(command, false, ret_response, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private CommandResponse invokeInitializeCallbackIfNeeded(Command command) {
        boolean locked;
        InitializeCallback callback = this.getInitializeCallback();
        if (callback == null) return null;
        ReentrantReadWriteLock.WriteLock writeLock = this.m_needToCallInitializeCallbackLock.writeLock();
        try {
            locked = writeLock.tryLock(this.m_initializeCallbackLockAcquisitionTimeoutMins * 60L, TimeUnit.SECONDS);
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            locked = false;
        }
        if (locked) {
            try {
                if (!this.m_needToCallInitializeCallback) return null;
                try {
                    this.m_needToCallInitializeCallback = !callback.sendingInitialCommand(this, command);
                    LOG.debug("JBossRemotingRemoteCommunicator.init-callback-done", new Object[]{this.m_needToCallInitializeCallback});
                    return null;
                }
                catch (Throwable t) {
                    this.m_needToCallInitializeCallback = true;
                    LOG.error(t, "JBossRemotingRemoteCommunicator.init-callback-failed", new Object[]{ThrowableUtil.getAllMessages((Throwable)t)});
                    GenericCommandResponse genericCommandResponse = new GenericCommandResponse(command, false, null, t);
                    writeLock.unlock();
                    return genericCommandResponse;
                }
            }
            finally {
                writeLock.unlock();
            }
        } else {
            Throwable t = new Throwable("Initialize callback lock could not be acquired");
            LOG.error("JBossRemotingRemoteCommunicator.init-callback-failed", new Object[]{t.getMessage()});
            return new GenericCommandResponse(command, false, null, t);
        }
    }

    private boolean invokeFailureCallbackIfNeeded(Command command, CommandResponse response, Throwable throwable) {
        FailureCallback callback = this.getFailureCallback();
        boolean retry = false;
        if (callback != null && (throwable != null || response != null && response.getException() != null)) {
            try {
                retry = callback.failureDetected(this, command, response, throwable);
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        return retry;
    }

    public String toString() {
        return "remoting endpoint [" + (this.m_invokerLocator != null ? this.m_invokerLocator.getLocatorURI() : "?") + ']';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object invoke(Command command) throws Throwable {
        InvokerLocator locator = this.m_invokerLocator;
        if (locator == null) {
            throw new IllegalStateException("m_invokerLocator is null");
        }
        Client client = this.m_client.get();
        if (client != null && client.getInvoker() == null) {
            client.disconnect();
        }
        if (client == null || !client.isConnected()) {
            client = new Client(locator, this.getSubsystem(), this.m_clientConfiguration);
            client.connect();
            try {
                Object object = client.invoke((Object)command);
                return object;
            }
            finally {
                this.cacheClient(client);
            }
        }
        return client.invoke((Object)command);
    }

    private void cacheClient(Client client) {
        Client old = this.m_client.getAndSet(client);
        if (old != null) {
            old.disconnect();
            this.m_needToCallInitializeCallback = this.getInitializeCallback() != null;
        }
    }
}

