/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.gui.table.model;

import javax.faces.model.DataModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetbrains.annotations.NotNull;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.core.gui.table.bean.AbstractPagedDataUIBean;

public abstract class PagedListDataModel<T>
extends DataModel {
    private final Log log = LogFactory.getLog(PagedListDataModel.class);
    private int currentRowIndex = -1;
    private PageList<T> pageList;
    private AbstractPagedDataUIBean pagedDataBean;

    public PagedListDataModel(AbstractPagedDataUIBean pagedDataBean) {
        this.pagedDataBean = pagedDataBean;
    }

    public void setWrappedData(Object o) {
        throw new UnsupportedOperationException("setWrappedData");
    }

    public int getRowIndex() {
        return this.currentRowIndex;
    }

    public void setRowIndex(int index) {
        this.currentRowIndex = index;
    }

    public int getRowCount() {
        return this.getCurrentPage().getTotalSize();
    }

    private PageList<T> getCurrentPage() {
        if (this.pageList == null) {
            this.pageList = this.getDataPage();
        } else {
            PageControl lastUsedPageControl;
            PageControl currentPageControl = this.pagedDataBean.getPageControl();
            if (!currentPageControl.equals((Object)(lastUsedPageControl = this.pageList.getPageControl()))) {
                this.pageList = this.getDataPage();
            }
        }
        return this.pageList;
    }

    public Object getRowData() {
        this.getCurrentPage();
        if (!this.isRowAvailable()) {
            this.pagedDataBean.resetPageControl();
            this.getCurrentPage();
            this.currentRowIndex = 0;
        }
        int pageIndex = this.currentRowIndex - this.getPageControl().getStartRow();
        return this.pageList.get(pageIndex);
    }

    public Object getWrappedData() {
        return this.pageList;
    }

    public boolean isRowAvailable() {
        this.getCurrentPage();
        return this.pageList != null && this.currentRowIndex >= 0 && this.currentRowIndex < this.pageList.getTotalSize();
    }

    private PageList<T> getDataPage() {
        long start = System.currentTimeMillis();
        PageControl pageControl = this.pagedDataBean.getPageControl();
        PageList<T> results = this.fetchPageGuarded(pageControl);
        if (this.log.isDebugEnabled()) {
            long time = System.currentTimeMillis() - start;
            this.log.debug((Object)("Fetch time was [" + time + "]ms for " + pageControl));
            if (time > 2000L) {
                this.log.debug((Object)("Slow loading page " + pageControl));
            }
        }
        return results;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private PageList<T> fetchPageGuarded(PageControl pageControl) {
        PageList<T> results = null;
        boolean tryQueryAgain = false;
        try {
            if (pageControl.getPageSize() == -1 && pageControl.getPageNumber() != 0) {
                if (this.log.isTraceEnabled()) {
                    // empty if block
                }
                pageControl.setPageNumber(0);
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Fetching page using: " + pageControl));
            }
            results = this.fetchPage(pageControl);
            if (this.log.isTraceEnabled()) {
                // empty if block
            }
            if (results.getTotalSize() != 0 && results.getTotalSize() <= pageControl.getStartRow() || results.isEmpty() && pageControl.getPageNumber() != 0) {
                if (!this.log.isTraceEnabled() || results.getTotalSize() == 0 || results.getTotalSize() <= pageControl.getStartRow()) {
                    // empty if block
                }
                pageControl.reset();
                if (this.log.isTraceEnabled()) {
                    // empty if block
                }
                tryQueryAgain = true;
            }
        }
        catch (Throwable t) {
            pageControl.reset();
            if (this.log.isTraceEnabled()) {
                // empty if block
            }
            tryQueryAgain = true;
        }
        if (tryQueryAgain) {
            if (this.log.isTraceEnabled()) {
                // empty if block
            }
            try {
                results = this.fetchPage(pageControl);
                if (!this.log.isTraceEnabled()) {
                    // empty if block
                }
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        if (results != null) return results;
        return new PageList<T>();
    }

    @NotNull
    public PageControl getPageControl() {
        return this.pagedDataBean.getPageControl();
    }

    public void setPageControl(PageControl pageControl) {
        this.pagedDataBean.setPageControl(pageControl);
    }

    public abstract PageList<T> fetchPage(PageControl var1);

    public void reset() {
        this.pageList = null;
    }
}

