/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.modules.plugins.jbossas7;

import java.io.File;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.core.pluginapi.util.ResponseTimeLogFinder;
import org.rhq.core.util.StringUtil;
import org.rhq.modules.plugins.jbossas7.ASConnection;
import org.rhq.modules.plugins.jbossas7.BaseComponent;
import org.rhq.modules.plugins.jbossas7.BaseServerComponent;
import org.rhq.modules.plugins.jbossas7.HostControllerComponent;
import org.rhq.modules.plugins.jbossas7.StandaloneASComponent;
import org.rhq.modules.plugins.jbossas7.SubsystemDiscovery;
import org.rhq.modules.plugins.jbossas7.json.Address;
import org.rhq.modules.plugins.jbossas7.json.ReadAttribute;
import org.rhq.modules.plugins.jbossas7.json.Result;

public class WebRuntimeDiscoveryComponent
extends SubsystemDiscovery {
    private static final Log LOG = LogFactory.getLog(WebRuntimeDiscoveryComponent.class);
    private static final String CONTEXT_ROOT_ATTRIBUTE = "context-root";
    private static final String PATH_ATTRIBUTE = "path";
    private static final String PATH_DELIM = ",";
    private static final String SERVER_PREFIX = "server=";

    @Override
    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext<BaseComponent<?>> context) throws Exception {
        Set<DiscoveredResourceDetails> discoveredResources = super.discoverResources(context);
        if (discoveredResources.isEmpty()) {
            return discoveredResources;
        }
        if (discoveredResources.size() != 1) {
            throw new IllegalStateException("Discovered multiple instances of a singleton resource type");
        }
        BaseComponent parentResourceComponent = (BaseComponent)context.getParentResourceComponent();
        BaseServerComponent serverComponent = parentResourceComponent.getServerComponent();
        DiscoveredResourceDetails resourceDetails = discoveredResources.iterator().next();
        Configuration pluginConfig = resourceDetails.getPluginConfiguration();
        String nodePath = pluginConfig.getSimpleValue(PATH_ATTRIBUTE);
        String contextRoot = this.getContextRootAttribute(new Address(nodePath), parentResourceComponent.getASConnection());
        this.discoverResponseTimeLogFile(serverComponent, pluginConfig, nodePath, contextRoot);
        return discoveredResources;
    }

    private void discoverResponseTimeLogFile(BaseServerComponent serverComponent, Configuration pluginConfig, String nodePath, String contextRoot) {
        if (serverComponent.isManuallyAddedServer()) {
            return;
        }
        String rtFilePath = null;
        if (serverComponent instanceof StandaloneASComponent) {
            File serverLogDir = serverComponent.getServerPluginConfiguration().getLogDir();
            if (serverLogDir != null) {
                File rtDirectory = new File(serverLogDir, "rt");
                rtFilePath = ResponseTimeLogFinder.findResponseTimeLogFileInDirectory((String)contextRoot, (File)rtDirectory);
            }
        } else if (serverComponent instanceof HostControllerComponent) {
            File hostControllerBaseDir = serverComponent.getServerPluginConfiguration().getBaseDir();
            String managedServerName = this.getManagedServerNameFromPathAttribute(nodePath);
            if (hostControllerBaseDir != null) {
                File rtDirectory = new File(hostControllerBaseDir, "servers" + File.separator + managedServerName + File.separator + "log" + File.separator + "rt");
                rtFilePath = ResponseTimeLogFinder.findResponseTimeLogFileInDirectory((String)contextRoot, (File)rtDirectory);
            }
        } else if (LOG.isWarnEnabled()) {
            LOG.warn((Object)("Unknown BaseServerComponent class: " + serverComponent.getClass().getName()));
        }
        if (rtFilePath == null) {
            rtFilePath = ResponseTimeLogFinder.findResponseTimeLogFileInDirectory((String)contextRoot, (File)ResponseTimeLogFinder.FALLBACK_RESPONSE_TIME_LOG_FILE_DIRECTORY);
        }
        if (rtFilePath != null) {
            pluginConfig.setSimpleValue("responseTimeLogFile", rtFilePath);
        }
    }

    private String getContextRootAttribute(Address address, ASConnection asConnection) {
        ReadAttribute readAttribute = new ReadAttribute(address, CONTEXT_ROOT_ATTRIBUTE);
        Result readAttributeResult = asConnection.execute(readAttribute);
        if (!readAttributeResult.isSuccess()) {
            throw new RuntimeException("Could not read [context-root] attribute of node [" + address.getPath() + "]: " + readAttributeResult.getFailureDescription());
        }
        return (String)readAttributeResult.getResult();
    }

    private String getManagedServerNameFromPathAttribute(String nodePath) {
        StringTokenizer tokenizer = new StringTokenizer(nodePath, PATH_DELIM);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (!token.startsWith(SERVER_PREFIX)) continue;
            String managedServerName = token.substring(SERVER_PREFIX.length());
            if (StringUtil.isBlank((String)managedServerName)) {
                throw new RuntimeException("Blank managed server name in path [" + nodePath + "]");
            }
            return managedServerName;
        }
        throw new RuntimeException("Could not determine managed server name from path [" + nodePath + "]");
    }
}

