/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.modules.plugins.jbossas7;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.ConfigurationUpdateStatus;
import org.rhq.core.domain.configuration.ConfigurationUtility;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyList;
import org.rhq.core.domain.configuration.PropertyMap;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionSimple;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.core.domain.measurement.MeasurementDataTrait;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.domain.resource.CreateResourceStatus;
import org.rhq.core.pluginapi.configuration.ConfigurationFacet;
import org.rhq.core.pluginapi.configuration.ConfigurationUpdateReport;
import org.rhq.core.pluginapi.inventory.CreateChildResourceFacet;
import org.rhq.core.pluginapi.inventory.CreateResourceReport;
import org.rhq.core.pluginapi.operation.OperationFacet;
import org.rhq.core.pluginapi.operation.OperationResult;
import org.rhq.modules.plugins.jbossas7.ASConnection;
import org.rhq.modules.plugins.jbossas7.BaseComponent;
import org.rhq.modules.plugins.jbossas7.ConfigurationWriteDelegate;
import org.rhq.modules.plugins.jbossas7.JBossProductType;
import org.rhq.modules.plugins.jbossas7.json.Address;
import org.rhq.modules.plugins.jbossas7.json.ComplexResult;
import org.rhq.modules.plugins.jbossas7.json.CompositeOperation;
import org.rhq.modules.plugins.jbossas7.json.Operation;
import org.rhq.modules.plugins.jbossas7.json.ReadAttribute;
import org.rhq.modules.plugins.jbossas7.json.ReadResource;
import org.rhq.modules.plugins.jbossas7.json.Result;

public class DatasourceComponent
extends BaseComponent<BaseComponent<?>>
implements OperationFacet,
ConfigurationFacet,
CreateChildResourceFacet {
    private static final Log LOG = LogFactory.getLog(DatasourceComponent.class);
    private static final String NOTSET = "-notset-";
    private static final String ENABLED_ATTRIBUTE = "enabled";
    private static final String ENABLE_OPERATION = "enable";
    private static final String DISABLE_OPERATION = "disable";
    private static final String ALLOW_MULTIPLE_USERS_ATTRIBUTE = "allow-multiple-users";
    private static final String TRACK_STATEMENTS_ATTRIBUTE = "track-statements";

    @Override
    public OperationResult invokeOperation(String operationName, Configuration parameters) throws Exception {
        Operation op;
        OperationResult operationResult = new OperationResult();
        ASConnection connection = this.getASConnection();
        if (operationName.equals("addDriver")) {
            String drivername = parameters.getSimpleValue("driver-name", NOTSET);
            Address theAddress = new Address(this.address);
            theAddress.add("jdbc-driver", drivername);
            op = new Operation("add", theAddress);
            op.addAdditionalProperty("driver-name", drivername);
            op.addAdditionalProperty("deployment-name", parameters.getSimpleValue("deployment-name", NOTSET));
            op.addAdditionalProperty("driver-class-name", parameters.getSimpleValue("driver-class-name", NOTSET));
        } else {
            op = new Operation(operationName, this.address);
        }
        Result res = connection.execute(op);
        if (res.isSuccess()) {
            operationResult.setSimpleResult("Success");
        } else {
            operationResult.setErrorMessage(res.getFailureDescription());
        }
        return operationResult;
    }

    @Override
    public CreateResourceReport createResource(CreateResourceReport createResourceReport) {
        PropertySimple enabledProperty;
        String keyName;
        String connPropPluginConfigPropertyName;
        String connPropAttributeNameOnAS7;
        List validationErrors = ConfigurationUtility.validateConfiguration((Configuration)createResourceReport.getResourceConfiguration(), (ConfigurationDefinition)createResourceReport.getResourceType().getResourceConfigurationDefinition());
        if (!validationErrors.isEmpty()) {
            createResourceReport.setErrorMessage(validationErrors.toString());
            createResourceReport.setStatus(CreateResourceStatus.FAILURE);
            return createResourceReport;
        }
        final CreateResourceReport resourceReport = super.createResource(createResourceReport);
        if (resourceReport.getStatus() != CreateResourceStatus.SUCCESS) {
            return resourceReport;
        }
        if (createResourceReport.getResourceType().getName().toLowerCase().contains("xa")) {
            connPropAttributeNameOnAS7 = "xa-datasource-properties";
            connPropPluginConfigPropertyName = "*2";
            keyName = "key";
        } else {
            connPropAttributeNameOnAS7 = "connection-properties";
            connPropPluginConfigPropertyName = "*1";
            keyName = "pname";
        }
        PropertyList listPropertyWrapper = createResourceReport.getResourceConfiguration().getList(connPropPluginConfigPropertyName);
        if (null != listPropertyWrapper) {
            Result res;
            CompositeOperation cop = new CompositeOperation();
            for (Property p : listPropertyWrapper.getList()) {
                PropertyMap map = (PropertyMap)p;
                String key = map.getSimpleValue(keyName, null);
                String value = map.getSimpleValue("value", null);
                if (key == null || value == null) continue;
                Address propertyAddress = new Address(resourceReport.getResourceKey());
                propertyAddress.add(connPropAttributeNameOnAS7, key);
                Operation op = new Operation("add", propertyAddress);
                op.addAdditionalProperty("value", value);
                cop.addStep(op);
            }
            if (cop.numberOfSteps() > 0 && !(res = this.getASConnection().execute(cop)).isSuccess()) {
                resourceReport.setErrorMessage("Datasource was added, but setting " + connPropAttributeNameOnAS7 + " failed: " + res.getFailureDescription());
                resourceReport.setStatus(CreateResourceStatus.INVALID_ARTIFACT);
                return resourceReport;
            }
        }
        Boolean enabledPropertyValue = (enabledProperty = createResourceReport.getResourceConfiguration().getSimple(ENABLED_ATTRIBUTE)) == null ? Boolean.TRUE : enabledProperty.getBooleanValue();
        EnabledAttributeHelper.on(new Address(resourceReport.getResourceKey())).with(this.getASConnection()).setAttributeValue(enabledPropertyValue, new EnabledAttributeHelperCallbacks(){

            @Override
            public void onReadAttributeFailure(Result opResult) {
                resourceReport.setStatus(CreateResourceStatus.INVALID_ARTIFACT);
                resourceReport.setErrorMessage("Datasource was added, but could not read its configuration after creation: " + opResult.getFailureDescription());
            }

            @Override
            public void onEnableOperationFailure(Result opResult) {
                resourceReport.setStatus(CreateResourceStatus.INVALID_ARTIFACT);
                resourceReport.setErrorMessage("Datasource was added but not enabled: " + opResult.getFailureDescription());
            }

            @Override
            public void onDisableOperationFailure(Result opResult) {
                resourceReport.setStatus(CreateResourceStatus.INVALID_ARTIFACT);
                resourceReport.setErrorMessage("Datasource was added but not disabled: " + opResult.getFailureDescription());
            }
        });
        return resourceReport;
    }

    @Override
    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> requests) throws Exception {
        HashSet<MeasurementScheduleRequest> metrics = new HashSet<MeasurementScheduleRequest>(requests.size());
        for (MeasurementScheduleRequest request : requests) {
            if (request.getName().equals("connectionAvailable")) {
                report.addData(this.getConnectionAvailable(request));
                continue;
            }
            if (request.getName().equals("max-pool-size")) {
                this.getRCAsMetric(report, request);
                continue;
            }
            if (request.getName().equals("min-pool-size")) {
                this.getRCAsMetric(report, request);
                continue;
            }
            metrics.add(request);
        }
        ReadResource op = new ReadResource(this.address);
        op.includeRuntime(true);
        op.recursive(true);
        ComplexResult res = this.getASConnection().executeComplex(op);
        if (!res.isSuccess()) {
            return;
        }
        HashMap results = new HashMap();
        Map statistics = (Map)res.getResult().get("statistics");
        if (statistics != null) {
            results.putAll((Map)statistics.get("pool"));
            results.putAll((Map)statistics.get("jdbc"));
            for (MeasurementScheduleRequest metric : metrics) {
                String name = metric.getName();
                Object o = results.get(name);
                if (o == null) continue;
                String tmp = (String)o;
                Double val = Double.valueOf(tmp);
                MeasurementDataNumeric data = new MeasurementDataNumeric(metric, val);
                report.addData(data);
            }
        }
    }

    @Override
    public void updateResourceConfiguration(final ConfigurationUpdateReport configurationUpdateReport) {
        Configuration config = configurationUpdateReport.getConfiguration();
        ConfigurationDefinition configDef = this.context.getResourceType().getResourceConfigurationDefinition();
        this.replacePropertiesWithDefaultValueWhenNull(config, configDef);
        ConfigurationDefinition configDefCopy = DatasourceComponent.copyConfigurationDefinition(configDef);
        configDefCopy.getPropertyDefinitions().remove(ENABLED_ATTRIBUTE);
        if (this.getServerComponent().getServerPluginConfiguration().getProductType() == JBossProductType.AS) {
            this.doUpdateAS7ResourceConfiguration(configurationUpdateReport, configDefCopy);
            return;
        }
        Boolean enabledAttributeConfigValue = config.getSimple(ENABLED_ATTRIBUTE).getBooleanValue();
        if (enabledAttributeConfigValue == null) {
            enabledAttributeConfigValue = Boolean.TRUE;
        }
        ReadAttribute readEnabledAttributeOperation = new ReadAttribute(this.address, ENABLED_ATTRIBUTE);
        Result readEnabledAttributeResult = this.getASConnection().execute(readEnabledAttributeOperation);
        if (!readEnabledAttributeResult.isSuccess()) {
            configurationUpdateReport.setStatus(ConfigurationUpdateStatus.FAILURE);
            configurationUpdateReport.setErrorMessage("Could not determine if the Datasource is currently enabled: " + readEnabledAttributeResult.getFailureDescription());
            return;
        }
        Boolean datasourceEnabled = (Boolean)readEnabledAttributeResult.getResult();
        if (datasourceEnabled == Boolean.TRUE) {
            if (enabledAttributeConfigValue == Boolean.TRUE) {
                configurationUpdateReport.setStatus(ConfigurationUpdateStatus.FAILURE);
                configurationUpdateReport.setErrorMessage("You must disable the Datasource before editing its configuration");
                return;
            }
            EnabledAttributeHelper.on(this.getAddress()).with(this.getASConnection()).setAttributeValue(Boolean.FALSE, new EnabledAttributeHelperCallbacks(){

                @Override
                public void onReadAttributeFailure(Result opResult) {
                    configurationUpdateReport.setStatus(ConfigurationUpdateStatus.FAILURE);
                    configurationUpdateReport.setErrorMessage("Could not determine if the Datasource is currently enabled: " + opResult.getFailureDescription());
                }

                @Override
                public void onEnableOperationFailure(Result opResult) {
                }

                @Override
                public void onDisableOperationFailure(Result opResult) {
                    configurationUpdateReport.setStatus(ConfigurationUpdateStatus.FAILURE);
                    configurationUpdateReport.setErrorMessage("Could not disable the Datasource: " + opResult.getFailureDescription());
                }
            });
            if (configurationUpdateReport.getStatus() == ConfigurationUpdateStatus.FAILURE) {
                return;
            }
        }
        ConfigurationWriteDelegate delegate = new ConfigurationWriteDelegate(configDefCopy, this.getASConnection(), this.address);
        delegate.updateResourceConfiguration(configurationUpdateReport);
        if (configurationUpdateReport.getStatus() != ConfigurationUpdateStatus.SUCCESS) {
            return;
        }
        EnabledAttributeHelper.on(this.address).with(this.getASConnection()).setAttributeValue(enabledAttributeConfigValue, new EnabledAttributeHelperCallbacks(){

            @Override
            public void onReadAttributeFailure(Result opResult) {
                configurationUpdateReport.setStatus(ConfigurationUpdateStatus.FAILURE);
                configurationUpdateReport.setErrorMessage("Datasource was updated, but could not read its configuration after the update: " + opResult.getFailureDescription());
            }

            @Override
            public void onEnableOperationFailure(Result opResult) {
                configurationUpdateReport.setStatus(ConfigurationUpdateStatus.FAILURE);
                configurationUpdateReport.setErrorMessage("Datasource was updated but not enabled: " + opResult.getFailureDescription());
            }

            @Override
            public void onDisableOperationFailure(Result opResult) {
                configurationUpdateReport.setStatus(ConfigurationUpdateStatus.FAILURE);
                configurationUpdateReport.setErrorMessage("Datasource was updated but not disabled: " + opResult.getFailureDescription());
            }
        });
    }

    private void replacePropertiesWithDefaultValueWhenNull(Configuration config, ConfigurationDefinition configDef) {
        this.replaceWithDefaultIfNull("max-pool-size", config, configDef);
        this.replaceWithDefaultIfNull("min-pool-size", config, configDef);
        this.replaceWithDefaultIfNull("pool-prefill", config, configDef);
        this.replaceWithDefaultIfNull("pool-use-strict-min", config, configDef);
        this.replaceWithDefaultIfNull("blocking-timeout-wait-millis", config, configDef);
        this.replaceWithDefaultIfNull("idle-timeout-minutes", config, configDef);
        this.replaceWithDefaultIfNull("background-validation-millis", config, configDef);
        this.replaceWithDefaultIfNull("background-validation-minutes", config, configDef);
        this.replaceWithDefaultIfNull("background-validation", config, configDef);
    }

    private void replaceWithDefaultIfNull(String propertyName, Configuration config, ConfigurationDefinition configDef) {
        String propertyValue;
        PropertyDefinitionSimple propertyDefinition = configDef.getPropertyDefinitionSimple(propertyName);
        if (propertyDefinition != null && ((propertyValue = config.getSimpleValue(propertyName)) == null || propertyValue.isEmpty())) {
            config.put((Property)new PropertySimple(propertyName, (Object)propertyDefinition.getDefaultValue()));
        }
    }

    private void doUpdateAS7ResourceConfiguration(ConfigurationUpdateReport configurationUpdateReport, ConfigurationDefinition configDefCopy) {
        configDefCopy.getPropertyDefinitions().remove(ALLOW_MULTIPLE_USERS_ATTRIBUTE);
        configDefCopy.getPropertyDefinitions().remove(TRACK_STATEMENTS_ATTRIBUTE);
        ConfigurationWriteDelegate delegate = new ConfigurationWriteDelegate(configDefCopy, this.getASConnection(), this.address);
        delegate.updateResourceConfiguration(configurationUpdateReport);
    }

    private void getRCAsMetric(MeasurementReport report, MeasurementScheduleRequest request) {
        ReadAttribute op = new ReadAttribute(this.getAddress(), request.getName());
        Result res = this.getASConnection().execute(op);
        if (res.isSuccess()) {
            Integer tmp = (Integer)res.getResult();
            if (tmp == null) {
                tmp = request.getName().equals("max-pool-size") ? Integer.valueOf(20) : (request.getName().equals("min-pool-size") ? Integer.valueOf(0) : Integer.valueOf(-1));
            }
            Double val = (double)tmp;
            MeasurementDataNumeric data = new MeasurementDataNumeric(request, val);
            report.addData(data);
        } else {
            LOG.warn((Object)("Could not read [" + request.getName() + "] on " + this.getAddress() + ": " + res.getFailureDescription()));
        }
    }

    private MeasurementDataTrait getConnectionAvailable(MeasurementScheduleRequest request) {
        Operation op = new Operation("test-connection-in-pool", this.getAddress());
        Result res = this.getASConnection().execute(op);
        MeasurementDataTrait trait = new MeasurementDataTrait(request, String.valueOf(res.isSuccess()));
        return trait;
    }

    static ConfigurationDefinition copyConfigurationDefinition(ConfigurationDefinition configurationDefinition) {
        ConfigurationDefinition configDefCopy = new ConfigurationDefinition(configurationDefinition.getName(), configurationDefinition.getDescription());
        configDefCopy.setConfigurationFormat(configurationDefinition.getConfigurationFormat());
        configDefCopy.setPropertyDefinitions(new HashMap(configurationDefinition.getPropertyDefinitions()));
        return configDefCopy;
    }

    static interface EnabledAttributeHelperCallbacks {
        public void onReadAttributeFailure(Result var1);

        public void onEnableOperationFailure(Result var1);

        public void onDisableOperationFailure(Result var1);
    }

    private static class EnabledAttributeHelper {
        Address datasourceAddress;
        ASConnection asConnection;

        EnabledAttributeHelper(Address datasourceAddress) {
            this.datasourceAddress = datasourceAddress;
        }

        static EnabledAttributeHelper on(Address datasourceAddress) {
            return new EnabledAttributeHelper(datasourceAddress);
        }

        EnabledAttributeHelper with(ASConnection asConnection) {
            this.asConnection = asConnection;
            return this;
        }

        void setAttributeValue(Boolean attributeValue, EnabledAttributeHelperCallbacks callbacks) {
            if (this.asConnection == null) {
                throw new IllegalStateException("No ASConnection instance provided");
            }
            if (attributeValue == null) {
                throw new IllegalArgumentException("Argument attributeValue is null");
            }
            ReadAttribute readAttribute = new ReadAttribute(this.datasourceAddress, DatasourceComponent.ENABLED_ATTRIBUTE);
            Result readAttributeResult = this.asConnection.execute(readAttribute);
            if (!readAttributeResult.isSuccess()) {
                if (callbacks != null) {
                    callbacks.onReadAttributeFailure(readAttributeResult);
                }
                return;
            }
            Boolean currentAttributeValue = (Boolean)readAttributeResult.getResult();
            if (currentAttributeValue != attributeValue) {
                if (attributeValue == Boolean.TRUE) {
                    Operation operation = new Operation(DatasourceComponent.ENABLE_OPERATION, this.datasourceAddress);
                    Result res = this.asConnection.execute(operation);
                    if (!res.isSuccess()) {
                        if (callbacks != null) {
                            callbacks.onEnableOperationFailure(res);
                        }
                        return;
                    }
                } else {
                    Operation operation = new Operation(DatasourceComponent.DISABLE_OPERATION, this.datasourceAddress);
                    Result res = this.asConnection.execute(operation);
                    if (!res.isSuccess()) {
                        if (callbacks != null) {
                            callbacks.onDisableOperationFailure(res);
                        }
                        return;
                    }
                }
            }
        }
    }
}

