/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.modules.plugins.jbossas7;

import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NoHttpResponseException;
import org.apache.http.StatusLine;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.params.HttpClientParams;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.DefaultConnectionReuseStrategy;
import org.apache.http.impl.client.DefaultConnectionKeepAliveStrategy;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.modules.plugins.jbossas7.ASConnectionParams;
import org.rhq.modules.plugins.jbossas7.ASConnectionParamsBuilder;
import org.rhq.modules.plugins.jbossas7.PluginStats;
import org.rhq.modules.plugins.jbossas7.SchemeRegistryBuilder;
import org.rhq.modules.plugins.jbossas7.helper.ServerPluginConfiguration;
import org.rhq.modules.plugins.jbossas7.json.ComplexResult;
import org.rhq.modules.plugins.jbossas7.json.Operation;
import org.rhq.modules.plugins.jbossas7.json.Result;

public class ASConnection {
    private static final Log LOG = LogFactory.getLog(ASConnection.class);
    public static final String HTTP_SCHEME = "http";
    public static final String HTTPS_SCHEME = "https";
    public static final String MANAGEMENT_URI = "/management";
    public static boolean verbose = Boolean.getBoolean("as7plugin.verbose");
    @Deprecated
    public static final String MANAGEMENT = "/management";
    static final String FAILURE_NO_RESPONSE = "The server closed the connection before sending the response";
    private static final String FAILURE_SHUTDOWN = "The HTTP connection has already been shutdown";
    private static final int MAX_POOLED_CONNECTIONS = 10;
    private static final String ACCEPT_HTTP_HEADER = "Accept";
    private static final String JSON_NODE_FAILURE_DESCRIPTION = "failure-description";
    private static final ScheduledExecutorService cleanerExecutor = Executors.newSingleThreadScheduledExecutor(new ThreadFactory());
    private final ASConnectionParams asConnectionParams;
    private final URI managementUri;
    private final DefaultHttpClient httpClient;
    private final ObjectMapper mapper;
    private volatile long keepAliveTimeout;
    private volatile boolean shutdown;

    @Deprecated
    public ASConnection(String host, int port, String user, String password) {
        this(host, port, user, password, null);
    }

    @Deprecated
    public ASConnection(String host, int port, String user, String password, Long managementConnectionTimeout) {
        this(new ASConnectionParamsBuilder().setHost(host).setPort(port).setUsername(user).setPassword(password).setKeepAliveTimeout(managementConnectionTimeout).createASConnectionParams());
    }

    public ASConnection(ASConnectionParams params) {
        this.asConnectionParams = params;
        if (this.asConnectionParams.getHost() == null) {
            throw new IllegalArgumentException("Management host cannot be null.");
        }
        if (this.asConnectionParams.getPort() <= 0 || this.asConnectionParams.getPort() > 65535) {
            throw new IllegalArgumentException("Invalid port: " + this.asConnectionParams.getPort());
        }
        UsernamePasswordCredentials credentials = null;
        if (this.asConnectionParams.getUsername() != null && this.asConnectionParams.getPassword() != null) {
            credentials = new UsernamePasswordCredentials(this.asConnectionParams.getUsername(), this.asConnectionParams.getPassword());
        }
        this.keepAliveTimeout = this.asConnectionParams.getKeepAliveTimeout();
        this.managementUri = this.buildManagementUri();
        SchemeRegistry schemeRegistry = new SchemeRegistryBuilder(this.asConnectionParams).buildSchemeRegistry();
        PoolingClientConnectionManager httpConnectionManager = new PoolingClientConnectionManager(schemeRegistry);
        httpConnectionManager.setDefaultMaxPerRoute(10);
        httpConnectionManager.setMaxTotal(10);
        this.httpClient = new DefaultHttpClient((ClientConnectionManager)httpConnectionManager);
        HttpParams httpParams = this.httpClient.getParams();
        HttpConnectionParams.setStaleCheckingEnabled((HttpParams)httpParams, (boolean)false);
        this.httpClient.setReuseStrategy((ConnectionReuseStrategy)new CustomConnectionReuseStrategy(this));
        if (this.keepAliveTimeout > 0L) {
            this.httpClient.setKeepAliveStrategy((ConnectionKeepAliveStrategy)new CustomConnectionKeepAliveStrategy(this));
            cleanerExecutor.schedule(new ConnectionManagerCleaner(this), this.keepAliveTimeout / 2L, TimeUnit.MILLISECONDS);
        }
        HttpClientParams.setRedirecting((HttpParams)httpParams, (boolean)false);
        if (credentials != null) {
            this.httpClient.getCredentialsProvider().setCredentials(new AuthScope(this.asConnectionParams.getHost(), this.asConnectionParams.getPort()), (Credentials)credentials);
        }
        this.mapper = new ObjectMapper();
        this.mapper.configure(DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.shutdown = false;
    }

    private URI buildManagementUri() {
        try {
            return new URIBuilder().setScheme(this.asConnectionParams.isSecure() ? HTTPS_SCHEME : HTTP_SCHEME).setHost(this.asConnectionParams.getHost()).setPort(this.asConnectionParams.getPort()).setPath("/management").build();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Could not build management URI: " + e.getMessage(), e);
        }
    }

    @Deprecated
    public static ASConnection newInstanceForServerPluginConfiguration(ServerPluginConfiguration serverPluginConfig) {
        return new ASConnection(ASConnectionParams.createFrom(serverPluginConfig));
    }

    public void shutdown() {
        this.httpClient.getConnectionManager().shutdown();
        this.shutdown = true;
    }

    public JsonNode executeRaw(Operation operation) {
        return this.executeRaw(operation, 20);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JsonNode executeRaw(Operation operation, int timeoutSec) {
        if (this.shutdown) {
            return this.resultAsJsonNode("failure", FAILURE_SHUTDOWN, null, Boolean.FALSE);
        }
        long requestStartTime = System.nanoTime();
        if (this.addressPathContainsSpaces(operation) == Boolean.TRUE) {
            String failureDescription = "- Path '" + operation.getAddress().getPath() + "' is invalid as it contains spaces -";
            if (verbose) {
                LOG.error((Object)failureDescription);
            }
            return this.resultAsJsonNode("failure", failureDescription, null, Boolean.FALSE);
        }
        HttpPost httpPost = null;
        try {
            JsonNode operationResult;
            String responseBody;
            HttpResponse httpResponse;
            StatusLine statusLine;
            String jsonToSend = this.mapper.writeValueAsString((Object)operation);
            if (verbose) {
                LOG.info((Object)("JSON to send: " + jsonToSend));
            }
            if (this.isAuthorizationFailureResponse(statusLine = (httpResponse = this.httpClient.execute((HttpUriRequest)(httpPost = this.initHttpPost(timeoutSec, jsonToSend)))).getStatusLine())) {
                throw new InvalidPluginConfigurationException(this.createErrorMessageForAuthorizationFailureResponse(statusLine));
            }
            HttpEntity httpResponseEntity = httpResponse.getEntity();
            String string = responseBody = httpResponseEntity == null ? "" : EntityUtils.toString((HttpEntity)httpResponseEntity);
            if (verbose && statusLine.getStatusCode() >= 400) {
                this.logHttpError(operation, statusLine, responseBody);
            }
            if (!responseBody.isEmpty()) {
                operationResult = this.deserializeResponseBody(operation, statusLine, responseBody);
                if (verbose) {
                    this.logFormatted(operationResult);
                }
            } else {
                operationResult = this.resultAsJsonNode("failure", "- empty response body with HTTP status code " + ASConnection.statusAsString(statusLine) + " -", null, Boolean.FALSE);
            }
            JsonNode jsonNode = operationResult;
            return jsonNode;
        }
        catch (NoHttpResponseException e) {
            JsonNode jsonNode = this.resultAsJsonNode("failure", FAILURE_NO_RESPONSE, e, Boolean.FALSE);
            return jsonNode;
        }
        catch (IOException e) {
            JsonNode jsonNode = this.resultAsJsonNode("failure", e.getMessage(), e, Boolean.FALSE);
            return jsonNode;
        }
        finally {
            if (httpPost != null) {
                httpPost.abort();
            }
            this.updateStatistics(requestStartTime, System.nanoTime());
        }
    }

    private JsonNode resultAsJsonNode(String outcome, String failureDescription, Throwable rhqThrowable, Boolean rolledBack) {
        Result result = new Result();
        result.setOutcome(outcome);
        if (failureDescription != null) {
            result.setFailureDescription(failureDescription);
        }
        if (rhqThrowable != null) {
            result.setRhqThrowable(rhqThrowable);
        }
        if (rolledBack == Boolean.TRUE) {
            result.setRolledBack(true);
        }
        return this.mapper.valueToTree((Object)result);
    }

    private Boolean addressPathContainsSpaces(Operation operation) {
        Boolean addressPathContainsSpaces = Boolean.FALSE;
        if (operation != null && operation.getAddress() != null && operation.getAddress().getPath() != null && this.containsSpaces(operation.getAddress().getPath())) {
            addressPathContainsSpaces = Boolean.TRUE;
        }
        return addressPathContainsSpaces;
    }

    private HttpPost initHttpPost(int timeoutSec, String jsonToSend) {
        HttpPost httpPost = new HttpPost(this.managementUri);
        httpPost.addHeader(ACCEPT_HTTP_HEADER, ContentType.APPLICATION_JSON.getMimeType());
        HttpParams httpParams = this.httpClient.getParams();
        int timeoutMillis = timeoutSec * 1000;
        HttpConnectionParams.setConnectionTimeout((HttpParams)httpParams, (int)timeoutMillis);
        HttpConnectionParams.setSoTimeout((HttpParams)httpParams, (int)timeoutMillis);
        httpPost.setEntity((HttpEntity)new StringEntity(jsonToSend, ContentType.APPLICATION_JSON));
        return httpPost;
    }

    private boolean isAuthorizationFailureResponse(StatusLine statusLine) {
        return statusLine.getStatusCode() == 401 || statusLine.getStatusCode() == 307;
    }

    private String createErrorMessageForAuthorizationFailureResponse(StatusLine statusLine) {
        if (statusLine.getStatusCode() == 401) {
            return "Credentials for plugin to connect to AS7 management interface are invalid - update Connection Settings with valid credentials.";
        }
        return "Authorization to AS7 failed - did you install a management user?";
    }

    private void logHttpError(Operation operation, StatusLine statusLine, String responseBody) {
        if (responseBody.contains("JBAS014807") || responseBody.contains("JBAS010850") || responseBody.contains("JBAS014792") || responseBody.contains("JBAS014793") || responseBody.contains("JBAS014739")) {
            LOG.info((Object)("Requested management resource not found: " + operation.getAddress().getPath()));
        } else {
            LOG.warn((Object)(operation + " failed with " + ASConnection.statusAsString(statusLine) + " - response body was [" + responseBody + "]."));
        }
    }

    private void logFormatted(JsonNode operationResult) {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(SerializationConfig.Feature.INDENT_OUTPUT, true);
        try {
            LOG.info((Object)objectMapper.writeValueAsString((Object)operationResult));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private JsonNode deserializeResponseBody(Operation operation, StatusLine statusLine, String responseBody) {
        JsonNode operationResult;
        try {
            operationResult = this.mapper.readTree(responseBody);
        }
        catch (IOException ioe) {
            String failureDescription = "Failed to deserialize response to " + operation + " to JsonNode - response status was " + ASConnection.statusAsString(statusLine) + ", and body was [" + responseBody + "]: " + ioe;
            LOG.error((Object)failureDescription);
            operationResult = this.resultAsJsonNode("failure", failureDescription, ioe, responseBody.contains("rolled-back=true"));
        }
        return operationResult;
    }

    private void updateStatistics(long requestStartTime, long requestEndTime) {
        PluginStats stats = PluginStats.getInstance();
        stats.incrementRequestCount();
        stats.addRequestTime(TimeUnit.NANOSECONDS.toMillis(requestEndTime - requestStartTime));
    }

    private boolean containsSpaces(String path) {
        return path.indexOf(" ") != -1;
    }

    public Result execute(Operation op) {
        return this.execute(op, false, 10);
    }

    public Result execute(Operation op, int timeoutSec) {
        return this.execute(op, false, timeoutSec);
    }

    public ComplexResult executeComplex(Operation op) {
        return (ComplexResult)this.execute(op, true, 10);
    }

    public ComplexResult executeComplex(Operation op, int timeoutSec) {
        return (ComplexResult)this.execute(op, true, timeoutSec);
    }

    public Result execute(Operation op, boolean isComplex) {
        return this.execute(op, isComplex, 10);
    }

    public Result execute(Operation op, boolean isComplex, int timeoutSec) {
        JsonNode node = this.executeRaw(op, timeoutSec);
        if (node == null) {
            LOG.warn((Object)("Operation [" + op + "] returned null."));
            Result failure = new Result();
            failure.setFailureDescription("Operation [" + op + "] returned null.");
            return failure;
        }
        try {
            String as7ResultSerialization = node.toString();
            if (as7ResultSerialization.indexOf(JSON_NODE_FAILURE_DESCRIPTION) > -1 && verbose) {
                LOG.warn((Object)("------ Detected 'failure-description' when communicating with server." + as7ResultSerialization));
            }
            Result res = isComplex ? (Result)this.mapper.readValue(node, ComplexResult.class) : (Result)this.mapper.readValue(node, Result.class);
            return res;
        }
        catch (IOException e) {
            LOG.error((Object)e.getMessage());
            if (verbose) {
                LOG.error((Object)("----------- Operation execution unparsable. Request :[" + op + "] Response:<" + node + ">"));
            }
            Result failure = new Result();
            failure.setFailureDescription("Operation <" + op + "> returned unparsable JSON, <" + node + ">.");
            return failure;
        }
    }

    @Deprecated
    public String getHost() {
        return this.asConnectionParams.getHost();
    }

    @Deprecated
    public int getPort() {
        return this.asConnectionParams.getPort();
    }

    @Deprecated
    public String getUser() {
        return this.asConnectionParams.getUsername();
    }

    @Deprecated
    public String getPassword() {
        return this.asConnectionParams.getPassword();
    }

    public ASConnectionParams getAsConnectionParams() {
        return this.asConnectionParams;
    }

    static String statusAsString(StatusLine statusLine) {
        String reasonPhrase = statusLine.getReasonPhrase();
        StringBuilder builder = new StringBuilder(3 + (reasonPhrase == null ? 0 : 1 + reasonPhrase.length()));
        builder.append(statusLine.getStatusCode());
        if (statusLine != null) {
            builder.append(" ").append(statusLine.getReasonPhrase());
        }
        return builder.toString();
    }

    private static class CustomConnectionKeepAliveStrategy
    extends DefaultConnectionKeepAliveStrategy {
        private final ASConnection asConnection;

        private CustomConnectionKeepAliveStrategy(ASConnection asConnection) {
            this.asConnection = asConnection;
        }

        public long getKeepAliveDuration(HttpResponse response, HttpContext context) {
            long duration = super.getKeepAliveDuration(response, context);
            if (duration < 0L || duration > this.asConnection.keepAliveTimeout) {
                duration = this.asConnection.keepAliveTimeout;
            }
            if (duration < this.asConnection.keepAliveTimeout) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn((Object)(this.asConnection.asConnectionParams.getHost() + ":" + this.asConnection.asConnectionParams.getPort() + " declares a keep alive timeout value of [" + duration + "] ms. Will now use this value instead of the value from configuration [" + this.asConnection.keepAliveTimeout + "] ms."));
                }
                this.asConnection.keepAliveTimeout = duration;
            }
            return duration;
        }
    }

    private static class CustomConnectionReuseStrategy
    extends DefaultConnectionReuseStrategy {
        private final ASConnection asConnection;

        private CustomConnectionReuseStrategy(ASConnection asConnection) {
            this.asConnection = asConnection;
        }

        public boolean keepAlive(HttpResponse response, HttpContext context) {
            return this.asConnection.keepAliveTimeout > 0L && super.keepAlive(response, context);
        }
    }

    private static class ThreadFactory
    implements java.util.concurrent.ThreadFactory {
        private ThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = Executors.defaultThreadFactory().newThread(runnable);
            thread.setName("ASConnection Cleaner");
            thread.setDaemon(true);
            return thread;
        }
    }

    private static final class ConnectionManagerCleaner
    implements Runnable {
        private WeakReference<ASConnection> asConnectionWeakReference;

        private ConnectionManagerCleaner(ASConnection asConnection) {
            this.asConnectionWeakReference = new WeakReference<ASConnection>(asConnection);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ASConnection asConnection = (ASConnection)this.asConnectionWeakReference.get();
            if (asConnection != null && !asConnection.shutdown) {
                try {
                    asConnection.httpClient.getConnectionManager().closeExpiredConnections();
                    asConnection.httpClient.getConnectionManager().closeIdleConnections(asConnection.keepAliveTimeout, TimeUnit.MILLISECONDS);
                }
                finally {
                    cleanerExecutor.schedule(new ConnectionManagerCleaner(asConnection), asConnection.keepAliveTimeout, TimeUnit.MILLISECONDS);
                }
            }
        }
    }
}

