/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.vault;

import java.util.logging.Logger;
import org.jboss.security.vault.SecurityActions;
import org.jboss.security.vault.SecurityVault;
import org.jboss.security.vault.SecurityVaultException;

public class SecurityVaultFactory {
    private static Logger log = Logger.getLogger(SecurityVaultFactory.class.getName());
    private static String defaultVault = "org.picketbox.plugins.vault.PicketBoxSecurityVault";
    private static SecurityVault vault = null;

    public static SecurityVault get() throws SecurityVaultException {
        log.info("Getting Security Vault with implementation of " + defaultVault);
        return SecurityVaultFactory.get(defaultVault);
    }

    public static SecurityVault get(String fqn) throws SecurityVaultException {
        if (fqn == null) {
            return SecurityVaultFactory.get();
        }
        if (vault == null) {
            Class<?> vaultClass = SecurityActions.loadClass(SecurityVaultFactory.class, fqn);
            if (vaultClass == null) {
                throw new SecurityVaultException("PB00015: Null Value:Unable to create vault:class is null");
            }
            try {
                vault = (SecurityVault)vaultClass.newInstance();
            }
            catch (Exception e) {
                throw new SecurityVaultException("PB00019: Processing Failed:Unable to create vault:not instantiated", e);
            }
        }
        return vault;
    }
}

