/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.database;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.measurement.MeasurementFacet;
import org.rhq.core.util.jdbc.JDBCUtil;
import org.rhq.plugins.database.CustomTableRowDiscoveryComponent;
import org.rhq.plugins.database.DatabaseComponent;
import org.rhq.plugins.database.DatabaseQueryUtility;

public class CustomTableComponent
implements DatabaseComponent<DatabaseComponent<?>>,
MeasurementFacet {
    private ResourceContext<DatabaseComponent<?>> context;
    private static final Log log = LogFactory.getLog(CustomTableComponent.class);

    public void start(ResourceContext<DatabaseComponent<?>> resourceContext) throws InvalidPluginConfigurationException, Exception {
        this.context = resourceContext;
    }

    public void stop() {
    }

    public String getTable() {
        return this.context.getPluginConfiguration().getSimpleValue("table", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AvailabilityType getAvailability() {
        Statement statement = null;
        try {
            statement = this.getConnection().createStatement();
            statement.executeQuery("SELECT COUNT(*) FROM " + this.getTable());
            AvailabilityType availabilityType = AvailabilityType.UP;
            return availabilityType;
        }
        catch (SQLException e) {
            AvailabilityType availabilityType = AvailabilityType.DOWN;
            return availabilityType;
        }
        finally {
            JDBCUtil.safeClose((Statement)statement);
        }
    }

    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> metrics) throws Exception {
        Configuration conf = this.context.getPluginConfiguration();
        String query = conf.getSimpleValue("metricQuery", null);
        if (query == null) {
            if (log.isTraceEnabled()) {
                ResourceType type = this.context.getResourceType();
                String resourceKey = this.context.getResourceKey();
                log.trace((Object)("Resource " + resourceKey + " (" + type.getName() + ", plugin " + type.getPlugin() + "): The plugin configuration doesn't specify 'metricQuery' property. Ignoring the measurement request."));
            }
            return;
        }
        query = CustomTableRowDiscoveryComponent.formatMessage(query, conf.getSimpleValue("key", null));
        Map<String, Double> values = DatabaseQueryUtility.getNumericQueryValueMap(this, query, new Object[0]);
        for (MeasurementScheduleRequest request : metrics) {
            String columnName = request.getName();
            Double value = values.get(columnName);
            if (value == null && (value = values.get(columnName.toLowerCase())) == null) {
                value = values.get(columnName.toUpperCase());
            }
            if (value != null) {
                report.addData(new MeasurementDataNumeric(request, value));
                continue;
            }
            log.debug((Object)("Missing column in query results - metric not collected: " + columnName));
        }
    }

    @Override
    public Connection getConnection() {
        return ((DatabaseComponent)this.context.getParentResourceComponent()).getConnection();
    }

    @Override
    public void removeConnection() {
        ((DatabaseComponent)this.context.getParentResourceComponent()).removeConnection();
    }
}

