/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.database;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.logging.Logger;
import javax.sql.DataSource;

class DriverDataSource
implements DataSource {
    private final Properties properties;
    private final Driver driver;
    private final String url;
    private PrintWriter out = new PrintWriter(System.out);

    DriverDataSource(Driver driver, String url, Properties properties) {
        this.driver = driver;
        this.url = url;
        if (properties == null) {
            properties = new Properties();
        }
        this.properties = properties;
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.out;
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.out = out;
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.driver.connect(this.url, this.properties);
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        Properties p = new Properties(this.properties);
        if (username != null) {
            p.put("user", username);
        }
        if (password != null) {
            p.put("password", password);
        }
        return this.driver.connect(this.url, p);
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }
}

