/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.database;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.plugins.database.DatabasePluginUtil;

public class CustomTableRowDiscoveryComponent
implements ResourceDiscoveryComponent<ResourceComponent<?>> {
    private static final Log LOG = LogFactory.getLog(CustomTableRowDiscoveryComponent.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext<ResourceComponent<?>> discoveryContext) throws InvalidPluginConfigurationException, Exception {
        HashSet<DiscoveredResourceDetails> hashSet;
        ResourceComponent parentComponent = discoveryContext.getParentResourceComponent();
        Configuration config = discoveryContext.getDefaultPluginConfiguration();
        String table = config.getSimpleValue("table", null);
        String keyColumn = config.getSimpleValue("keyColumn", null);
        ResourceType resourceType = discoveryContext.getResourceType();
        String resourceName = config.getSimpleValue("name", resourceType.getName());
        String resourceDescription = config.getSimpleValue("description", "");
        if (!DatabasePluginUtil.canProvideConnection(parentComponent)) {
            if (!LOG.isDebugEnabled()) return Collections.emptySet();
            LOG.debug((Object)("Parent component does not provide JDBC connections, cannot discover" + resourceName));
            return Collections.emptySet();
        }
        if (resourceName == null) {
            if (!LOG.isDebugEnabled()) return Collections.emptySet();
            LOG.debug((Object)("'name' property not set, cannot discover" + resourceName));
            return Collections.emptySet();
        }
        Statement statement = null;
        Connection connection = null;
        ResultSet resultSet = null;
        try {
            connection = DatabasePluginUtil.getConnectionFromComponent(parentComponent);
            if (connection == null) {
                throw new InvalidPluginConfigurationException("cannot obtain connection from parent");
            }
            statement = connection.createStatement();
            resultSet = statement.executeQuery("SELECT * FROM " + table);
            HashSet<DiscoveredResourceDetails> found = new HashSet<DiscoveredResourceDetails>();
            while (resultSet.next()) {
                config = discoveryContext.getDefaultPluginConfiguration();
                String key = resultSet.getString(keyColumn);
                config.put((Property)new PropertySimple("key", (Object)key));
                DiscoveredResourceDetails details = new DiscoveredResourceDetails(discoveryContext.getResourceType(), key, CustomTableRowDiscoveryComponent.formatMessage(resourceName, key), null, CustomTableRowDiscoveryComponent.formatMessage(resourceDescription, key), config, null);
                found.add(details);
            }
            hashSet = found;
        }
        catch (SQLException e) {
            try {
                LOG.debug((Object)("table " + table + " column " + keyColumn), (Throwable)e);
            }
            catch (Throwable throwable) {
                DatabasePluginUtil.safeClose(null, statement, resultSet);
                if (!DatabasePluginUtil.hasConnectionPoolingSupport(parentComponent)) throw throwable;
                DatabasePluginUtil.safeClose(connection, statement, resultSet);
                throw throwable;
            }
            DatabasePluginUtil.safeClose(null, statement, resultSet);
            if (!DatabasePluginUtil.hasConnectionPoolingSupport(parentComponent)) return Collections.emptySet();
            DatabasePluginUtil.safeClose(connection, statement, resultSet);
            return Collections.emptySet();
        }
        DatabasePluginUtil.safeClose(null, statement, resultSet);
        if (!DatabasePluginUtil.hasConnectionPoolingSupport(parentComponent)) return hashSet;
        DatabasePluginUtil.safeClose(connection, statement, resultSet);
        return hashSet;
    }

    public static String formatMessage(String message, String key) {
        if (key == null) {
            return message;
        }
        key = Matcher.quoteReplacement(key);
        message = message.replaceAll("\\{key\\}", key);
        return message;
    }
}

