/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.database;

import com.jolbox.bonecp.BoneCP;
import com.jolbox.bonecp.BoneCPConfig;
import com.jolbox.bonecp.hooks.AbstractConnectionHook;
import com.jolbox.bonecp.hooks.AcquireFailConfig;
import com.jolbox.bonecp.hooks.ConnectionHook;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.plugins.database.DriverDataSource;
import org.rhq.plugins.database.PooledConnectionProvider;

public abstract class BasePooledConnectionProvider
implements PooledConnectionProvider {
    private static final Log LOG = LogFactory.getLog(BasePooledConnectionProvider.class);
    public static final String DRIVER_CLASS = "driverClass";
    public static final String URL = "url";
    public static final String USERNAME = "username";
    public static final String PASSWORD = "password";
    public static final String TRACK = "track";
    public static final String TIMEOUT = "connectionTimeout";
    protected final Configuration pluginConfig;
    private final BoneCP connectionPool;

    protected BasePooledConnectionProvider(Configuration pluginConfig) throws Exception {
        Class<Driver> driverClass;
        this.pluginConfig = pluginConfig;
        BoneCPConfig bconfig = new BoneCPConfig(this.getConnectionProperties());
        try {
            driverClass = this.getDriverClass();
        }
        catch (ClassNotFoundException e) {
            LOG.warn((Object)("Could not load driver class from: " + Thread.currentThread().getContextClassLoader()));
            throw e;
        }
        if (driverClass != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Using driver class " + driverClass));
            }
            Driver driver = driverClass.newInstance();
            DriverDataSource datasourceBean = new DriverDataSource(driver, this.getJdbcUrl(), this.getConnectionProperties());
            bconfig.setDatasourceBean((DataSource)datasourceBean);
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Using driver manager for " + this.getJdbcUrl()));
            }
            bconfig.setJdbcUrl(this.getJdbcUrl());
        }
        bconfig.setAcquireIncrement(1);
        bconfig.setAcquireRetryAttempts(0);
        bconfig.setAcquireRetryDelayInMs(0L);
        bconfig.setPartitionCount(2);
        bconfig.setMaxConnectionsPerPartition(5);
        bconfig.setPassword(this.getPassword());
        bconfig.setUsername(this.getUsername());
        bconfig.setConnectionTimeoutInMs(this.getConnectionTimeout());
        if (this.isTrack()) {
            bconfig.setCloseConnectionWatch(true);
            bconfig.setCloseConnectionWatchTimeout(10L, TimeUnit.MINUTES);
        }
        bconfig.setLazyInit(false);
        bconfig.setDisableJMX(true);
        AbstractConnectionHook hook = new AbstractConnectionHook(){

            public boolean onAcquireFail(Throwable t, AcquireFailConfig acquireConfig) {
                LOG.error((Object)"Failed to obtain connection", t);
                return false;
            }
        };
        bconfig.setConnectionHook((ConnectionHook)hook);
        this.connectionPool = new BoneCP(bconfig);
    }

    private boolean isTrack() {
        return Boolean.valueOf(this.pluginConfig.getSimpleValue(TRACK, null));
    }

    @Override
    public Connection getPooledConnection() throws SQLException {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("get connection for " + this.getJdbcUrl() + " free " + this.connectionPool.getTotalFree() + "/" + this.connectionPool.getTotalCreatedConnections()));
        }
        return this.connectionPool.getConnection();
    }

    protected Properties getConnectionProperties() {
        return new Properties();
    }

    protected Class<Driver> getDriverClass() throws ClassNotFoundException {
        String cname = this.getDriverClassName();
        if (cname != null) {
            return Thread.currentThread().getContextClassLoader().loadClass(cname);
        }
        return null;
    }

    protected String getDriverClassName() throws ClassNotFoundException {
        return this.pluginConfig.getSimpleValue(DRIVER_CLASS, null);
    }

    protected String getJdbcUrl() {
        return this.pluginConfig.getSimpleValue(URL);
    }

    protected String getUsername() {
        return this.pluginConfig.getSimpleValue(USERNAME);
    }

    protected String getPassword() {
        return this.pluginConfig.getSimpleValue(PASSWORD);
    }

    protected long getConnectionTimeout() {
        String s = this.pluginConfig.getSimpleValue(TIMEOUT);
        if (s == null) {
            return 10000L;
        }
        return Long.parseLong(s);
    }

    public void close() {
        this.connectionPool.shutdown();
    }
}

