/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.cassandra.ccm.maven;

import java.io.File;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.rhq.cassandra.CassandraClusterManager;
import org.rhq.cassandra.DeploymentOptions;
import org.rhq.cassandra.DeploymentOptionsFactory;
import org.rhq.cassandra.schema.SchemaManager;

@Mojo(name="deploy")
public class DeployMojo
extends AbstractMojo {
    @Parameter(property="clusterDir", defaultValue="${project.build.directory}/cassandra")
    private File clusterDir;
    @Parameter(property="numNodes", defaultValue="2")
    private Integer numNodes;

    public void execute() throws MojoExecutionException, MojoFailureException {
        DeploymentOptionsFactory factory = new DeploymentOptionsFactory();
        DeploymentOptions deploymentOptions = factory.newDeploymentOptions();
        deploymentOptions.setClusterDir(this.clusterDir.getAbsolutePath());
        deploymentOptions.setNumNodes(this.numNodes.intValue());
        CassandraClusterManager ccm = new CassandraClusterManager(deploymentOptions);
        long start = System.currentTimeMillis();
        this.getLog().info((CharSequence)("Creating " + this.numNodes + " cluster in " + this.clusterDir));
        List nodes = ccm.createCluster();
        this.getLog().info((CharSequence)"Starting cluster nodes");
        ccm.startCluster();
        this.getLog().info((CharSequence)"Installing RHQ schema");
        SchemaManager schemaManager = new SchemaManager(deploymentOptions.getUsername(), deploymentOptions.getPassword(), nodes);
        try {
            schemaManager.install();
            schemaManager.updateTopology();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Schema installation failed.", e);
        }
        long end = System.currentTimeMillis();
        this.getLog().info((CharSequence)("Finished cluster deployment in " + (end - start) + " ms"));
    }
}

