/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.test.arquillian.impl.util;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Collection;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.exporter.ExplodedExporter;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.resolver.api.DependencyResolvers;
import org.jboss.shrinkwrap.resolver.api.maven.MavenDependencyResolver;
import org.rhq.core.util.file.FileUtil;

public class SigarInstaller {
    private static final Log LOG = LogFactory.getLog(SigarInstaller.class);
    private static final String USER_HOME = System.getProperty("user.home");
    private static final String TMP_DIR = System.getProperty("java.io.tmpdir");
    private File rootDir;
    private Archive<?> sigarDistArtifact;

    public SigarInstaller(File rootDir) {
        this.rootDir = rootDir;
        this.init();
    }

    private void init() {
        MavenDependencyResolver mavenDependencyResolver = (MavenDependencyResolver)DependencyResolvers.use(MavenDependencyResolver.class);
        Collection sigars = ((MavenDependencyResolver)mavenDependencyResolver.loadMetadataFromPom("pom.xml").goOffline().artifact("org.hyperic:sigar-dist:zip:1.6.5.132-3")).resolveAs(JavaArchive.class);
        if (sigars.size() > 1) {
            LOG.warn((Object)("More than 1 org.hyperic:sigar-dist artifact found in the current POM: " + sigars));
        }
        this.sigarDistArtifact = (Archive)sigars.iterator().next();
    }

    public boolean isSigarAvailable() {
        return this.sigarDistArtifact != null;
    }

    public void installSigarNativeLibraries() {
        LOG.debug((Object)("Installing SIGAR native libraries to [" + this.rootDir + "]..."));
        File tempDir = new File(TMP_DIR, UUID.randomUUID().toString());
        if (!tempDir.exists()) {
            tempDir.mkdirs();
        }
        String explodedDirName = "sigar-dist";
        LOG.debug((Object)("Unzipping " + this.sigarDistArtifact + " to " + tempDir + "..."));
        ((ExplodedExporter)this.sigarDistArtifact.as(ExplodedExporter.class)).exportExploded(tempDir, explodedDirName);
        File sigarLibDir = null;
        try {
            sigarLibDir = SigarInstaller.findSigarLibDir(new File(tempDir, explodedDirName));
            FileUtil.purge((File)this.rootDir, (boolean)true);
            FileUtil.copyDirectory((File)sigarLibDir, (File)this.rootDir);
            System.setProperty("org.hyperic.sigar.path", this.rootDir.getPath());
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to copy SIGAR shared libraries from [" + sigarLibDir + "] to [" + this.rootDir + "].", e);
        }
        finally {
            FileUtil.purge((File)tempDir, (boolean)true);
        }
    }

    private static File findSigarLibDir(File explodedSigarDistZip) {
        File[] foundRootDirs = explodedSigarDistZip.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith("hyperic-sigar");
            }
        });
        if (foundRootDirs.length == 0) {
            throw new IllegalStateException("Could not find a directory called \"hyperic-sigar-<VERSION>\" under the Sigar distribution ZIP file.");
        }
        if (foundRootDirs.length > 1) {
            throw new IllegalStateException("There seems to be more than 1 directory starting with \"hyperic-sigar\" under the Sigar distribution ZIP file.");
        }
        File rootDir = foundRootDirs[0];
        File bin = new File(rootDir, "sigar-bin");
        if (!bin.exists()) {
            throw new IllegalStateException("\"sigar-bin\" not found in the Sigar distribution ZIP file.");
        }
        File lib = new File(bin, "lib");
        if (!lib.exists()) {
            throw new IllegalStateException("\"sigar-bin/lib\" not found in the Sigar distribution ZIP file.");
        }
        return lib;
    }
}

