/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.test.arquillian.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import javax.xml.namespace.QName;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.arquillian.container.spi.Container;
import org.jboss.arquillian.container.spi.client.container.DeployableContainer;
import org.jboss.arquillian.container.spi.client.container.DeploymentException;
import org.jboss.arquillian.container.spi.client.container.LifecycleException;
import org.jboss.arquillian.container.spi.client.protocol.ProtocolDescription;
import org.jboss.arquillian.container.spi.client.protocol.metadata.ProtocolMetaData;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.ArchivePaths;
import org.jboss.shrinkwrap.api.Filter;
import org.jboss.shrinkwrap.api.Node;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.descriptor.api.Descriptor;
import org.jboss.shrinkwrap.impl.base.path.BasicPath;
import org.rhq.core.pc.PluginContainer;
import org.rhq.core.pc.PluginContainerConfiguration;
import org.rhq.core.pc.ServerServices;
import org.rhq.core.pc.plugin.FileSystemPluginFinder;
import org.rhq.core.pc.plugin.PluginEnvironment;
import org.rhq.core.pc.plugin.PluginFinder;
import org.rhq.core.system.SystemInfoFactory;
import org.rhq.core.util.file.FileUtil;
import org.rhq.test.arquillian.impl.RhqAgentPluginContainerConfiguration;
import org.rhq.test.arquillian.impl.util.SigarInstaller;
import org.rhq.test.shrinkwrap.FilteredView;
import org.rhq.test.shrinkwrap.RhqAgentPluginArchive;

public class RhqAgentPluginContainer
implements DeployableContainer<RhqAgentPluginContainerConfiguration> {
    private static final AtomicInteger CONTAINER_COUNT;
    private static final File DEPLOYMENT_ROOT;
    private static final File ROOT;
    private static final String PLUGINS_DIR_NAME = "plugins";
    private static final String DATA_DIR_NAME = "data";
    private static final String TMP_DIR_NAME = "tmp";
    private static final ArchivePath PLUGIN_DESCRIPTOR_PATH;
    private static final Map<String, Boolean> NATIVE_SYSTEM_INFO_ENABLEMENT_PER_PC;
    private static final Log LOG;
    private RhqAgentPluginContainerConfiguration configuration;
    private File deploymentDirectory;
    @Inject
    private Instance<Container> container;

    public Class<RhqAgentPluginContainerConfiguration> getConfigurationClass() {
        return RhqAgentPluginContainerConfiguration.class;
    }

    public static void init() {
    }

    public static PluginContainer switchPluginContainer(String deploymentName) throws Exception {
        PluginContainer oldInstance = PluginContainer.getInstance();
        Method setInstance = PluginContainer.class.getMethod("setContainerInstance", String.class);
        setInstance.invoke(null, deploymentName);
        PluginContainer newInstance = PluginContainer.getInstance();
        if (newInstance != oldInstance) {
            Boolean enableNativeInfo = NATIVE_SYSTEM_INFO_ENABLEMENT_PER_PC.get(deploymentName);
            if (enableNativeInfo == null || !enableNativeInfo.booleanValue()) {
                SystemInfoFactory.disableNativeSystemInfo();
            } else {
                SystemInfoFactory.enableNativeSystemInfo();
            }
            LOG.info((Object)("Switched PluginContainer to '" + deploymentName + "'."));
        }
        return newInstance;
    }

    public static PluginContainer getPluginContainer(String deploymentName) throws Exception {
        Method getInstance = PluginContainer.class.getMethod("getContainerInstance", String.class);
        return (PluginContainer)getInstance.invoke(null, deploymentName);
    }

    public void setup(RhqAgentPluginContainerConfiguration configuration) {
        this.configuration = configuration;
        this.finalizeConfiguration(this.configuration);
    }

    public void start() throws LifecycleException {
        CONTAINER_COUNT.incrementAndGet();
        try {
            this.switchPcInstance();
        }
        catch (Exception e) {
            throw new LifecycleException("Failed to switch plugin container.", (Throwable)e);
        }
        LOG.info((Object)("Starting PluginContainer " + ((Container)this.container.get()).getName()));
        this.startPc();
    }

    public void stop() throws LifecycleException {
        try {
            this.switchPcInstance();
        }
        catch (Exception e) {
            throw new LifecycleException("Failed to switch plugin container.", (Throwable)e);
        }
        LOG.info((Object)("Stopping PluginContainer " + ((Container)this.container.get()).getName()));
        this.stopPc();
        if (CONTAINER_COUNT.decrementAndGet() == 0) {
            RhqAgentPluginContainer.purgePcDeployments();
        }
    }

    public ProtocolDescription getDefaultProtocol() {
        return new ProtocolDescription("Local");
    }

    public ProtocolMetaData deploy(Archive<?> archive) throws DeploymentException {
        LOG.info((Object)("Deploying " + archive + " to PluginContainer " + ((Container)this.container.get()).getName()));
        try {
            this.switchPcInstance();
        }
        catch (Exception e) {
            throw new DeploymentException("Failed to switch to PluginContainer [" + ((Container)this.container.get()).getName() + "].", (Throwable)e);
        }
        RhqAgentPluginArchive pluginArchive = (RhqAgentPluginArchive)archive.as(RhqAgentPluginArchive.class);
        Node descriptor = pluginArchive.get(ArchivePaths.create((String)"META-INF/rhq-plugin.xml"));
        if (descriptor == null) {
            throw new DeploymentException("Plugin archive [" + archive + "] doesn't specify an RHQ plugin descriptor.");
        }
        boolean wasStarted = this.stopPc();
        this.deployPlugin(pluginArchive);
        if (wasStarted) {
            this.startPc();
        }
        PluginContainer pc = PluginContainer.getInstance();
        String pluginName = RhqAgentPluginContainer.getPluginName(pluginArchive);
        PluginEnvironment plugin = pc.getPluginManager().getPlugin(pluginName);
        if (plugin == null) {
            throw new RuntimeException("Failed to deploy plugin '" + pluginName + "' (" + pluginArchive.getName() + ") - check the log above for an error (and big stack trace) from PluginManager.initialize().");
        }
        LOG.info((Object)("Done deploying plugin '" + pluginName + "' (" + archive + ") to PluginContainer " + ((Container)this.container.get()).getName() + "."));
        return new ProtocolMetaData();
    }

    public void undeploy(Archive<?> archive) throws DeploymentException {
        LOG.info((Object)("Undeploying " + archive + " from PluginContainer " + ((Container)this.container.get()).getName()));
        try {
            this.switchPcInstance();
        }
        catch (Exception e) {
            throw new DeploymentException("Failed to switch plugin container.", (Throwable)e);
        }
        RhqAgentPluginArchive plugin = (RhqAgentPluginArchive)archive.as(RhqAgentPluginArchive.class);
        boolean wasStarted = this.stopPc();
        File pluginDeploymentPath = this.getDeploymentPath((Archive<?>)plugin);
        if (pluginDeploymentPath.exists() && !pluginDeploymentPath.delete() && File.separatorChar == '/') {
            throw new DeploymentException("Could not delete the RHQ plugin jar " + plugin.getName());
        }
        if (wasStarted) {
            this.startPc();
        }
        LOG.info((Object)("Done undeploying " + archive + " from PluginContainer " + ((Container)this.container.get()).getName()));
    }

    public void deploy(Descriptor descriptor) throws DeploymentException {
        throw new UnsupportedOperationException();
    }

    public void undeploy(Descriptor descriptor) throws DeploymentException {
        throw new UnsupportedOperationException();
    }

    public RhqAgentPluginContainerConfiguration getConfiguration() {
        return this.configuration;
    }

    private File getDeploymentPath(Archive<?> plugin) {
        return new File(this.configuration.getPluginDirectory(), plugin.getName());
    }

    private void finalizeConfiguration(RhqAgentPluginContainerConfiguration config) {
        String arquillianContainerName = ((Container)this.container.get()).getName();
        String pluginContainerName = arquillianContainerName != null ? arquillianContainerName : UUID.randomUUID().toString();
        config.setContainerName(pluginContainerName);
        this.deploymentDirectory = new File(DEPLOYMENT_ROOT, pluginContainerName);
        File pluginsDir = new File(this.deploymentDirectory, PLUGINS_DIR_NAME);
        pluginsDir.mkdirs();
        File dataDir = new File(this.deploymentDirectory, DATA_DIR_NAME);
        dataDir.mkdirs();
        File tmpDir = new File(this.deploymentDirectory, TMP_DIR_NAME);
        tmpDir.mkdirs();
        config.setPluginDirectory(pluginsDir);
        config.setDataDirectory(dataDir);
        config.setTemporaryDirectory(tmpDir);
        NATIVE_SYSTEM_INFO_ENABLEMENT_PER_PC.put(arquillianContainerName, config.isNativeSystemInfoEnabled());
        if (config.getServerServicesImplementationClassName() != null) {
            try {
                Class<?> serverServicesClass = Class.forName(config.getServerServicesImplementationClassName());
                ServerServices serverServices = (ServerServices)serverServicesClass.newInstance();
                config.setServerServices(serverServices);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("The serverServicesImplementationClassName property is invalid", e);
            }
        }
    }

    private static void purgePcDeployments() {
        FileUtil.purge((File)ROOT, (boolean)true);
    }

    private boolean startPc() {
        LOG.debug((Object)"Starting PluginContainer on demand...");
        PluginContainer pc = PluginContainer.getInstance();
        if (pc.isStarted()) {
            return false;
        }
        this.configuration.setPluginFinder((PluginFinder)new FileSystemPluginFinder(this.configuration.getPluginDirectory()));
        if (LOG.isDebugEnabled() && this.configuration.getAdditionalPackagesForRootPluginClassLoaderToExclude() != null) {
            LOG.debug((Object)("Using root plugin classloader regex [" + this.configuration.getRootPluginClassLoaderRegex() + "]..."));
        }
        pc.setConfiguration((PluginContainerConfiguration)this.configuration);
        pc.initialize();
        return true;
    }

    private boolean stopPc() {
        LOG.debug((Object)"Stopping PluginContainer on demand...");
        PluginContainer pc = PluginContainer.getInstance();
        if (pc.isStarted()) {
            boolean shutdownGracefully = pc.shutdown();
            if (shutdownGracefully) {
                LOG.debug((Object)"Stopped PluginContainer gracefully.");
            } else {
                LOG.debug((Object)"Stopped PluginContainer.");
            }
            return true;
        }
        return false;
    }

    private void deployPlugin(RhqAgentPluginArchive plugin) {
        if (plugin.getRequiredPlugins() != null) {
            for (Archive a : plugin.getRequiredPlugins()) {
                RhqAgentPluginArchive p = (RhqAgentPluginArchive)a.as(RhqAgentPluginArchive.class);
                this.deployPlugin(p);
            }
        }
        File pluginDeploymentPath = this.getDeploymentPath((Archive<?>)plugin);
        ((ZipExporter)((FilteredView)plugin.as(FilteredView.class)).filterContents((Filter)new ExcludeDirectory(plugin.getRequiredPluginsPath())).as(ZipExporter.class)).exportTo(pluginDeploymentPath, true);
    }

    private PluginContainer switchPcInstance() throws Exception {
        return RhqAgentPluginContainer.switchPluginContainer(((Container)this.container.get()).getName());
    }

    private static String getPluginName(Archive<?> archive) {
        InputStream is = archive.get(PLUGIN_DESCRIPTOR_PATH).getAsset().openStream();
        XMLEventReader rdr = null;
        try {
            rdr = XMLInputFactory.newInstance().createXMLEventReader(is);
            XMLEvent event = null;
            while (rdr.hasNext() && (event = rdr.nextEvent()).getEventType() != 1) {
            }
            StartElement startElement = event.asStartElement();
            String tagName = startElement.getName().getLocalPart();
            if (!"plugin".equals(tagName)) {
                throw new IllegalArgumentException("Illegal start tag found in the plugin descriptor. Expected 'plugin' but found '" + tagName + "' in the plugin '" + archive + "'.");
            }
            Attribute nameAttr = startElement.getAttributeByName(new QName("name"));
            if (nameAttr == null) {
                throw new IllegalArgumentException("Couldn't find the name attribute on the plugin tag in the plugin descriptor of plugin '" + archive + "'.");
            }
            String string = nameAttr.getValue();
            return string;
        }
        catch (XMLStreamException e) {
            throw new IllegalArgumentException("Failed to extract the plugin name out of the RHQ plugin archive [" + archive + "]", e);
        }
        catch (FactoryConfigurationError e) {
            throw new IllegalArgumentException("Failed to extract the plugin name out of the RHQ plugin archive [" + archive + "]", e);
        }
        finally {
            RhqAgentPluginContainer.closeReaderAndStream(rdr, is, archive);
        }
    }

    private static void closeReaderAndStream(XMLEventReader rdr, InputStream str, Archive<?> archive) {
        if (rdr != null) {
            try {
                rdr.close();
            }
            catch (XMLStreamException e) {
                LOG.error((Object)("Failed to close the XML reader of the plugin descriptor in archive [" + archive + "]"), (Throwable)e);
            }
        }
        try {
            str.close();
        }
        catch (IOException e) {
            LOG.error((Object)("Failed to close the input stream of the plugin descriptor in archive [" + archive + "]"), (Throwable)e);
        }
    }

    static {
        File sigar;
        File deployments2;
        File root2;
        CONTAINER_COUNT = new AtomicInteger(0);
        PLUGIN_DESCRIPTOR_PATH = new BasicPath("META-INF", "rhq-plugin.xml");
        NATIVE_SYSTEM_INFO_ENABLEMENT_PER_PC = new HashMap<String, Boolean>();
        try {
            root2 = FileUtil.createTempDirectory((String)"TEST_RHQ_PC_DEPLOYMENTS", null, null);
            deployments2 = new File(root2, "pcs");
            deployments2.mkdir();
            sigar = new File(root2, "sigar");
            sigar.mkdir();
        }
        catch (IOException e) {
            Object root2 = null;
            Object deployments2 = null;
            throw new IllegalStateException("Could not create the root directory for RHQ plugin container test deployments");
        }
        ROOT = root2;
        DEPLOYMENT_ROOT = deployments2;
        SigarInstaller installer = new SigarInstaller(sigar);
        if (installer.isSigarAvailable()) {
            installer.installSigarNativeLibraries();
        }
        LOG = LogFactory.getLog(RhqAgentPluginContainer.class);
    }

    private static class ExcludeDirectory
    implements Filter<ArchivePath> {
        private ArchivePath root;

        public ExcludeDirectory(ArchivePath root) {
            this.root = root;
        }

        public boolean include(ArchivePath object) {
            return !object.get().startsWith(this.root.get());
        }
    }
}

