/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.test.arquillian.impl.util;

import java.lang.annotation.Annotation;
import java.util.Iterator;
import java.util.List;
import org.jboss.arquillian.container.spi.Container;
import org.jboss.arquillian.container.spi.ContainerRegistry;
import org.jboss.arquillian.container.spi.client.deployment.Deployment;
import org.jboss.arquillian.container.spi.client.deployment.DeploymentScenario;
import org.jboss.arquillian.container.spi.client.deployment.DeploymentTargetDescription;
import org.jboss.arquillian.container.spi.client.deployment.TargetDescription;
import org.jboss.arquillian.container.spi.context.DeploymentContext;
import org.jboss.arquillian.container.test.api.OperateOnDeployment;
import org.jboss.arquillian.core.api.Event;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.core.spi.EventContext;
import org.jboss.arquillian.test.spi.annotation.TestScoped;
import org.jboss.arquillian.test.spi.event.suite.Before;
import org.rhq.core.pc.PluginContainer;
import org.rhq.test.arquillian.impl.RhqAgentPluginContainer;
import org.rhq.test.arquillian.spi.events.PluginContainerDiscovered;

public class EnrichmentHook {
    @Inject
    private Instance<DeploymentContext> deploymentContext;
    @Inject
    private Instance<DeploymentScenario> deploymentScenario;
    @Inject
    private Instance<ContainerRegistry> containerRegistry;
    @Inject
    @TestScoped
    private InstanceProducer<PluginContainer> pluginContainer;
    @Inject
    @TestScoped
    private InstanceProducer<RhqAgentPluginContainer> rhqAgentPluginContainer;
    @Inject
    private Event<PluginContainerDiscovered> pluginContainerDiscovered;

    public void hookUp(@Observes EventContext<Before> ctx) {
        Before event = (Before)ctx.getEvent();
        this.lookup(event.getTestMethod().getAnnotations());
        ctx.proceed();
        this.pluginContainerDiscovered.fire((Object)new PluginContainerDiscovered(event.getTestInstance(), event.getTestMethod()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lookup(Annotation ... qualifiers) {
        DeploymentScenario scenario = (DeploymentScenario)this.deploymentScenario.get();
        if (scenario == null) {
            return;
        }
        boolean contextActivated = false;
        OperateOnDeployment deploymentSpecifier = this.getOperateOnDeployment(qualifiers);
        Deployment specificDeployment = null;
        if (deploymentSpecifier != null) {
            specificDeployment = scenario.deployment(new DeploymentTargetDescription(deploymentSpecifier.value()));
            if (specificDeployment == null) {
                throw new IllegalArgumentException("@" + OperateOnDeployment.class.getSimpleName() + " specified an unknown deployment '" + deploymentSpecifier.value());
            }
            ((DeploymentContext)this.deploymentContext.get()).activate((Object)specificDeployment);
            contextActivated = true;
        }
        try {
            TargetDescription target = specificDeployment == null ? this.checkAndGetCommonTarget(scenario.deployments()) : specificDeployment.getDescription().getTarget();
            this.lookupAndSetPluginContainer(target);
        }
        finally {
            if (contextActivated) {
                ((DeploymentContext)this.deploymentContext.get()).deactivate();
            }
        }
    }

    private TargetDescription checkAndGetCommonTarget(List<Deployment> deployments) {
        if (deployments == null || deployments.isEmpty()) {
            throw new IllegalStateException("There seem to be no deployments in this deployment scenario. Don't know how to find out the target plugin container");
        }
        Iterator<Deployment> it = deployments.iterator();
        TargetDescription target = it.next().getDescription().getTarget();
        while (it.hasNext()) {
            if (target.equals((Object)it.next().getDescription().getTarget())) continue;
            throw new IllegalArgumentException("Deployments in this deployment scenario don't share a common target container. Cannot reliably set the PluginContainer to use by the test methods.");
        }
        return target;
    }

    private void lookupAndSetPluginContainer(TargetDescription target) {
        ContainerRegistry registry = (ContainerRegistry)this.containerRegistry.get();
        if (registry == null) {
            return;
        }
        Container container = null;
        if (target != null) {
            container = registry.getContainer(target);
        }
        if (container == null) {
            throw new IllegalArgumentException("Could not find a PluginContainer called '" + target.getName() + "'");
        }
        try {
            PluginContainer pc = RhqAgentPluginContainer.switchPluginContainer(container.getName());
            this.pluginContainer.set((Object)pc);
            if (container.getDeployableContainer() instanceof RhqAgentPluginContainer) {
                this.rhqAgentPluginContainer.set((Object)((RhqAgentPluginContainer)container.getDeployableContainer()));
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not switch to the PluginContainer '" + container.getName() + "'.", e);
        }
    }

    private OperateOnDeployment getOperateOnDeployment(Annotation[] annotations) {
        for (Annotation a : annotations) {
            if (!(a instanceof OperateOnDeployment)) continue;
            return (OperateOnDeployment)a;
        }
        return null;
    }
}

