/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.test.arquillian;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.rhq.core.clientapi.agent.upgrade.ResourceUpgradeRequest;
import org.rhq.core.clientapi.agent.upgrade.ResourceUpgradeResponse;
import org.rhq.core.clientapi.server.discovery.InventoryReport;
import org.rhq.core.domain.discovery.ResourceSyncInfo;
import org.rhq.core.domain.resource.InventoryStatus;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceError;
import org.rhq.core.domain.resource.ResourceErrorType;
import org.rhq.core.domain.resource.ResourceType;

public class FakeServerInventory {
    private static final Log LOG = LogFactory.getLog(FakeServerInventory.class);
    private Resource platform;
    private Map<String, Resource> resourceStore = new HashMap<String, Resource>();
    private int counter;
    private boolean failing;
    private boolean failUpgrade;
    private CompleteDiscoveryChecker discoveryChecker;
    private static final Comparator<Resource> ID_COMPARATOR = new Comparator<Resource>(){

        @Override
        public int compare(Resource o1, Resource o2) {
            return o1.getId() - o2.getId();
        }
    };
    private static final Comparator<Resource> RESOURCE_TYPE_COMPARATOR = new Comparator<Resource>(){

        @Override
        public int compare(Resource o1, Resource o2) {
            return o1.getResourceType().equals((Object)o2.getResourceType()) ? 0 : o1.getId() - o2.getId();
        }
    };

    public FakeServerInventory() {
        this(false);
    }

    public FakeServerInventory(boolean failing) {
        this.failing = failing;
    }

    public synchronized void prepopulateInventory(Resource platform, Collection<Resource> topLevelServers) {
        this.platform = this.fakePersist(platform, InventoryStatus.COMMITTED, new HashSet<String>());
        for (Resource res : topLevelServers) {
            res.setParentResource(this.platform);
            this.fakePersist(res, InventoryStatus.COMMITTED, new HashSet<String>());
        }
    }

    public CompleteDiscoveryChecker createAsyncDiscoveryCompletionChecker(int expectedResourceTreeDepth) {
        this.discoveryChecker = new CompleteDiscoveryChecker(expectedResourceTreeDepth);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Created a new discovery complete checker with tree depth " + expectedResourceTreeDepth + ": " + this.discoveryChecker));
        }
        return this.discoveryChecker;
    }

    public synchronized Answer<ResourceSyncInfo> mergeInventoryReport(final InventoryStatus requiredInventoryStatus) {
        return new Answer<ResourceSyncInfo>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public ResourceSyncInfo answer(InvocationOnMock invocation) throws Throwable {
                FakeServerInventory fakeServerInventory = FakeServerInventory.this;
                synchronized (fakeServerInventory) {
                    ResourceSyncInfo resourceSyncInfo;
                    InventoryReport inventoryReport = (InventoryReport)invocation.getArguments()[0];
                    try {
                        FakeServerInventory.this.throwIfFailing();
                        for (Resource res : inventoryReport.getAddedRoots()) {
                            Resource persisted = FakeServerInventory.this.fakePersist(res, requiredInventoryStatus, new HashSet());
                            if (res.getParentResource() != Resource.ROOT) continue;
                            FakeServerInventory.this.platform = persisted;
                        }
                        resourceSyncInfo = FakeServerInventory.this.getSyncInfo();
                    }
                    catch (Throwable throwable) {
                        if (FakeServerInventory.this.discoveryChecker != null && !inventoryReport.getAddedRoots().isEmpty()) {
                            FakeServerInventory.this.discoveryChecker.setDepth(FakeServerInventory.this.getResourceTreeDepth());
                        }
                        throw throwable;
                    }
                    if (FakeServerInventory.this.discoveryChecker != null && !inventoryReport.getAddedRoots().isEmpty()) {
                        FakeServerInventory.this.discoveryChecker.setDepth(FakeServerInventory.this.getResourceTreeDepth());
                    }
                    return resourceSyncInfo;
                }
            }
        };
    }

    public synchronized int getResourceTreeDepth() {
        if (this.platform == null) {
            return 0;
        }
        return FakeServerInventory.getTreeDepth(this.platform);
    }

    private static int getTreeDepth(Resource root) {
        int maxDepth = 0;
        for (Resource c : root.getChildResources()) {
            int childDepth = FakeServerInventory.getTreeDepth(c);
            if (maxDepth >= childDepth) continue;
            maxDepth = childDepth;
        }
        return maxDepth + 1;
    }

    public synchronized Answer<ResourceSyncInfo> clearPlatform() {
        return new Answer<ResourceSyncInfo>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public ResourceSyncInfo answer(InvocationOnMock invocation) throws Throwable {
                FakeServerInventory fakeServerInventory = FakeServerInventory.this;
                synchronized (fakeServerInventory) {
                    FakeServerInventory.this.throwIfFailing();
                    FakeServerInventory.this.platform = null;
                    return FakeServerInventory.this.getSyncInfo();
                }
            }
        };
    }

    public synchronized Answer<Void> setResourceError() {
        return new Answer<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Void answer(InvocationOnMock invocation) throws Throwable {
                FakeServerInventory fakeServerInventory = FakeServerInventory.this;
                synchronized (fakeServerInventory) {
                    FakeServerInventory.this.throwIfFailing();
                    ResourceError error = (ResourceError)invocation.getArguments()[0];
                    Resource serverSideResource = (Resource)FakeServerInventory.this.resourceStore.get(error.getResource().getUuid());
                    if (serverSideResource != null) {
                        List currentErrors = serverSideResource.getResourceErrors();
                        currentErrors.add(error);
                    }
                    return null;
                }
            }
        };
    }

    public synchronized Answer<Set<ResourceUpgradeResponse>> upgradeResources() {
        return new Answer<Set<ResourceUpgradeResponse>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Set<ResourceUpgradeResponse> answer(InvocationOnMock invocation) throws Throwable {
                FakeServerInventory fakeServerInventory = FakeServerInventory.this;
                synchronized (fakeServerInventory) {
                    FakeServerInventory.this.throwIfFailing();
                    if (FakeServerInventory.this.failUpgrade) {
                        throw new RuntimeException("Failing the upgrade purposefully.");
                    }
                    Object[] args = invocation.getArguments();
                    Set requests = (Set)args[0];
                    HashSet<ResourceUpgradeResponse> responses = new HashSet<ResourceUpgradeResponse>();
                    for (final ResourceUpgradeRequest request : requests) {
                        Resource resource = FakeServerInventory.findResource(FakeServerInventory.this.platform, new Resource(){

                            public int getId() {
                                return request.getResourceId();
                            }
                        }, ID_COMPARATOR);
                        if (resource == null) continue;
                        if (request.getNewDescription() != null) {
                            resource.setDescription(request.getNewDescription());
                        }
                        if (request.getNewName() != null) {
                            resource.setName(request.getNewName());
                        }
                        if (request.getNewResourceKey() != null) {
                            resource.setResourceKey(request.getNewResourceKey());
                        }
                        if (request.getUpgradeErrorMessage() != null) {
                            ResourceError error = new ResourceError(resource, ResourceErrorType.UPGRADE, request.getUpgradeErrorMessage(), request.getUpgradeErrorStackTrace(), request.getTimestamp());
                            resource.getResourceErrors().add(error);
                        }
                        ResourceUpgradeResponse resp = new ResourceUpgradeResponse();
                        resp.setResourceId(resource.getId());
                        resp.setUpgradedResourceName(resource.getName());
                        resp.setUpgradedResourceKey(resource.getResourceKey());
                        resp.setUpgradedResourceDescription(resource.getDescription());
                        responses.add(resp);
                    }
                    return responses;
                }
            }
        };
    }

    public synchronized Answer<Set<Resource>> getResources() {
        return new Answer<Set<Resource>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Set<Resource> answer(InvocationOnMock invocation) throws Throwable {
                FakeServerInventory fakeServerInventory = FakeServerInventory.this;
                synchronized (fakeServerInventory) {
                    FakeServerInventory.this.throwIfFailing();
                    Object[] args = invocation.getArguments();
                    Set resourceIds = (Set)args[0];
                    boolean includeDescendants = (Boolean)args[1];
                    return FakeServerInventory.this.getResources(resourceIds, includeDescendants);
                }
            }
        };
    }

    public synchronized boolean isFailing() {
        return this.failing;
    }

    public synchronized void setFailing(boolean failing) {
        this.failing = failing;
    }

    public synchronized boolean isFailUpgrade() {
        return this.failUpgrade;
    }

    public synchronized void setFailUpgrade(boolean failUpgrade) {
        this.failUpgrade = failUpgrade;
    }

    public synchronized Set<Resource> findResourcesByType(final ResourceType type) {
        HashSet<Resource> result = new HashSet<Resource>();
        if (this.platform != null) {
            FakeServerInventory.findResources(this.platform, new Resource(){

                public ResourceType getResourceType() {
                    return type;
                }
            }, result, RESOURCE_TYPE_COMPARATOR);
        }
        return result;
    }

    private Set<Resource> getResources(Set<Integer> resourceIds, boolean includeDescendants) {
        LinkedHashSet<Resource> result = new LinkedHashSet<Resource>();
        for (final Integer id : resourceIds) {
            Resource r = FakeServerInventory.findResource(this.platform, new Resource(){

                public int getId() {
                    return id;
                }
            }, ID_COMPARATOR);
            if (r == null) continue;
            result.add(r);
            if (!includeDescendants) continue;
            for (Resource child : r.getChildResources()) {
                result.addAll(this.getResources(Collections.singleton(child.getId()), true));
            }
        }
        return result;
    }

    public void removeResource(Resource r) {
        this.resourceStore.remove(r.getUuid());
        Resource parent = r.getParentResource();
        if (parent != null) {
            parent.getChildResources().remove(r);
        }
        for (Resource child : r.getChildResources()) {
            this.removeResource(child);
        }
    }

    public Map<String, Resource> getResourceStore() {
        return this.resourceStore;
    }

    private Resource fakePersist(Resource agentSideResource, InventoryStatus requiredInventoryStatus, Set<String> inProgressUUIds) {
        Resource parent;
        Resource persisted = this.resourceStore.get(agentSideResource.getUuid());
        if (!inProgressUUIds.add(agentSideResource.getUuid())) {
            return persisted;
        }
        if (persisted == null) {
            persisted = new Resource();
            if (agentSideResource.getId() != 0 && this.counter < agentSideResource.getId()) {
                this.counter = agentSideResource.getId() - 1;
            }
            persisted.setId(++this.counter);
            persisted.setUuid(agentSideResource.getUuid());
            persisted.setAgent(agentSideResource.getAgent());
            persisted.setCurrentAvailability(agentSideResource.getCurrentAvailability());
            persisted.setDescription(agentSideResource.getDescription());
            persisted.setName(agentSideResource.getName());
            persisted.setPluginConfiguration(agentSideResource.getPluginConfiguration().clone());
            persisted.setResourceConfiguration(agentSideResource.getResourceConfiguration().clone());
            persisted.setVersion(agentSideResource.getVersion());
            persisted.setInventoryStatus(requiredInventoryStatus);
            persisted.setResourceKey(agentSideResource.getResourceKey());
            persisted.setResourceType(agentSideResource.getResourceType());
            this.resourceStore.put(persisted.getUuid(), persisted);
        }
        if ((parent = agentSideResource.getParentResource()) != null && parent != Resource.ROOT) {
            parent = this.fakePersist(agentSideResource.getParentResource(), requiredInventoryStatus, inProgressUUIds);
            persisted.setParentResource(parent);
            parent.getChildResources().add(persisted);
        } else {
            persisted.setParentResource(parent);
        }
        LinkedHashSet<Resource> childResources = new LinkedHashSet<Resource>();
        for (Resource child : agentSideResource.getChildResources()) {
            childResources.add(this.fakePersist(child, requiredInventoryStatus, inProgressUUIds));
        }
        childResources.addAll(persisted.getChildResources());
        persisted.setChildResources(childResources);
        inProgressUUIds.remove(agentSideResource.getUuid());
        return persisted;
    }

    private ResourceSyncInfo getSyncInfo() {
        return this.platform != null ? FakeServerInventory.convert(this.platform) : null;
    }

    private void throwIfFailing() {
        if (this.failing) {
            throw new RuntimeException("Fake server inventory is in the failing mode.");
        }
    }

    private static ResourceSyncInfo convert(Resource root) {
        return FakeServerInventory.convertInternal(root, new HashMap<String, ResourceSyncInfo>());
    }

    private static ResourceSyncInfo convertInternal(Resource root, Map<String, ResourceSyncInfo> intermediateResults) {
        ResourceSyncInfo ret = intermediateResults.get(root.getUuid());
        if (ret != null) {
            return ret;
        }
        try {
            ret = new ResourceSyncInfo();
            intermediateResults.put(root.getUuid(), ret);
            Class<ResourceSyncInfo> clazz = ResourceSyncInfo.class;
            FakeServerInventory.getPrivateField(clazz, "id").set(ret, root.getId());
            FakeServerInventory.getPrivateField(clazz, "uuid").set(ret, root.getUuid());
            FakeServerInventory.getPrivateField(clazz, "mtime").set(ret, root.getMtime());
            FakeServerInventory.getPrivateField(clazz, "inventoryStatus").set(ret, root.getInventoryStatus());
            ResourceSyncInfo parent = root.getParentResource() == null ? null : FakeServerInventory.convertInternal(root.getParentResource(), intermediateResults);
            FakeServerInventory.getPrivateField(clazz, "parent").set(ret, parent);
            LinkedHashSet<ResourceSyncInfo> children = new LinkedHashSet<ResourceSyncInfo>();
            for (Resource child : root.getChildResources()) {
                ResourceSyncInfo syncChild = FakeServerInventory.convertInternal(child, intermediateResults);
                children.add(syncChild);
            }
            FakeServerInventory.getPrivateField(clazz, "childSyncInfos").set(ret, children);
            return ret;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to convert resource " + root + " to a ResourceSyncInfo. This should not happen.", e);
        }
    }

    private static Field getPrivateField(Class<?> clazz, String fieldName) throws NoSuchFieldException {
        Field field = clazz.getDeclaredField(fieldName);
        if (!field.isAccessible()) {
            field.setAccessible(true);
        }
        return field;
    }

    private static Resource findResource(Resource root, Resource template, Comparator<Resource> comparator) {
        if (root == null) {
            return null;
        }
        if (comparator.compare(root, template) == 0) {
            return root;
        }
        for (Resource child : root.getChildResources()) {
            Resource found = FakeServerInventory.findResource(child, template, comparator);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    private static void findResources(Resource root, Resource template, Set<Resource> result, Comparator<Resource> comparator) {
        if (root == null) {
            return;
        }
        if (comparator.compare(root, template) == 0) {
            result.add(root);
        } else {
            for (Resource child : root.getChildResources()) {
                FakeServerInventory.findResources(child, template, result, comparator);
            }
        }
    }

    public static class CompleteDiscoveryChecker {
        private boolean depthReached;
        private final int expectedDepth;
        private final Object sync = new Object();

        public CompleteDiscoveryChecker(int expectedDepth) {
            this.expectedDepth = expectedDepth;
        }

        public void waitForDiscoveryComplete() throws InterruptedException {
            this.waitForDiscoveryComplete(0L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitForDiscoveryComplete(long timeoutMillis) throws InterruptedException {
            Object object = this.sync;
            synchronized (object) {
                if (!this.depthReached) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Waiting for the discovery to complete on " + this));
                    }
                    this.sync.wait(timeoutMillis);
                } else if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Discovery already complete... no need to wait on " + this));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setDepth(int resourceTreeDepth) {
            Object object = this.sync;
            synchronized (object) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Current tree depth is " + resourceTreeDepth + ", while this checker is waiting for " + this.expectedDepth + " on " + this));
                }
                if (!this.depthReached && resourceTreeDepth >= this.expectedDepth) {
                    this.depthReached = true;
                    new Thread(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            try {
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug((Object)"Ad-hoc wait for discovery to really complete...");
                                }
                                Thread.sleep(500L);
                            }
                            catch (InterruptedException interruptedException) {
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug((Object)("Notifying about discovery complete on " + CompleteDiscoveryChecker.this));
                                }
                                Object object = CompleteDiscoveryChecker.this.sync;
                                synchronized (object) {
                                    CompleteDiscoveryChecker.this.sync.notifyAll();
                                }
                            }
                            finally {
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug((Object)("Notifying about discovery complete on " + CompleteDiscoveryChecker.this));
                                }
                                Object object = CompleteDiscoveryChecker.this.sync;
                                synchronized (object) {
                                    CompleteDiscoveryChecker.this.sync.notifyAll();
                                }
                            }
                        }
                    }).start();
                }
            }
        }
    }
}

