/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.apache.util;

import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.rhq.plugins.apache.ApacheServerComponent;
import org.rhq.plugins.apache.parser.ApacheDirectiveTree;
import org.rhq.plugins.apache.util.HttpdAddressUtility;
import org.rhq.plugins.apache.util.VHostSpec;

public class VirtualHostLegacyResourceKeyUtil {
    private List<VHostSpec> vhosts;
    private List<HttpdAddressUtility.Address> snmpLikeReport;
    private HttpdAddressUtility addressUtility;
    private ApacheDirectiveTree runtimeConfig;
    private ApacheServerComponent serverComponent;

    public VirtualHostLegacyResourceKeyUtil(ApacheServerComponent serverComponent, ApacheDirectiveTree runtimeConfig) {
        this.runtimeConfig = runtimeConfig;
        this.addressUtility = serverComponent.getAddressUtility();
        this.serverComponent = serverComponent;
        this.vhosts = VHostSpec.detect(runtimeConfig);
        this.snmpLikeReport = new ArrayList<HttpdAddressUtility.Address>();
        this.snmpLikeReport.add(this.addressUtility.getHttpdInternalMainServerAddressRepresentation(runtimeConfig));
        for (VHostSpec vhost : this.vhosts) {
            HttpdAddressUtility.Address snmpRecord = this.addressUtility.getHttpdInternalVirtualHostAddressRepresentation(runtimeConfig, vhost.hosts.get(0), vhost.serverName);
            this.snmpLikeReport.add(snmpRecord);
        }
    }

    public Set<String> getLegacyMainServerResourceKeys() {
        HashSet<String> ret = new HashSet<String>();
        String key = this.getRHQ3NonSNMPLegacyMainServerResourceKey();
        ret.add(key);
        String snmpKey = this.getRHQ3SNMPLikeResourceKey(key);
        if (snmpKey != null) {
            ret.add(snmpKey);
        }
        ret.add(this.addressUtility.getHttpdInternalMainServerAddressRepresentation(this.runtimeConfig).toString(false, false));
        return ret;
    }

    public String getRHQ3NonSNMPLegacyMainServerResourceKey() {
        String mainServerUrl = this.serverComponent.getServerUrl();
        String key = null;
        if (mainServerUrl != null && !"null".equals(mainServerUrl)) {
            try {
                URI mainServerUri = new URI(mainServerUrl);
                String host = mainServerUri.getHost();
                int port = mainServerUri.getPort();
                if (port == -1) {
                    port = 80;
                }
                key = host + ":" + port;
            }
            catch (URISyntaxException uRISyntaxException) {}
        } else {
            key = "MainServer";
        }
        return key;
    }

    public Set<String> getLegacyVirtualHostResourceKeys(VHostSpec vhost) {
        String key = this.getRHQ3NonSNMPLegacyVirtualHostResourceKey(vhost);
        HashSet<String> ret = new HashSet<String>();
        ret.add(key);
        String snmpKey = this.getRHQ3SNMPLikeResourceKey(key);
        if (snmpKey != null) {
            ret.add(snmpKey);
        }
        String snmpKeyFromRhq1 = this.addressUtility.getHttpdInternalVirtualHostAddressRepresentation(this.runtimeConfig, vhost.hosts.get(0), vhost.serverName).toString(false, false);
        ret.add(snmpKeyFromRhq1);
        return ret;
    }

    public String getRHQ3NonSNMPLegacyVirtualHostResourceKey(VHostSpec vhost) {
        String host = vhost.hosts.get(0);
        HttpdAddressUtility.Address hostAddr = HttpdAddressUtility.Address.parse(host);
        if (vhost.serverName != null) {
            HttpdAddressUtility.Address serverAddr = HttpdAddressUtility.Address.parse(vhost.serverName);
            hostAddr.host = serverAddr.host;
        }
        try {
            InetAddress hostName = InetAddress.getByName(hostAddr.host);
            hostAddr.host = hostName.getHostName();
        }
        catch (UnknownHostException e) {
            // empty catch block
        }
        return hostAddr.host + ":" + hostAddr.port;
    }

    public String getRHQ3SNMPLikeResourceKey(String nonSnmpResourceKey) {
        int idx = this.getMatchingWwwServiceIndex(nonSnmpResourceKey);
        if (idx < 0) {
            return null;
        }
        HttpdAddressUtility.Address snmpRecord = this.snmpLikeReport.get(idx);
        return snmpRecord.host + ":" + snmpRecord.port;
    }

    private int getMatchingWwwServiceIndex(String resourceKey) {
        int ret = -1;
        String vhostServerName = null;
        String[] vhostAddressStrings = null;
        int pipeIdx = resourceKey.indexOf(124);
        if (pipeIdx >= 0) {
            vhostServerName = resourceKey.substring(0, pipeIdx);
        }
        vhostAddressStrings = resourceKey.substring(pipeIdx + 1).split(" ");
        ArrayList<HttpdAddressUtility.Address> vhostAddresses = new ArrayList<HttpdAddressUtility.Address>(vhostAddressStrings.length);
        if (vhostAddressStrings.length == 1 && "MainServer".equals(vhostAddressStrings[0])) {
            HttpdAddressUtility.Address serverAddr = this.addressUtility.getMainServerSampleAddress(this.runtimeConfig, null, 0);
            if (serverAddr != null) {
                vhostAddresses.add(serverAddr);
            }
        } else {
            for (int i = 0; i < vhostAddressStrings.length; ++i) {
                HttpdAddressUtility.Address vhostAddr = this.addressUtility.getVirtualHostSampleAddress(this.runtimeConfig, vhostAddressStrings[i], vhostServerName, true);
                if (vhostAddr != null) {
                    vhostAddresses.add(vhostAddr);
                    continue;
                }
                HttpdAddressUtility.Address addr = HttpdAddressUtility.Address.parse(vhostAddressStrings[i]);
                vhostAddr = this.addressUtility.getMainServerSampleAddress(this.runtimeConfig, addr.host, addr.port);
                if (vhostAddr == null) continue;
                vhostAddresses.add(vhostAddr);
            }
        }
        int bestMatchRate = 0;
        int idx = 0;
        for (HttpdAddressUtility.Address snmpAddress : this.snmpLikeReport) {
            int matchRate = VirtualHostLegacyResourceKeyUtil.matchRate(vhostAddresses, snmpAddress);
            if (matchRate > bestMatchRate) {
                ret = idx;
                bestMatchRate = matchRate;
            }
            ++idx;
        }
        return ret;
    }

    private static int matchRate(List<HttpdAddressUtility.Address> addresses, HttpdAddressUtility.Address addressToCheck) {
        InetAddress[] ipAddresses;
        for (HttpdAddressUtility.Address a : addresses) {
            if (!HttpdAddressUtility.isAddressConforming(addressToCheck, a.host, a.port, true)) continue;
            return 3;
        }
        try {
            for (InetAddress ip : ipAddresses = InetAddress.getAllByName(addressToCheck.host)) {
                HttpdAddressUtility.Address newCheck = new HttpdAddressUtility.Address(ip.getHostAddress(), addressToCheck.port);
                for (HttpdAddressUtility.Address a : addresses) {
                    if (!HttpdAddressUtility.isAddressConforming(newCheck, a.host, a.port, true)) continue;
                    return 2;
                }
            }
        }
        catch (UnknownHostException e) {
            return 0;
        }
        int addressPort = addressToCheck.port;
        if (addressPort == 80) {
            addressPort = 0;
        }
        for (HttpdAddressUtility.Address listAddress : addresses) {
            InetAddress[] listAddresses;
            int listPort = listAddress.port;
            if (listPort == 80) {
                listPort = 0;
            }
            try {
                listAddresses = InetAddress.getAllByName(listAddress.host);
            }
            catch (UnknownHostException e) {
                return 0;
            }
            for (InetAddress listInetAddr : listAddresses) {
                for (InetAddress ip : ipAddresses) {
                    if (!ip.equals(listInetAddr) || addressPort != listPort) continue;
                    return 1;
                }
            }
        }
        return 0;
    }
}

