/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.apache.parser;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.plugins.apache.parser.ApacheConfigReader;
import org.rhq.plugins.apache.parser.ApacheDirective;
import org.rhq.plugins.apache.parser.ApacheDirectiveTree;

public class ApacheConfigWriter {
    private static final Log log = LogFactory.getLog(ApacheConfigReader.class);

    public ApacheConfigWriter(ApacheDirectiveTree tree) {
    }

    private void findUpdated(ApacheDirective dir, List<ApacheDirective> updatedNodes) {
        if (dir.isUpdated()) {
            updatedNodes.add(dir);
        }
        for (ApacheDirective directive : dir.getChildDirectives()) {
            this.findUpdated(directive, updatedNodes);
        }
    }

    private Set<String> findUpdatedFiles(List<ApacheDirective> updatedNodes) {
        HashSet<String> updatedFiles = new HashSet<String>();
        for (ApacheDirective dir : updatedNodes) {
            updatedFiles.contains(dir.getFile());
        }
        return updatedFiles;
    }

    public void saveFile(String path) {
    }

    private ApacheDirective findFirstFileDirective(ApacheDirective node, String file) {
        if (node.getFile().equals(file)) {
            return node.getParentNode();
        }
        for (ApacheDirective dir : node.getChildDirectives()) {
            ApacheDirective dd = this.findFirstFileDirective(dir, file);
            if (dd == null) continue;
            return dd.getParentNode();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveFile(String file, ApacheDirective dir) throws Exception {
        File fl = new File(file);
        if (!fl.exists() && !fl.createNewFile()) {
            log.error((Object)("Failed to create apache config file: " + fl.getAbsolutePath()));
            throw new IOException("Failed to create apache config file: " + fl.getAbsolutePath());
        }
        FileOutputStream str = new FileOutputStream(fl);
        try {
            for (ApacheDirective d : dir.getChildDirectives()) {
                if (!dir.getFile().equals(file)) continue;
                this.writeToFile(str, dir, file);
            }
        }
        finally {
            ((OutputStream)str).close();
        }
    }

    private void writeToFile(OutputStream str, ApacheDirective dir, String file) throws Exception {
        if (dir.getFile().equals(file)) {
            str.write(dir.getText().getBytes());
            if (dir.isNested()) {
                for (ApacheDirective tempDir : dir.getChildDirectives()) {
                    this.writeToFile(str, tempDir, file);
                }
                str.write(("</" + dir.getName() + ">").getBytes());
            }
        }
    }
}

