/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.apache;

import org.rhq.core.domain.measurement.AvailabilityType;

public final class AvailabilityResult {
    private final AvailabilityType availabilityType;
    private final ErrorType errorType;
    private final String message;
    private final Throwable throwable;

    private AvailabilityResult(AvailabilityType availabilityType, ErrorType errorType, String message, Throwable throwable) {
        this.availabilityType = availabilityType;
        this.errorType = errorType;
        this.message = message;
        this.throwable = throwable;
    }

    public static AvailabilityResult availabilityIsUp() {
        return new AvailabilityResult(AvailabilityType.UP, ErrorType.NONE, null, null);
    }

    public static AvailabilityResult availabilityIsDown(String message) {
        return AvailabilityResult.availabilityIsDown(ErrorType.UNKNOWN, message, null);
    }

    public static AvailabilityResult availabilityIsDown(String message, Throwable throwable) {
        return AvailabilityResult.availabilityIsDown(ErrorType.UNKNOWN, message, throwable);
    }

    public static AvailabilityResult availabilityIsDown(ErrorType errorType, String message) {
        return AvailabilityResult.availabilityIsDown(errorType, message, null);
    }

    public static AvailabilityResult availabilityIsDown(ErrorType errorType, String message, Throwable throwable) {
        if (errorType == null) {
            throw new IllegalArgumentException("errorType is null");
        }
        if (errorType == ErrorType.NONE) {
            throw new IllegalArgumentException("Cannot set errorType to '" + ErrorType.NONE.name() + "' for availabilityType '" + AvailabilityType.DOWN.name() + "'");
        }
        return new AvailabilityResult(AvailabilityType.DOWN, errorType, null, null);
    }

    public AvailabilityType getAvailabilityType() {
        return this.availabilityType;
    }

    public ErrorType getErrorType() {
        return this.errorType;
    }

    public String getMessage() {
        return this.message;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public static enum ErrorType {
        CANNOT_CONNECT,
        CONNECTION_TIMEOUT,
        UNKNOWN,
        NONE;

    }
}

