/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.apache;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.augeas.AugeasComponent;
import org.rhq.augeas.node.AugeasNode;
import org.rhq.augeas.tree.AugeasTree;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.ConfigurationUpdateStatus;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.pluginapi.configuration.ConfigurationFacet;
import org.rhq.core.pluginapi.configuration.ConfigurationUpdateReport;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.plugins.apache.ApacheDirectoryComponent;
import org.rhq.plugins.apache.mapping.ApacheAugeasMapping;
import org.rhq.plugins.apache.util.AugeasNodeSearch;

public class ApacheIfModuleDirectoryComponent
implements ResourceComponent<ApacheDirectoryComponent>,
ConfigurationFacet {
    private ResourceContext<ApacheDirectoryComponent> context;
    private ApacheDirectoryComponent parentComponent;
    private final Log log = LogFactory.getLog(this.getClass());
    private static final String IFMODULE_DIRECTIVE_NAME = "<IfModule";

    public void start(ResourceContext<ApacheDirectoryComponent> context) throws InvalidPluginConfigurationException, Exception {
        this.context = context;
        this.parentComponent = (ApacheDirectoryComponent)context.getParentResourceComponent();
    }

    public void stop() {
    }

    public AvailabilityType getAvailability() {
        return this.parentComponent.getAvailability();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Configuration loadResourceConfiguration() throws Exception {
        if (!this.isAugeasEnabled()) {
            this.log.debug((Object)"Configuration and child resource creation/deletion support for Apache is optional. If you switched it on by enabling Augeas support in the connection settings of the Apache server resource and still get this message, it means that either your Apache version is not supported (only Apache 2.x is supported) or Augeas is not available on your platform. Please refer to your agent's log for the precise exception that is causing this behavior. It will logged at error level only once per plugin container lifetime");
            return null;
        }
        ConfigurationDefinition resourceConfigDef = this.context.getResourceType().getResourceConfigurationDefinition();
        AugeasComponent comp = this.parentComponent.getAugeas();
        AugeasTree tree = null;
        try {
            tree = comp.getAugeasTree("Httpd");
            AugeasNode directoryNode = this.parentComponent.getNode(tree);
            ApacheAugeasMapping mapping = new ApacheAugeasMapping(tree);
            Configuration configuration = mapping.updateConfiguration(this.getNode(directoryNode), resourceConfigDef);
            return configuration;
        }
        finally {
            comp.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateResourceConfiguration(ConfigurationUpdateReport report) {
        if (!this.isAugeasEnabled()) {
            report.setStatus(ConfigurationUpdateStatus.FAILURE);
            report.setErrorMessage("Configuration and child resource creation/deletion support for Apache is optional. If you switched it on by enabling Augeas support in the connection settings of the Apache server resource and still get this message, it means that either your Apache version is not supported (only Apache 2.x is supported) or Augeas is not available on your platform. Please refer to your agent's log for the precise exception that is causing this behavior. It will logged at error level only once per plugin container lifetime");
        }
        AugeasComponent comp = this.parentComponent.getAugeas();
        AugeasTree tree = null;
        try {
            tree = comp.getAugeasTree("Httpd");
            ConfigurationDefinition resourceConfigDef = this.context.getResourceType().getResourceConfigurationDefinition();
            ApacheAugeasMapping mapping = new ApacheAugeasMapping(tree);
            AugeasNode directoryNode = this.getNode(this.parentComponent.getNode(tree));
            mapping.updateAugeas(directoryNode, report.getConfiguration(), resourceConfigDef);
            tree.save();
            report.setStatus(ConfigurationUpdateStatus.SUCCESS);
            this.log.info((Object)"Apache configuration was updated");
            ((ApacheDirectoryComponent)this.context.getParentResourceComponent()).finishConfigurationUpdate(report);
        }
        catch (Exception e) {
            if (tree != null) {
                this.log.error((Object)("Augeas failed to save configuration " + tree.summarizeAugeasError()));
            } else {
                this.log.error((Object)"Augeas failed to save configuration", (Throwable)e);
            }
            report.setStatus(ConfigurationUpdateStatus.FAILURE);
        }
        finally {
            comp.close();
        }
    }

    private AugeasNode getNode(AugeasNode virtualHost) {
        AugeasNode directory = AugeasNodeSearch.findNodeById(virtualHost, this.context.getResourceKey());
        return directory;
    }

    public boolean isAugeasEnabled() {
        return this.parentComponent.isAugeasEnabled();
    }
}

