/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.apache;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.pluginapi.plugin.PluginContext;
import org.rhq.core.pluginapi.plugin.PluginLifecycleListener;

public class ApachePluginLifecycleListener
implements PluginLifecycleListener {
    private static final Log log = LogFactory.getLog(ApachePluginLifecycleListener.class);
    protected String dataPath;
    private static String LENS_NAME = "httpd.aug";

    public void initialize(PluginContext context) throws Exception {
        try {
            File tempDirectory = context.getDataDirectory();
            tempDirectory.mkdir();
            this.dataPath = tempDirectory.getAbsolutePath();
            this.copyTheLens(this.dataPath);
        }
        catch (Exception e) {
            log.error((Object)"Copy of augeas lens to temporary folder failed.", (Throwable)e);
        }
    }

    public void shutdown() {
        File[] files;
        File tempDirectory = new File(this.dataPath);
        for (File file : files = tempDirectory.listFiles()) {
            if (!file.getName().matches(".*.aug")) continue;
            file.delete();
        }
    }

    private File cpFileFromPluginToTemp(ClassLoader loader, File tempDirectory, String fileName) throws IOException, Exception {
        File destinationFile = new File(tempDirectory, fileName);
        if (!destinationFile.exists()) {
            destinationFile.createNewFile();
            InputStream input = loader.getResourceAsStream(fileName);
            this.copyFile(input, destinationFile);
        }
        return destinationFile;
    }

    public void copyFile(InputStream in, File destination) throws Exception {
        int length;
        if (!destination.canWrite()) {
            throw new Exception("Creating of temporary file for lens failed. Destination file " + destination.getAbsolutePath() + " is not accessible.");
        }
        FileOutputStream out = new FileOutputStream(destination);
        byte[] buf = new byte[1024];
        while ((length = in.read(buf)) > 0) {
            ((OutputStream)out).write(buf, 0, length);
        }
        in.close();
        ((OutputStream)out).close();
    }

    public void copyTheLens(String tempDirectory) throws Exception {
        URL url = this.getClass().getClassLoader().getResource(LENS_NAME);
        String tempFile = url.getFile();
        File file = new File(tempFile);
        String modName = Character.toLowerCase(file.getName().charAt(0)) + file.getName().substring(1);
        File destinationFile = new File(tempDirectory, modName);
        if (!destinationFile.exists()) {
            destinationFile.createNewFile();
            InputStream input = this.getClass().getClassLoader().getResourceAsStream(LENS_NAME);
            this.copyFile(input, destinationFile);
        }
    }
}

