/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.apache;

import java.io.File;
import java.net.URI;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.plugins.apache.ApacheServerComponent;
import org.rhq.plugins.apache.parser.ApacheDirective;
import org.rhq.plugins.apache.parser.ApacheDirectiveTree;
import org.rhq.plugins.apache.util.HttpdAddressUtility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApacheVirtualHostServiceDiscoveryComponent
implements ResourceDiscoveryComponent<ApacheServerComponent> {
    private static final String COULD_NOT_DETERMINE_THE_VIRTUAL_HOST_ADDRESS = "*** Could not determine the virtual host address ***";
    public static final String LOGS_DIRECTORY_NAME = "logs";
    private static final String RT_LOG_FILE_NAME_SUFFIX = "_rt.log";
    private static final Log log = LogFactory.getLog(ApacheVirtualHostServiceDiscoveryComponent.class);

    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext<ApacheServerComponent> context) throws InvalidPluginConfigurationException, Exception {
        LinkedHashSet<DiscoveredResourceDetails> discoveredResources = new LinkedHashSet<DiscoveredResourceDetails>();
        ApacheServerComponent serverComponent = (ApacheServerComponent)context.getParentResourceComponent();
        ApacheDirectiveTree tree = serverComponent.loadParser();
        this.discoverMainServer(context, discoveredResources);
        ResourceType resourceType = context.getResourceType();
        File configPath = serverComponent.getServerRoot();
        File logsDir = new File(configPath, LOGS_DIRECTORY_NAME);
        List<ApacheDirective> virtualHosts = tree.search("/<VirtualHost");
        for (ApacheDirective node : virtualHosts) {
            List<String> hosts = node.getValues();
            String firstAddress = hosts.get(0);
            List<ApacheDirective> serverNames = node.getChildByName("ServerName");
            String serverName = null;
            if (serverNames.size() > 0) {
                serverName = serverNames.get(0).getValuesAsString();
            }
            StringBuilder keyBuilder = new StringBuilder();
            if (serverName != null) {
                keyBuilder.append(serverName).append("|");
            }
            keyBuilder.append(firstAddress);
            for (int i = 1; i < hosts.size(); ++i) {
                keyBuilder.append(" ").append(hosts.get(i));
            }
            String resourceKey = keyBuilder.toString();
            Configuration pluginConfiguration = context.getDefaultPluginConfiguration();
            HttpdAddressUtility.Address address = serverComponent.getAddressUtility().getVirtualHostSampleAddress(tree, firstAddress, serverName, false);
            if (address != null) {
                HttpdAddressUtility.Address serverAddress;
                String hostToPing = address.host;
                int portToPing = address.port;
                if (address.isPortWildcard()) {
                    serverAddress = serverComponent.getAddressUtility().getMainServerSampleAddress(tree, hostToPing, 0);
                    portToPing = serverAddress != null ? serverAddress.port : 0;
                }
                if (address.isHostDefault() || address.isHostWildcard()) {
                    serverAddress = serverComponent.getAddressUtility().getMainServerSampleAddress(tree, null, portToPing);
                    hostToPing = serverAddress != null ? serverAddress.host : null;
                }
                String url = hostToPing != null && portToPing != 0 && portToPing != -1 ? "http://" + hostToPing + ":" + portToPing + "/" : COULD_NOT_DETERMINE_THE_VIRTUAL_HOST_ADDRESS;
                PropertySimple urlProp = new PropertySimple("url", (Object)url);
                pluginConfiguration.put((Property)urlProp);
            }
            File rtLogFile = new File(logsDir, address.host + address.port + RT_LOG_FILE_NAME_SUFFIX);
            PropertySimple rtLogProp = new PropertySimple("responseTimeLogFile", (Object)rtLogFile.toString());
            pluginConfiguration.put((Property)rtLogProp);
            String resourceName = serverName != null ? address.toString() : resourceKey;
            discoveredResources.add(new DiscoveredResourceDetails(resourceType, resourceKey, resourceName, null, null, pluginConfiguration, null));
        }
        return discoveredResources;
    }

    private void discoverMainServer(ResourceDiscoveryContext<ApacheServerComponent> context, Set<DiscoveredResourceDetails> discoveredResources) throws Exception {
        ResourceType resourceType = context.getResourceType();
        Configuration mainServerPluginConfig = context.getDefaultPluginConfiguration();
        File configPath = ((ApacheServerComponent)context.getParentResourceComponent()).getServerRoot();
        File logsDir = new File(configPath, LOGS_DIRECTORY_NAME);
        String mainServerUrl = context.getParentResourceContext().getPluginConfiguration().getSimple("url").getStringValue();
        if (mainServerUrl != null && !"null".equals(mainServerUrl)) {
            PropertySimple mainServerUrlProp = new PropertySimple("url", (Object)mainServerUrl);
            mainServerPluginConfig.put((Property)mainServerUrlProp);
            URI mainServerUri = new URI(mainServerUrl);
            String host = mainServerUri.getHost();
            int port = mainServerUri.getPort();
            if (port == -1) {
                port = 80;
            }
            File rtLogFile = new File(logsDir, host + port + RT_LOG_FILE_NAME_SUFFIX);
            PropertySimple rtLogProp = new PropertySimple("responseTimeLogFile", (Object)rtLogFile.toString());
            mainServerPluginConfig.put((Property)rtLogProp);
        }
        DiscoveredResourceDetails mainServer = new DiscoveredResourceDetails(resourceType, "MainServer", "Main", null, null, mainServerPluginConfig, null);
        discoveredResources.add(mainServer);
    }
}

