/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.apache;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.augeas.Augeas;
import net.augeas.AugeasException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rhq.augeas.AugeasProxy;
import org.rhq.augeas.config.AugeasConfiguration;
import org.rhq.augeas.config.AugeasModuleConfig;
import org.rhq.augeas.node.AugeasNode;
import org.rhq.augeas.tree.AugeasTree;
import org.rhq.augeas.tree.AugeasTreeBuilder;
import org.rhq.augeas.util.Glob;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.ConfigurationUpdateStatus;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.event.EventSeverity;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.core.domain.measurement.MeasurementDataTrait;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.domain.resource.CreateResourceStatus;
import org.rhq.core.pluginapi.configuration.ConfigurationFacet;
import org.rhq.core.pluginapi.configuration.ConfigurationUpdateReport;
import org.rhq.core.pluginapi.event.EventContext;
import org.rhq.core.pluginapi.event.EventPoller;
import org.rhq.core.pluginapi.event.log.LogEntryProcessor;
import org.rhq.core.pluginapi.event.log.LogFileEventPoller;
import org.rhq.core.pluginapi.inventory.CreateChildResourceFacet;
import org.rhq.core.pluginapi.inventory.CreateResourceReport;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.measurement.MeasurementFacet;
import org.rhq.core.pluginapi.operation.OperationFacet;
import org.rhq.core.pluginapi.operation.OperationResult;
import org.rhq.core.system.OperatingSystemType;
import org.rhq.core.system.SystemInfo;
import org.rhq.plugins.apache.ApacheErrorLogEntryProcessor;
import org.rhq.plugins.apache.ApacheServerOperationsDelegate;
import org.rhq.plugins.apache.augeas.ApacheAugeasNode;
import org.rhq.plugins.apache.augeas.AugeasConfigurationApache;
import org.rhq.plugins.apache.augeas.AugeasTreeBuilderApache;
import org.rhq.plugins.apache.mapping.ApacheAugeasMapping;
import org.rhq.plugins.apache.parser.ApacheConfigReader;
import org.rhq.plugins.apache.parser.ApacheDirective;
import org.rhq.plugins.apache.parser.ApacheDirectiveTree;
import org.rhq.plugins.apache.parser.ApacheParserImpl;
import org.rhq.plugins.apache.util.ApacheBinaryInfo;
import org.rhq.plugins.apache.util.ConfigurationTimestamp;
import org.rhq.plugins.apache.util.HttpdAddressUtility;
import org.rhq.plugins.platform.PlatformComponent;
import org.rhq.plugins.www.snmp.SNMPClient;
import org.rhq.plugins.www.snmp.SNMPException;
import org.rhq.plugins.www.snmp.SNMPSession;
import org.rhq.plugins.www.snmp.SNMPValue;
import org.rhq.plugins.www.util.WWWUtils;
import org.rhq.rhqtransform.AugeasRHQComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApacheServerComponent
implements AugeasRHQComponent<PlatformComponent>,
MeasurementFacet,
OperationFacet,
ConfigurationFacet,
CreateChildResourceFacet {
    public static final String CONFIGURATION_NOT_SUPPORTED_ERROR_MESSAGE = "Configuration is supported only for Apache version 2 and up using Augeas. You either have an old version of Apache or Augeas is not installed.";
    private final Log log = LogFactory.getLog(this.getClass());
    public static final String PLUGIN_CONFIG_PROP_SERVER_ROOT = "serverRoot";
    public static final String PLUGIN_CONFIG_PROP_EXECUTABLE_PATH = "executablePath";
    public static final String PLUGIN_CONFIG_PROP_CONTROL_SCRIPT_PATH = "controlScriptPath";
    public static final String PLUGIN_CONFIG_PROP_URL = "url";
    public static final String PLUGIN_CONFIG_PROP_HTTPD_CONF = "configFile";
    public static final String PLUGIN_CONFIG_PROP_SNMP_AGENT_HOST = "snmpAgentHost";
    public static final String PLUGIN_CONFIG_PROP_SNMP_AGENT_PORT = "snmpAgentPort";
    public static final String PLUGIN_CONFIG_PROP_SNMP_AGENT_COMMUNITY = "snmpAgentCommunity";
    public static final String PLUGIN_CONFIG_PROP_ERROR_LOG_FILE_PATH = "errorLogFilePath";
    public static final String PLUGIN_CONFIG_PROP_ERROR_LOG_EVENTS_ENABLED = "errorLogEventsEnabled";
    public static final String PLUGIN_CONFIG_PROP_ERROR_LOG_MINIMUM_SEVERITY = "errorLogMinimumSeverity";
    public static final String PLUGIN_CONFIG_PROP_ERROR_LOG_INCLUDES_PATTERN = "errorLogIncludesPattern";
    public static final String PLUGIN_CONFIG_PROP_VHOST_FILES_MASK = "vhostFilesMask";
    public static final String PLUGIN_CONFIG_PROP_VHOST_CREATION_POLICY = "vhostCreationPolicy";
    public static final String PLUGIN_CONFIG_PROP_RESTART_AFTER_CONFIG_UPDATE = "restartAfterConfigurationUpdate";
    public static final String PLUGIN_CONFIG_VHOST_IN_SINGLE_FILE_PROP_VALUE = "single-file";
    public static final String PLUGIN_CONFIG_VHOST_PER_FILE_PROP_VALUE = "vhost-per-file";
    public static final String AUXILIARY_INDEX_PROP = "_index";
    public static final String SERVER_BUILT_TRAIT = "serverBuilt";
    public static final String AUGEAS_ENABLED = "augeasEnabled";
    public static final String DEFAULT_EXECUTABLE_PATH = "bin" + File.separator + (File.separatorChar == '/' ? "httpd" : "Apache.exe");
    public static final String DEFAULT_ERROR_LOG_PATH = "logs" + File.separator + (File.separatorChar == '/' ? "error_log" : "error.log");
    private static final String ERROR_LOG_ENTRY_EVENT_TYPE = "errorLogEntry";
    private static final String[] CONTROL_SCRIPT_PATHS = new String[]{"bin/apachectl", "sbin/apachectl", "bin/apachectl2", "sbin/apachectl2"};
    private ResourceContext<PlatformComponent> resourceContext;
    private EventContext eventContext;
    private SNMPClient snmpClient;
    private URL url;
    private ApacheBinaryInfo binaryInfo;
    private long availPingTime = -1L;
    private ApacheServerOperationsDelegate operationsDelegate;

    public void start(ResourceContext<PlatformComponent> resourceContext) throws Exception {
        this.log.info((Object)("Initializing server component for server [" + resourceContext.getResourceKey() + "]..."));
        this.resourceContext = resourceContext;
        this.eventContext = resourceContext.getEventContext();
        this.snmpClient = new SNMPClient();
        try {
            boolean configured = false;
            SNMPSession snmpSession = this.getSNMPSession();
            if (!snmpSession.ping()) {
                this.log.warn((Object)("Failed to connect to SNMP agent at " + snmpSession + "\n" + ". Make sure\n1) the managed Apache server has been instrumented with the JON SNMP module,\n" + "2) the Apache server is running, and\n" + "3) the SNMP agent host, port, and community are set correctly in this resource's connection properties.\n" + "The agent will not be able to record metrics from apache httpd without SNMP"));
            } else {
                configured = true;
            }
            Configuration pluginConfig = this.resourceContext.getPluginConfiguration();
            String url = pluginConfig.getSimpleValue(PLUGIN_CONFIG_PROP_URL, null);
            if (url != null) {
                try {
                    this.url = new URL(url);
                    if (this.url.getPort() == 0) {
                        this.log.error((Object)"The 'url' connection property is invalid - 0 is not a valid port; please change the value to the port the \"main\" Apache server is listening on. NOTE: If the 'url' property was set this way after autodiscovery, you most likely did not include the port in the ServerName directive for the \"main\" Apache server in httpd.conf.");
                    } else {
                        configured = true;
                    }
                }
                catch (MalformedURLException e) {
                    throw new InvalidPluginConfigurationException("Value of 'url' connection property ('" + url + "') is not a valid URL.");
                }
            }
            if (!configured) {
                throw new InvalidPluginConfigurationException("Neither SNMP nor an URL for checking availability has been configured");
            }
            File executablePath = this.getExecutablePath();
            try {
                this.binaryInfo = ApacheBinaryInfo.getInfo(executablePath.getPath(), this.resourceContext.getSystemInformation());
            }
            catch (Exception e) {
                throw new InvalidPluginConfigurationException("'" + executablePath + "' is not a valid Apache executable (" + e + ").");
            }
            this.operationsDelegate = new ApacheServerOperationsDelegate(this, this.resourceContext.getSystemInformation());
            this.startEventPollers();
        }
        catch (Exception e) {
            if (this.snmpClient != null) {
                this.snmpClient.close();
            }
            throw e;
        }
    }

    public void stop() {
        this.stopEventPollers();
        if (this.snmpClient != null) {
            this.snmpClient.close();
        }
    }

    public AvailabilityType getAvailability() {
        boolean available;
        try {
            if (this.url != null) {
                long t1 = System.currentTimeMillis();
                available = WWWUtils.isAvailable(this.url);
                this.availPingTime = System.currentTimeMillis() - t1;
            } else {
                available = this.getSNMPSession().ping();
                this.availPingTime = -1L;
            }
        }
        catch (Exception e) {
            available = false;
        }
        return available ? AvailabilityType.UP : AvailabilityType.DOWN;
    }

    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> schedules) throws Exception {
        SNMPSession snmpSession = this.getSNMPSession();
        boolean snmpPresent = snmpSession.ping();
        for (MeasurementScheduleRequest schedule : schedules) {
            String metricName = schedule.getName();
            if (metricName.equals(SERVER_BUILT_TRAIT)) {
                MeasurementDataTrait trait = new MeasurementDataTrait(schedule, this.binaryInfo.getBuilt());
                report.addData(trait);
                continue;
            }
            if (metricName.equals("rhq_avail_ping_time")) {
                if (this.availPingTime == -1L) continue;
                MeasurementDataNumeric num = new MeasurementDataNumeric(schedule, Double.valueOf(this.availPingTime));
                report.addData(num);
                continue;
            }
            if (!snmpPresent) continue;
            try {
                String mibName = metricName;
                List<SNMPValue> snmpValues = snmpSession.getColumn(mibName);
                if (snmpValues.isEmpty()) {
                    this.log.error((Object)("No values found for MIB name [" + mibName + "]."));
                    continue;
                }
                SNMPValue snmpValue = snmpValues.get(0);
                boolean valueIsTimestamp = this.isValueTimestamp(mibName);
                this.log.debug((Object)("Collected SNMP metric [" + mibName + "], value = " + snmpValue));
                ApacheServerComponent.addSnmpMetricValueToReport(report, schedule, snmpValue, valueIsTimestamp);
            }
            catch (SNMPException e) {
                this.log.error((Object)"An error occurred while attempting to collect an SNMP metric.", (Throwable)e);
            }
        }
    }

    private boolean isValueTimestamp(String mibName) {
        return mibName.equals("wwwServiceStartTime");
    }

    @Nullable
    public OperationResult invokeOperation(@NotNull String name, @NotNull Configuration params) throws Exception {
        this.log.info((Object)("Invoking operation [" + name + "] on server [" + this.resourceContext.getResourceKey() + "]..."));
        return this.operationsDelegate.invokeOperation(name, params);
    }

    public Configuration loadResourceConfiguration() throws Exception {
        if (!this.isAugeasEnabled()) {
            throw new RuntimeException(CONFIGURATION_NOT_SUPPORTED_ERROR_MESSAGE);
        }
        try {
            ConfigurationDefinition resourceConfigDef = this.resourceContext.getResourceType().getResourceConfigurationDefinition();
            AugeasTree tree = this.getAugeasTree();
            ApacheAugeasMapping mapping = new ApacheAugeasMapping(tree);
            return mapping.updateConfiguration(tree.getRootNode(), resourceConfigDef);
        }
        catch (Exception e) {
            this.log.error((Object)"Failed to load Apache configuration.", (Throwable)e);
            throw e;
        }
    }

    public void updateResourceConfiguration(ConfigurationUpdateReport report) {
        if (!this.isAugeasEnabled()) {
            report.setStatus(ConfigurationUpdateStatus.FAILURE);
            return;
        }
        AugeasTree tree = null;
        try {
            tree = this.getAugeasTree();
            ConfigurationDefinition resourceConfigDef = this.resourceContext.getResourceType().getResourceConfigurationDefinition();
            ApacheAugeasMapping mapping = new ApacheAugeasMapping(tree);
            mapping.updateAugeas(tree.getRootNode(), report.getConfiguration(), resourceConfigDef);
            tree.save();
            this.log.info((Object)"Apache configuration was updated");
            report.setStatus(ConfigurationUpdateStatus.SUCCESS);
            this.finishConfigurationUpdate(report);
        }
        catch (Exception e) {
            if (tree != null) {
                this.log.error((Object)("Augeas failed to save configuration " + tree.summarizeAugeasError()));
            } else {
                this.log.error((Object)"Augeas failed to save configuration", (Throwable)e);
            }
            report.setStatus(ConfigurationUpdateStatus.FAILURE);
        }
    }

    public AugeasProxy getAugeasProxy() throws AugeasException {
        File tempDir = this.resourceContext.getDataDirectory();
        if (!tempDir.exists()) {
            throw new RuntimeException("Loading of lens failed");
        }
        AugeasConfigurationApache config = new AugeasConfigurationApache(tempDir.getAbsolutePath(), this.resourceContext.getPluginConfiguration());
        AugeasTreeBuilderApache builder = new AugeasTreeBuilderApache();
        AugeasProxy augeasProxy = new AugeasProxy((AugeasConfiguration)config, (AugeasTreeBuilder)builder);
        augeasProxy.load();
        return augeasProxy;
    }

    public AugeasTree getAugeasTree() throws AugeasException {
        AugeasProxy proxy = this.getAugeasProxy();
        String module = ((AugeasConfigurationApache)proxy.getConfiguration()).getAugeasModuleName();
        return proxy.getAugeasTree(module, true);
    }

    public CreateResourceReport createResource(CreateResourceReport report) {
        if (!this.isAugeasEnabled()) {
            report.setStatus(CreateResourceStatus.FAILURE);
            report.setErrorMessage("Resources can be created only when augeas is enabled.");
            return report;
        }
        if ("Apache Virtual Host".equals(report.getResourceType().getName())) {
            HttpdAddressUtility.Address addr;
            Configuration vhostResourceConfig = report.getResourceConfiguration();
            ConfigurationDefinition vhostResourceConfigDef = report.getResourceType().getResourceConfigurationDefinition();
            Configuration vhostPluginConfig = report.getPluginConfiguration();
            String vhostDef = report.getUserSpecifiedResourceName();
            String serverName = vhostResourceConfig.getSimpleValue("ServerName", null);
            String resourceKey = vhostDef;
            if (serverName != null) {
                resourceKey = serverName + "|" + resourceKey;
            }
            AugeasProxy proxy = this.getAugeasProxy();
            AugeasTree tree = this.getAugeasTree();
            String[] vhostDefs = vhostDef.split(" ");
            try {
                ApacheDirectiveTree parserTree = new ApacheDirectiveTree();
                ApacheParserImpl parser = new ApacheParserImpl(parserTree, this.getServerRoot().getAbsolutePath());
                ApacheConfigReader.buildTree(this.getHttpdConfFile().getAbsolutePath(), parser);
                addr = this.getAddressUtility().getVirtualHostSampleAddress(parserTree, vhostDefs[0], serverName, false);
            }
            catch (Exception e) {
                report.setStatus(CreateResourceStatus.FAILURE);
                report.setErrorMessage("Wrong format of virtual host resource name.");
                report.setException((Throwable)e);
                return report;
            }
            String resourceName = serverName != null ? addr.host + ":" + addr.port : resourceKey;
            report.setResourceKey(resourceKey);
            report.setResourceName(resourceName);
            String url = "http://" + addr.host + ":" + addr.port + "/";
            vhostPluginConfig.put((Property)new PropertySimple(PLUGIN_CONFIG_PROP_URL, (Object)url));
            List existingVhosts = tree.matchRelative(tree.getRootNode(), "<VirtualHost");
            int seq = existingVhosts.size() + 1;
            Configuration pluginConfig = this.resourceContext.getPluginConfiguration();
            String creationType = pluginConfig.getSimpleValue(PLUGIN_CONFIG_PROP_VHOST_CREATION_POLICY, PLUGIN_CONFIG_VHOST_PER_FILE_PROP_VALUE);
            AugeasNode vhost = null;
            String vhostFile = (String)((AugeasModuleConfig)proxy.getConfiguration().getModules().get(0)).getConfigFiles().get(0);
            if (PLUGIN_CONFIG_VHOST_IN_SINGLE_FILE_PROP_VALUE.equals(creationType)) {
                vhost = tree.createNode(tree.getRootNode(), "<VirtualHost", null, seq);
            } else if (PLUGIN_CONFIG_VHOST_PER_FILE_PROP_VALUE.equals(creationType)) {
                String mask = pluginConfig.getSimpleValue(PLUGIN_CONFIG_PROP_VHOST_FILES_MASK, null);
                if (mask == null) {
                    report.setErrorMessage("No virtual host file mask configured.");
                } else {
                    vhostFile = this.getNewVhostFileName(addr, mask);
                    File vhostFileFile = new File(vhostFile);
                    AugeasConfigurationApache config = (AugeasConfigurationApache)proxy.getConfiguration();
                    AugeasModuleConfig moduleConfig = config.getModuleByName(config.getAugeasModuleName());
                    boolean willPersist = false;
                    for (String glob : moduleConfig.getIncludedGlobs()) {
                        if (!Glob.matches((File)this.getServerRoot(), (String)glob, (File)vhostFileFile)) continue;
                        willPersist = true;
                        break;
                    }
                    if (!willPersist) {
                        moduleConfig.addIncludedGlob(vhostFile);
                    }
                    try {
                        vhostFileFile.createNewFile();
                    }
                    catch (IOException e) {
                        this.log.error((Object)("Failed to create a new vhost file: " + vhostFile), (Throwable)e);
                    }
                    proxy.load();
                    tree = proxy.getAugeasTree(moduleConfig.getModuletName(), true);
                    vhost = tree.createNode("/files" + vhostFile + "/<VirtualHost");
                    ((ApacheAugeasNode)vhost).setParentNode(tree.getRootNode());
                    if (!willPersist) {
                        List includes = tree.matchRelative(tree.getRootNode(), "Include");
                        AugeasNode include = tree.createNode(tree.getRootNode(), "Include", null, includes.size() + 1);
                        tree.createNode(include, "param", vhostFile, 0);
                    }
                }
            }
            if (vhost == null) {
                report.setStatus(CreateResourceStatus.FAILURE);
            } else {
                try {
                    for (int i = 0; i < vhostDefs.length; ++i) {
                        tree.createNode(vhost, "param", vhostDefs[i], i + 1);
                    }
                    ApacheAugeasMapping mapping = new ApacheAugeasMapping(tree);
                    mapping.updateAugeas(vhost, vhostResourceConfig, vhostResourceConfigDef);
                    tree.save();
                    report.setStatus(CreateResourceStatus.SUCCESS);
                    this.finishChildResourceCreate(report);
                }
                catch (Exception e) {
                    report.setStatus(CreateResourceStatus.FAILURE);
                    report.setException((Throwable)e);
                }
            }
        }
        return report;
    }

    @NotNull
    public SNMPSession getSNMPSession() throws Exception {
        return ApacheServerComponent.getSNMPSession(this.snmpClient, this.resourceContext.getPluginConfiguration());
    }

    @NotNull
    public static SNMPSession getSNMPSession(SNMPClient snmpClient, Configuration pluginConfig) throws Exception {
        SNMPSession snmpSession;
        try {
            String host = pluginConfig.getSimple(PLUGIN_CONFIG_PROP_SNMP_AGENT_HOST).getStringValue();
            String portString = pluginConfig.getSimple(PLUGIN_CONFIG_PROP_SNMP_AGENT_PORT).getStringValue();
            int port = Integer.valueOf(portString);
            String community = pluginConfig.getSimple(PLUGIN_CONFIG_PROP_SNMP_AGENT_COMMUNITY).getStringValue();
            snmpSession = snmpClient.getSession(host, port, community, SNMPClient.SNMPVersion.V2C);
        }
        catch (SNMPException e) {
            throw new Exception("Error getting SNMP session: " + e.getMessage(), e);
        }
        return snmpSession;
    }

    @NotNull
    public File getServerRoot() {
        Configuration pluginConfig = this.resourceContext.getPluginConfiguration();
        String serverRoot = ApacheServerComponent.getRequiredPropertyValue(pluginConfig, PLUGIN_CONFIG_PROP_SERVER_ROOT);
        return new File(serverRoot);
    }

    @NotNull
    public File getExecutablePath() {
        File executableFile;
        Configuration pluginConfig = this.resourceContext.getPluginConfiguration();
        String executablePath = pluginConfig.getSimpleValue(PLUGIN_CONFIG_PROP_EXECUTABLE_PATH, null);
        if (executablePath != null) {
            executableFile = this.resolvePathRelativeToServerRoot(executablePath);
        } else {
            SystemInfo systemInfo;
            String serverRoot = null;
            ApacheDirectiveTree tree = this.loadParser();
            List<ApacheDirective> directives = tree.search("/ServerRoot");
            if (!directives.isEmpty() && !directives.get(0).getValues().isEmpty()) {
                serverRoot = directives.get(0).getValues().get(0);
            }
            if ((systemInfo = this.resourceContext.getSystemInformation()).getOperatingSystemType() != OperatingSystemType.WINDOWS) {
                executableFile = new File(serverRoot, "bin/httpd");
                if (!executableFile.exists()) {
                    executableFile = new File(serverRoot, "bin/apache2");
                }
                if (!executableFile.exists()) {
                    executableFile = new File(serverRoot, "bin/apache");
                }
            } else {
                executableFile = new File(serverRoot, "bin/Apache.exe");
            }
        }
        return executableFile;
    }

    public File getHttpdConfFile() {
        Configuration pluginConfig = this.resourceContext.getPluginConfiguration();
        PropertySimple prop = pluginConfig.getSimple(PLUGIN_CONFIG_PROP_HTTPD_CONF);
        if (prop == null || prop.getStringValue() == null) {
            return null;
        }
        return ApacheServerComponent.resolvePathRelativeToServerRoot(pluginConfig, prop.getStringValue());
    }

    @NotNull
    public File getControlScriptPath() {
        Configuration pluginConfig = this.resourceContext.getPluginConfiguration();
        String controlScriptPath = pluginConfig.getSimpleValue(PLUGIN_CONFIG_PROP_CONTROL_SCRIPT_PATH, null);
        File controlScriptFile = null;
        if (controlScriptPath != null) {
            controlScriptFile = this.resolvePathRelativeToServerRoot(controlScriptPath);
        } else {
            String executablePath;
            boolean found = false;
            String serverRoot = null;
            try {
                ApacheDirectiveTree tree = this.loadParser();
                List<ApacheDirective> directives = tree.search("/ServerRoot");
                if (!directives.isEmpty() && !directives.get(0).getValues().isEmpty()) {
                    serverRoot = directives.get(0).getValues().get(0);
                }
            }
            catch (Exception e) {
                this.log.error((Object)"Could not load configuration parser.", (Throwable)e);
            }
            if (serverRoot != null) {
                for (String path : CONTROL_SCRIPT_PATHS) {
                    controlScriptFile = new File(serverRoot, path);
                    if (!controlScriptFile.exists()) continue;
                    found = true;
                    break;
                }
            }
            if (!found && (executablePath = pluginConfig.getSimpleValue(PLUGIN_CONFIG_PROP_EXECUTABLE_PATH, null)) != null) {
                int i = executablePath.lastIndexOf(47);
                executablePath = executablePath.substring(0, i);
                i = executablePath.lastIndexOf(47);
                executablePath = executablePath.substring(0, i);
                for (String path : CONTROL_SCRIPT_PATHS) {
                    controlScriptFile = new File(executablePath, path);
                    if (!controlScriptFile.exists()) continue;
                    found = true;
                    break;
                }
            }
            if (!found) {
                controlScriptFile = this.getExecutablePath();
            }
        }
        return controlScriptFile;
    }

    @NotNull
    public ConfigurationTimestamp getConfigurationTimestamp() {
        AugeasConfigurationApache config = new AugeasConfigurationApache(this.resourceContext.getTemporaryDirectory().getAbsolutePath(), this.resourceContext.getPluginConfiguration());
        return new ConfigurationTimestamp(config.getAllConfigurationFiles());
    }

    public void finishConfigurationUpdate(ConfigurationUpdateReport report) {
        try {
            this.conditionalRestart();
        }
        catch (Exception e) {
            report.setStatus(ConfigurationUpdateStatus.FAILURE);
            report.setErrorMessageFromThrowable((Throwable)e);
        }
    }

    public void finishChildResourceCreate(CreateResourceReport report) {
        try {
            this.conditionalRestart();
        }
        catch (Exception e) {
            report.setStatus(CreateResourceStatus.FAILURE);
            report.setException((Throwable)e);
        }
    }

    public void conditionalRestart() throws Exception {
        Configuration pluginConfig = this.resourceContext.getPluginConfiguration();
        boolean restart = pluginConfig.getSimple(PLUGIN_CONFIG_PROP_RESTART_AFTER_CONFIG_UPDATE).getBooleanValue();
        if (restart) {
            this.operationsDelegate.invokeOperation("graceful_restart", new Configuration());
        }
    }

    public void deleteEmptyFile(AugeasTree tree, AugeasNode deletedNode) {
        File file = tree.getFile(deletedNode);
        List fileContents = tree.match(file.getAbsolutePath() + '/' + "*");
        if (fileContents.size() == 0) {
            file.delete();
        }
    }

    static void addSnmpMetricValueToReport(MeasurementReport report, MeasurementScheduleRequest schedule, SNMPValue snmpValue, boolean valueIsTimestamp) throws SNMPException {
        switch (schedule.getDataType()) {
            case MEASUREMENT: {
                MeasurementDataNumeric metric = new MeasurementDataNumeric(schedule, Double.valueOf(snmpValue.toLong()));
                report.addData(metric);
                break;
            }
            case TRAIT: {
                String stringValue;
                if (valueIsTimestamp) {
                    stringValue = new Date(snmpValue.toLong()).toString();
                } else {
                    stringValue = snmpValue.toString();
                    if (stringValue.startsWith("1.3.6.1.2.1.6.")) {
                        stringValue = stringValue.substring(stringValue.lastIndexOf(46) + 1);
                    }
                }
                MeasurementDataTrait trait = new MeasurementDataTrait(schedule, stringValue);
                report.addData(trait);
                break;
            }
            default: {
                throw new IllegalStateException("SNMP metric request has unsupported data type: " + schedule.getDataType());
            }
        }
    }

    @NotNull
    private File resolvePathRelativeToServerRoot(@NotNull String path) {
        return ApacheServerComponent.resolvePathRelativeToServerRoot(this.resourceContext.getPluginConfiguration(), path);
    }

    @NotNull
    static File resolvePathRelativeToServerRoot(Configuration pluginConfig, @NotNull String path) {
        File file = new File(path);
        if (!file.isAbsolute()) {
            String serverRoot = ApacheServerComponent.getRequiredPropertyValue(pluginConfig, PLUGIN_CONFIG_PROP_SERVER_ROOT);
            file = new File(serverRoot, path);
        }
        return file;
    }

    @NotNull
    static String getRequiredPropertyValue(@NotNull Configuration config, @NotNull String propName) {
        String propValue = config.getSimpleValue(propName, null);
        if (propValue == null) {
            throw new IllegalStateException("Required property '" + propName + "' is not set.");
        }
        return propValue;
    }

    private void startEventPollers() {
        Configuration pluginConfig = this.resourceContext.getPluginConfiguration();
        Boolean enabled = Boolean.valueOf(pluginConfig.getSimpleValue(PLUGIN_CONFIG_PROP_ERROR_LOG_EVENTS_ENABLED, null));
        if (enabled.booleanValue()) {
            String minimumSeverityString;
            File errorLogFile = this.resolvePathRelativeToServerRoot(pluginConfig.getSimpleValue(PLUGIN_CONFIG_PROP_ERROR_LOG_FILE_PATH, DEFAULT_ERROR_LOG_PATH));
            ApacheErrorLogEntryProcessor processor = new ApacheErrorLogEntryProcessor(ERROR_LOG_ENTRY_EVENT_TYPE, errorLogFile);
            String includesPatternString = pluginConfig.getSimpleValue(PLUGIN_CONFIG_PROP_ERROR_LOG_INCLUDES_PATTERN, null);
            if (includesPatternString != null) {
                try {
                    Pattern includesPattern = Pattern.compile(includesPatternString);
                    processor.setIncludesPattern(includesPattern);
                }
                catch (PatternSyntaxException e) {
                    throw new InvalidPluginConfigurationException("Includes pattern [" + includesPatternString + "] is not a valid regular expression.");
                }
            }
            if ((minimumSeverityString = pluginConfig.getSimpleValue(PLUGIN_CONFIG_PROP_ERROR_LOG_MINIMUM_SEVERITY, null)) != null) {
                EventSeverity minimumSeverity = EventSeverity.valueOf((String)minimumSeverityString.toUpperCase());
                processor.setMinimumSeverity(minimumSeverity);
            }
            LogFileEventPoller poller = new LogFileEventPoller(this.eventContext, ERROR_LOG_ENTRY_EVENT_TYPE, errorLogFile, (LogEntryProcessor)processor);
            this.eventContext.registerEventPoller((EventPoller)poller, 60, errorLogFile.getPath());
        }
    }

    private void stopEventPollers() {
        Configuration pluginConfig = this.resourceContext.getPluginConfiguration();
        File errorLogFile = this.resolvePathRelativeToServerRoot(pluginConfig.getSimpleValue(PLUGIN_CONFIG_PROP_ERROR_LOG_FILE_PATH, DEFAULT_ERROR_LOG_PATH));
        this.eventContext.unregisterEventPoller(ERROR_LOG_ENTRY_EVENT_TYPE, errorLogFile.getPath());
    }

    public HttpdAddressUtility getAddressUtility() {
        String version = this.resourceContext.getVersion();
        return HttpdAddressUtility.get(version);
    }

    private String getNewVhostFileName(HttpdAddressUtility.Address address, String mask) {
        String filename = address.host + "_" + address.port;
        String fullPath = mask.replace("*", filename);
        File file = this.getFileRelativeToServerRoot(fullPath);
        int i = 1;
        while (file.exists()) {
            filename = address.host + "_" + address.port + "-" + i++;
            fullPath = mask.replace("*", filename);
            file = this.getFileRelativeToServerRoot(fullPath);
        }
        return file.getAbsolutePath();
    }

    private File getFileRelativeToServerRoot(String path) {
        File f = new File(path);
        if (f.isAbsolute()) {
            return f;
        }
        return new File(this.getServerRoot(), path);
    }

    public ApacheDirectiveTree loadParser() {
        ApacheDirectiveTree tree = new ApacheDirectiveTree();
        ApacheParserImpl parser = new ApacheParserImpl(tree, this.getServerRoot().getAbsolutePath());
        ApacheConfigReader.buildTree(this.getHttpdConfFile().getAbsolutePath(), parser);
        return tree;
    }

    public boolean isAugeasEnabled() {
        Configuration pluginConfig = this.resourceContext.getPluginConfiguration();
        PropertySimple prop = pluginConfig.getSimple(AUGEAS_ENABLED);
        if (prop == null || prop.getStringValue() == null) {
            return false;
        }
        String val = prop.getStringValue();
        if (val.equals("yes")) {
            try {
                Augeas ag = new Augeas();
            }
            catch (Exception e) {
                this.log.error((Object)"Augeas is enabled in configuration but was not found on the system.");
                throw new RuntimeException(CONFIGURATION_NOT_SUPPORTED_ERROR_MESSAGE);
            }
            String version = this.resourceContext.getVersion();
            if (!version.startsWith("2.")) {
                this.log.error((Object)CONFIGURATION_NOT_SUPPORTED_ERROR_MESSAGE);
                throw new RuntimeException(CONFIGURATION_NOT_SUPPORTED_ERROR_MESSAGE);
            }
            return true;
        }
        return false;
    }
}

