/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.apache.parser;

import java.util.ArrayList;
import java.util.List;
import org.rhq.plugins.apache.parser.ApacheDirective;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApacheDirectiveTree {
    private ApacheDirective rootNode = new ApacheDirective();

    public ApacheDirectiveTree() {
        this.rootNode.setRootNode(true);
    }

    public ApacheDirective getRootNode() {
        return this.rootNode;
    }

    public void setRootNode(ApacheDirective rootNode) {
        this.rootNode = rootNode;
    }

    public List<ApacheDirective> search(ApacheDirective nd, String name) {
        return this.parseExpr(nd, name);
    }

    public List<ApacheDirective> search(String name) {
        if (name.startsWith("/")) {
            return this.parseExpr(this.rootNode, name.substring(1));
        }
        return this.parseExpr(this.rootNode, name);
    }

    private List<ApacheDirective> parseExpr(ApacheDirective nd, String expr) {
        int index = expr.indexOf("/");
        String name = index == -1 ? expr : expr.substring(0, index);
        ArrayList<ApacheDirective> nds = new ArrayList<ApacheDirective>();
        for (ApacheDirective dir : nd.getChildByName(name)) {
            if (index == -1) {
                nds.add(dir);
                continue;
            }
            List<ApacheDirective> tempNodes = this.parseExpr(dir, expr.substring(index + 1));
            if (tempNodes == null) continue;
            nds.addAll(tempNodes);
        }
        return nds;
    }

    public ApacheDirective createNode(ApacheDirective parentNode, String name) {
        ApacheDirective dir = new ApacheDirective(name);
        dir.setParentNode(parentNode);
        parentNode.addChildDirective(dir);
        return dir;
    }
}

