/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.apache.augeas.mappingImpl;

import java.util.ArrayList;
import java.util.List;
import org.rhq.augeas.node.AugeasNode;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyList;
import org.rhq.core.domain.configuration.PropertyMap;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.configuration.definition.PropertyDefinition;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionList;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionMap;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionSimple;
import org.rhq.plugins.apache.mapping.ApacheDirectiveRegExpression;
import org.rhq.plugins.apache.mapping.ConfigurationToAugeasApacheBase;
import org.rhq.rhqtransform.AugeasRhqException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MappingToAugeasDirectivePerMapIndex
extends ConfigurationToAugeasApacheBase {
    @Override
    public void updateList(PropertyDefinitionList propDef, Property prop, AugeasNode listNode, int seq) throws AugeasRhqException {
        int i;
        String name = propDef.getName();
        List nodes = this.tree.matchRelative(listNode, name);
        PropertyList property = (PropertyList)prop;
        if (prop == null) {
            for (AugeasNode node : nodes) {
                node.remove(false);
            }
            return;
        }
        int nr = property.getList().size();
        if (nodes.size() > nr) {
            for (i = 0; i < nodes.size() - nr; ++i) {
                ((AugeasNode)nodes.get(nr + i)).remove(false);
            }
        }
        if (nodes.size() < nr) {
            for (i = 0; i < nr - nodes.size(); ++i) {
                this.tree.createNode(listNode, name, null, nodes.size() + i + 1);
            }
        }
        nodes = this.tree.matchRelative(listNode, name);
        PropertyDefinition memberPropDef = propDef.getMemberDefinition();
        int i2 = 0;
        List<PropertyMap> propertyMap = this.sort(property);
        for (PropertyMap pr : propertyMap) {
            this.updateProperty(memberPropDef, (Property)pr, (AugeasNode)nodes.get(i2), i2);
            ++i2;
        }
    }

    @Override
    public void updateMap(PropertyDefinitionMap propDefMap, Property prop, AugeasNode mapNode, int seq) throws AugeasRhqException {
        PropertyMap propMap = (PropertyMap)prop;
        String propertyName = prop.getName();
        StringBuffer param = new StringBuffer();
        for (PropertyDefinition propVal : propDefMap.getPropertyDefinitions().values()) {
            String value;
            PropertySimple property = propMap.getSimple(propVal.getName());
            if (property == null || property.getName().equals("_index") || (value = property.getStringValue()) == null) continue;
            param.append(" " + value);
        }
        List<String> params = ApacheDirectiveRegExpression.createParams(param.toString(), propertyName);
        List nodes = mapNode.getChildByLabel("param");
        if (params.size() > nodes.size()) {
            for (int i = 0; i < params.size() - nodes.size(); ++i) {
                this.tree.createNode(mapNode, "param", null, nodes.size() + i + 1);
            }
        }
        if (params.size() < nodes.size()) {
            for (int i = 0; i < nodes.size() - params.size(); ++i) {
                ((AugeasNode)nodes.get(params.size() + i)).remove(false);
            }
        }
        nodes = this.tree.matchRelative(mapNode, "param");
        int i = 0;
        for (String value : params) {
            ((AugeasNode)nodes.get(i)).setValue(value);
            ++i;
        }
    }

    @Override
    public void updateSimple(AugeasNode parentNode, PropertyDefinitionSimple propDef, Property prop, int seq) throws AugeasRhqException {
    }

    private List<PropertyMap> sort(PropertyList list) {
        ArrayList<PropertyMap> map = new ArrayList<PropertyMap>();
        int next = Integer.MAX_VALUE;
        int min = 0;
        int count = 0;
        while (count < list.getList().size()) {
            for (Property prop : list.getList()) {
                PropertyMap propMap = (PropertyMap)prop;
                PropertySimple propSim = (PropertySimple)propMap.get("_index");
                int value = propSim == null | propSim.getIntegerValue() == null ? 0 : propSim.getIntegerValue();
                if (value == min) {
                    map.add(propMap);
                    ++count;
                }
                if (!(value > min & value < next)) continue;
                next = value;
            }
            min = next;
            next = Integer.MAX_VALUE;
        }
        return map;
    }
}

