/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.apache;

import java.io.File;
import java.net.URI;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import net.augeas.AugeasException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.augeas.node.AugeasNode;
import org.rhq.augeas.tree.AugeasTree;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.plugins.apache.ApacheServerComponent;
import org.rhq.plugins.apache.util.HttpdAddressUtility;
import org.rhq.plugins.www.snmp.SNMPException;
import org.rhq.plugins.www.snmp.SNMPSession;
import org.rhq.plugins.www.snmp.SNMPValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApacheVirtualHostServiceDiscoveryComponent
implements ResourceDiscoveryComponent<ApacheServerComponent> {
    public static final String LOGS_DIRECTORY_NAME = "logs";
    private static final String RT_LOG_FILE_NAME_SUFFIX = "_rt.log";
    private static final Log log = LogFactory.getLog(ApacheVirtualHostServiceDiscoveryComponent.class);

    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext<ApacheServerComponent> context) throws InvalidPluginConfigurationException, Exception {
        LinkedHashSet<DiscoveredResourceDetails> discoveredResources = new LinkedHashSet<DiscoveredResourceDetails>();
        AugeasTree ag = null;
        ApacheServerComponent serverComponent = (ApacheServerComponent)context.getParentResourceComponent();
        try {
            ag = serverComponent.getAugeasTree();
        }
        catch (AugeasException e) {
            try {
                this.discoverUsingSnmp(context, discoveredResources);
            }
            catch (Exception se) {
                log.warn((Object)"Neither Augeas nor SNMP module was found installed on this machine/Apache server. No virtual hosts can be found.");
            }
            return discoveredResources;
        }
        this.discoverMainServer(context, discoveredResources);
        ResourceType resourceType = context.getResourceType();
        File configPath = serverComponent.getServerRoot();
        File logsDir = new File(configPath, LOGS_DIRECTORY_NAME);
        List virtualHosts = ag.matchRelative(ag.getRootNode(), "<VirtualHost");
        for (AugeasNode node : virtualHosts) {
            List hosts = ag.matchRelative(node, "param");
            String firstAddress = ((AugeasNode)hosts.get(0)).getValue();
            List serverNames = ag.matchRelative(node, "ServerName/param");
            String serverName = null;
            if (serverNames.size() > 0) {
                serverName = ((AugeasNode)serverNames.get(0)).getValue();
            }
            StringBuilder keyBuilder = new StringBuilder();
            if (serverName != null) {
                keyBuilder.append(serverName).append("|");
            }
            keyBuilder.append(firstAddress);
            Iterator it = hosts.iterator();
            it.next();
            while (it.hasNext()) {
                keyBuilder.append(" ").append(((AugeasNode)it.next()).getValue());
            }
            String resourceKey = keyBuilder.toString();
            Configuration pluginConfiguration = context.getDefaultPluginConfiguration();
            HttpdAddressUtility.Address address = serverComponent.getAddressUtility().getVirtualHostSampleAddress(ag, firstAddress, serverName);
            if (address != null) {
                String url = "http://" + address.host + ":" + address.port + "/";
                PropertySimple urlProp = new PropertySimple("url", (Object)url);
                pluginConfiguration.put((Property)urlProp);
            }
            File rtLogFile = new File(logsDir, address.host + address.port + RT_LOG_FILE_NAME_SUFFIX);
            PropertySimple rtLogProp = new PropertySimple("responseTimeLogFile", (Object)rtLogFile.toString());
            pluginConfiguration.put((Property)rtLogProp);
            String resourceName = serverName != null ? address.host + ":" + address.port : resourceKey;
            discoveredResources.add(new DiscoveredResourceDetails(resourceType, resourceKey, resourceName, null, null, pluginConfiguration, null));
        }
        return discoveredResources;
    }

    private void discoverUsingSnmp(ResourceDiscoveryContext<ApacheServerComponent> context, Set<DiscoveredResourceDetails> discoveredResources) throws Exception {
        SNMPValue descValue;
        List<SNMPValue> portValues;
        List<SNMPValue> nameValues;
        SNMPSession snmpSession = ((ApacheServerComponent)context.getParentResourceComponent()).getSNMPSession();
        try {
            nameValues = snmpSession.getColumn("wwwServiceName");
        }
        catch (SNMPException e) {
            throw new Exception("Error getting SNMP column: wwwServiceName: " + e.getMessage(), e);
        }
        try {
            portValues = snmpSession.getColumn("wwwServiceProtocol");
        }
        catch (SNMPException e) {
            throw new Exception("Error getting SNMP column: wwwServiceProtocol: " + e.getMessage(), e);
        }
        try {
            descValue = snmpSession.getNextValue("wwwServiceDescription");
        }
        catch (SNMPException e) {
            throw new Exception("Error getting SNMP value: wwwServiceDescription: " + e.getMessage(), e);
        }
        ApacheServerComponent parentApacheComponent = (ApacheServerComponent)context.getParentResourceComponent();
        File configPath = parentApacheComponent.getServerRoot();
        File logsDir = new File(configPath, LOGS_DIRECTORY_NAME);
        for (int i = 0; i < nameValues.size(); ++i) {
            SNMPValue nameValue = nameValues.get(i);
            String host = nameValue.toString();
            SNMPValue portValue = portValues.get(i);
            String fullPort = portValue.toString();
            String portString = fullPort.substring(fullPort.lastIndexOf(".") + 1);
            int port = Integer.parseInt(portString);
            port = port == 0 ? 80 : port;
            String key = host + ":" + port;
            String name = "Virtual Host " + key;
            String version = null;
            String desc = descValue.toString();
            DiscoveredResourceDetails resourceDetails = new DiscoveredResourceDetails(context.getResourceType(), key, name, version, desc, null, null);
            Configuration pluginConfig = resourceDetails.getPluginConfiguration();
            String url = "http://" + host + ":" + port + "/";
            PropertySimple urlProp = new PropertySimple("url", (Object)url);
            pluginConfig.put((Property)urlProp);
            String rtLogFileName = host + port + RT_LOG_FILE_NAME_SUFFIX;
            File rtLogFile = new File(logsDir, rtLogFileName);
            pluginConfig.put((Property)new PropertySimple("responseTimeLogFile", (Object)rtLogFile));
            discoveredResources.add(resourceDetails);
        }
    }

    private void discoverMainServer(ResourceDiscoveryContext<ApacheServerComponent> context, Set<DiscoveredResourceDetails> discoveredResources) throws Exception {
        ResourceType resourceType = context.getResourceType();
        Configuration mainServerPluginConfig = context.getDefaultPluginConfiguration();
        File configPath = ((ApacheServerComponent)context.getParentResourceComponent()).getServerRoot();
        File logsDir = new File(configPath, LOGS_DIRECTORY_NAME);
        String mainServerUrl = context.getParentResourceContext().getPluginConfiguration().getSimple("url").getStringValue();
        if (mainServerUrl != null && !"null".equals(mainServerUrl)) {
            PropertySimple mainServerUrlProp = new PropertySimple("url", (Object)mainServerUrl);
            mainServerPluginConfig.put((Property)mainServerUrlProp);
            URI mainServerUri = new URI(mainServerUrl);
            String host = mainServerUri.getHost();
            int port = mainServerUri.getPort();
            if (port == -1) {
                port = 80;
            }
            File rtLogFile = new File(logsDir, host + port + RT_LOG_FILE_NAME_SUFFIX);
            PropertySimple rtLogProp = new PropertySimple("responseTimeLogFile", (Object)rtLogFile.toString());
            mainServerPluginConfig.put((Property)rtLogProp);
        }
        DiscoveredResourceDetails mainServer = new DiscoveredResourceDetails(resourceType, "MainServer", "Main", null, null, mainServerPluginConfig, null);
        discoveredResources.add(mainServer);
    }
}

